/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.util.ArrayList;

public class SaverUtil {
    private static final Object LOCK = new Object();
    private SaveConfig saveConfig = new SaveConfig();
    private static final SaverInternalThread saverThread = new SaverInternalThread();
    private static ArrayList<SaveConfig> allSavers = new ArrayList();

    public void terminate() {
        saverThread.die();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipDelayIfSaveScheduled() {
        Object object = LOCK;
        synchronized (object) {
            if (this.saveConfig.saveTime == 0L) {
                return;
            }
            this.saveNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaverUtil(String desc, int periodMS, SaveListener saveListener, boolean ensureSaveWithinPeriod) {
        this.saveConfig.periodMS = periodMS;
        this.saveConfig.ensureSaveWithinPeriod = ensureSaveWithinPeriod;
        this.saveConfig.saveUtil = this;
        this.saveConfig.saveListener = saveListener;
        this.saveConfig.desc = desc;
        Object object = LOCK;
        synchronized (object) {
            allSavers.add(this.saveConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNow() {
        Object object = LOCK;
        synchronized (object) {
            this.saveConfig.saveTime = System.currentTimeMillis() - 1000L;
            LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferSave() {
        Object object = LOCK;
        synchronized (object) {
            if (this.saveConfig.saveTime == 0L) {
                return;
            }
            this.queueSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSave() {
        Object object = LOCK;
        synchronized (object) {
            if (this.saveConfig.saveTime == 0L) {
                return;
            }
            this.saveConfig.saveTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSave() {
        Object object = LOCK;
        synchronized (object) {
            if (this.saveConfig.saveTime == 0L || !this.saveConfig.ensureSaveWithinPeriod) {
                this.saveConfig.saveTime = System.currentTimeMillis() + (long)this.saveConfig.periodMS;
                LOCK.notify();
            }
        }
    }

    static class SaverInternalThread
    extends Thread {
        private boolean die = false;

        public SaverInternalThread() {
            super("SaverInternalThread");
            this.start();
        }

        private SaveConfig getNextConfigToSave() {
            SaveConfig result = null;
            for (SaveConfig config : allSavers) {
                if (config.saveTime == 0L || result != null && result.saveTime <= config.saveTime) continue;
                result = config;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.die) {
                SaveConfig nextConfig = null;
                Object object = LOCK;
                synchronized (object) {
                    nextConfig = this.getNextConfigToSave();
                    try {
                        while (nextConfig == null || System.currentTimeMillis() < nextConfig.saveTime) {
                            if (nextConfig == null) {
                                LOCK.wait();
                            } else {
                                LOCK.wait(Math.max(50L, nextConfig.saveTime - System.currentTimeMillis()));
                            }
                            if (this.die) {
                                return;
                            }
                            nextConfig = this.getNextConfigToSave();
                        }
                        nextConfig.saveTime = 0L;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("[SaverUtil] Saving " + nextConfig + " now");
                try {
                    nextConfig.saveListener.performSave();
                }
                catch (Throwable t) {
                    System.out.println("[SaveUtil] ERROR: Unable to save " + nextConfig);
                    t.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void die() {
            this.die = true;
            Object object = LOCK;
            synchronized (object) {
                LOCK.notifyAll();
            }
        }
    }

    class SaveConfig {
        private long saveTime = 0L;
        private int periodMS = 3000;
        private SaverUtil saveUtil;
        public SaveListener saveListener;
        private String desc;
        public boolean ensureSaveWithinPeriod;

        SaveConfig() {
        }

        public String getDescription() {
            return this.desc;
        }

        public String toString() {
            return this.desc;
        }
    }

    public static interface SaveListener {
        public void performSave();
    }
}

