/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessPrinter {
    Printer pout;
    Printer perr;

    public static void printAllOutputToStdout(Process p) {
        new ProcessPrinter(p, System.out, System.out);
    }

    public static ByteArrayOutputStream printAllToByteArray(Process p) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ProcessPrinter(p, bout, bout);
        return bout;
    }

    public void closeAll() {
        try {
            this.pout.in.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.perr.in.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ProcessPrinter(Process p, OutputStream out, OutputStream err) {
        this(p, out, err, false);
    }

    public ProcessPrinter(Process p, OutputStream out, OutputStream err, boolean makeDaemon) {
        this.pout = new Printer(makeDaemon);
        this.pout.in = p.getInputStream();
        this.pout.out = out;
        this.pout.start();
        this.perr = new Printer(makeDaemon);
        this.perr.in = p.getErrorStream();
        this.perr.out = err;
        this.perr.start();
    }

    public void join() throws InterruptedException {
        this.perr.join();
    }

    public void waitForAllOutput() throws InterruptedException {
        this.pout.join();
        this.perr.join();
    }

    public boolean isAlive() {
        return this.perr.isAlive();
    }

    class Printer
    extends Thread {
        InputStream in;
        OutputStream out;
        IOException exception;

        public Printer() {
            this(false);
        }

        public Printer(boolean daemon) {
            super("utils.vm.ProcessPrinter$Printer");
            this.setDaemon(daemon);
        }

        @Override
        public void run() {
            try {
                byte[] buf = new byte[1024];
                int n = 0;
                while (n != -1) {
                    n = this.in.read(buf, 0, 1024);
                    if (n <= 0 || this.out == null) continue;
                    this.out.write(buf, 0, n);
                }
            }
            catch (IOException e) {
                this.exception = e;
            }
        }
    }
}

