/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.util.ArrayList;
import java.util.Date;
import utils.progtools.BatchingTimedThread;
import utils.progtools.BatchingTimedThreadLock;
import utils.progtools.OnDemandBatchProcessor;

public class OnDemandBatchPool<T> {
    Object LOCK = new Object();
    ArrayList<T> jobs = new ArrayList();
    BatchingTimedThreadLock batchLock;
    OnDemandBatchProcessor<T> listener;

    public OnDemandBatchPool(int batchingDelayMs, OnDemandBatchProcessor<T> listener) {
        this.batchLock = new BatchingTimedThreadLock(batchingDelayMs);
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(T job) {
        Object object = this.LOCK;
        synchronized (object) {
            this.jobs.add(job);
        }
        new BatchProcessor(this.batchLock).startIfNecessary();
    }

    public static void main(String[] args) {
        System.out.println(new Date());
        OnDemandBatchPool<Integer> pool = new OnDemandBatchPool<Integer>(100, new TestBatchProcessor());
        for (int i = 0; i < 1000000; ++i) {
            pool.addToQueue(i);
        }
    }

    static class TestBatchProcessor
    implements OnDemandBatchProcessor<Integer> {
        TestBatchProcessor() {
        }

        @Override
        public void process(ArrayList<Integer> jobs) {
            System.out.println(jobs.size() + "x batch (" + new Date() + ")");
        }
    }

    class BatchProcessor
    extends BatchingTimedThread {
        public BatchProcessor(BatchingTimedThreadLock LOCK) {
            super(LOCK);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runNow() {
            ArrayList batch;
            Object object = OnDemandBatchPool.this.LOCK;
            synchronized (object) {
                batch = OnDemandBatchPool.this.jobs;
                OnDemandBatchPool.this.jobs = new ArrayList();
            }
            OnDemandBatchPool.this.listener.process(batch);
        }
    }
}

