/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import utils.progtools.TimeoutMap;
import utils.progtools.TimeoutMapListener;
import utils.switches.Switches;

public class FileCleanup {
    TimeoutMap.NoKeyTimeoutMap<FileInputStream> map = new TimeoutMap.NoKeyTimeoutMap();

    public FileInputStream get(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        if (Switches.SH_1639_timeoutUnclosedFiles) {
            this.map.add(fin, 180000L, new FileInputStreamCleanup(file.getName()));
        }
        return fin;
    }

    public FileInputStream get(String file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        if (Switches.SH_1639_timeoutUnclosedFiles) {
            this.map.add(fin, 180000L, new FileInputStreamCleanup(file));
        }
        return fin;
    }

    class FileInputStreamCleanup
    implements TimeoutMapListener<String, FileInputStream> {
        Exception trace;

        public FileInputStreamCleanup(File filename) {
            this(filename.getName());
        }

        public FileInputStreamCleanup(String filename) {
            this.trace = new Exception("Unclosed File Trace for " + filename);
        }

        @Override
        public void objectTimedOut(String key, FileInputStream in) {
            try {
                in.available();
                this.trace.printStackTrace();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

