/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import utils.progtools.URIUtil;

public class AutoFetchURL
extends Thread {
    private static final HashMap<String, AutoFetchURL> allUrls = new HashMap();
    private final URL url;
    private final int delay;
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream();
    private IOException error;
    private static final Object LOCK = new Object();

    public static void preFetchUrl(String url, int delay) throws MalformedURLException {
        URL urlObject = new URL(url);
        urlObject = URIUtil.tryGetSafeURLFrom(urlObject);
        AutoFetchURL.preFetchUrl(urlObject, delay);
    }

    private static void preFetchUrl(URL url, int delay) {
        System.out.println("[AutoFetchURL] prefetching " + url + " (+" + delay + ")");
        allUrls.put(url.toString(), new AutoFetchURL(url, delay));
    }

    public static AutoFetchURL getPreFetchedURL(URL url) {
        return allUrls.get(url.toString());
    }

    private AutoFetchURL(URL url, int delay) {
        this.url = url;
        this.delay = delay;
        this.start();
    }

    @Override
    public void run() {
        try {
            try {
                if (this.delay > 0) {
                    Thread.sleep(this.delay);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputStream in = AutoFetchURL.getInputStreamAndHandleTLSDowngrade(this.url, null);
            byte[] buf = new byte[20000];
            int n = 0;
            while (n != -1) {
                n = in.read(buf);
                if (n <= 0) continue;
                this.bout.write(buf, 0, n);
            }
        }
        catch (IOException x) {
            this.error = x;
        }
    }

    public InputStream getAsLocalStream(long timeout) throws IOException {
        return new ByteArrayInputStream(this.getAsBytes(timeout));
    }

    public String getAsUTF8(long timeout) throws IOException {
        return new String(this.getAsBytes(timeout), "UTF8");
    }

    private byte[] getAsBytes(long timeout) throws IOException {
        try {
            this.join(timeout);
        }
        catch (InterruptedException x) {
            throw new IOException("Interrupted");
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.bout.toByteArray();
    }

    public static InputStream getInputStreamAndHandleTLSDowngrade(URL url) throws IOException {
        return AutoFetchURL.getInputStreamAndHandleTLSDowngrade(url, null, null);
    }

    public static InputStream getInputStreamAndHandleTLSDowngrade(URL url, URLConnectionInitialiser connectionInitialiser) throws IOException {
        return AutoFetchURL.getInputStreamAndHandleTLSDowngrade(url, connectionInitialiser, null);
    }

    public static InputStream getInputStreamAndHandleTLSDowngrade(URL url, URLConnectionInitialiser connectionInitialiser, Proxy proxy) throws IOException {
        BufferedInputStream in = null;
        ArrayList<String> supportedProtocols = new ArrayList<String>();
        String property = System.getProperty("https.protocols");
        if (property != null) {
            String[] protocols;
            for (String s : protocols = property.split("\\,")) {
                supportedProtocols.add(s.trim());
            }
        }
        boolean success = false;
        while (!success) {
            try {
                URLConnection urlConnection = proxy != null ? url.openConnection(proxy) : url.openConnection();
                if (connectionInitialiser != null && !connectionInitialiser.initialiseURLConnection(urlConnection)) {
                    return null;
                }
                in = new BufferedInputStream(urlConnection.getInputStream());
                success = true;
            }
            catch (IllegalArgumentException ex) {
                String message = ex.getMessage();
                if (message != null && supportedProtocols.size() > 0) {
                    System.out.println("[AutoFetchURL] Failed with " + ex.getClass().getName() + ": " + message);
                    String match = null;
                    for (String protocol : supportedProtocols) {
                        if (!protocol.equalsIgnoreCase(message)) continue;
                        match = protocol;
                        break;
                    }
                    if (match != null && supportedProtocols.remove(match)) {
                        StringBuilder newProperty = new StringBuilder();
                        for (int i = 0; i < supportedProtocols.size(); ++i) {
                            if (i > 0) {
                                newProperty.append(",");
                            }
                            newProperty.append((String)supportedProtocols.get(i));
                        }
                        System.setProperty("https.protocols", newProperty.toString());
                        continue;
                    }
                }
                throw ex;
            }
        }
        return in;
    }

    public static class URLConnectionHandler
    implements URLConnectionInitialiser {
        public URLConnection connection;

        @Override
        public boolean initialiseURLConnection(URLConnection urlConnection) {
            this.connection = urlConnection;
            return true;
        }
    }

    public static interface URLConnectionInitialiser {
        public boolean initialiseURLConnection(URLConnection var1);
    }
}

