/*
 * Decompiled with CFR 0.152.
 */
package utils.ostools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import utils.progtools.ProcessPrinter;

public class RunCommandGetOutput {
    public static final int STDOUT = 0;
    public static final int STDERR = 1;
    private static final boolean WAIT_FOR_OUTPUT = true;

    public static void runCommandIgnoreOutput(String cmd) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.getOutputStream().close();
            ProcessPrinter processPrinter = new ProcessPrinter(p, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runCommandNoWait(String cmd) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.getOutputStream().close();
            ProcessPrinter processPrinter = new ProcessPrinter(p, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runCommandNoWait(String[] cmd) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.getOutputStream().close();
            ProcessPrinter processPrinter = new ProcessPrinter(p, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[] runCommandGetOutput(String cmd) {
        return RunCommandGetOutput.runCommandGetOutput(cmd, null);
    }

    public static String[] runCommandGetOutput(String cmd, File wdir) {
        try {
            Process p = Runtime.getRuntime().exec(cmd, null, wdir);
            p.getOutputStream().close();
            ByteArrayOutputStream sout = new ByteArrayOutputStream();
            ByteArrayOutputStream eout = new ByteArrayOutputStream();
            ProcessPrinter pp = new ProcessPrinter(p, sout, eout);
            p.waitFor();
            pp.waitForAllOutput();
            return new String[]{new String(sout.toByteArray()), new String(eout.toByteArray())};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] runCommandGetOutput(String[] cmd) {
        return RunCommandGetOutput.runCommandGetOutput(cmd, null);
    }

    public static String[] runCommandGetOutput(String[] cmd, File workingDirectory) {
        CommandResponse response = RunCommandGetOutput.runCommand(cmd, workingDirectory);
        if (response == null || response.error != null) {
            return null;
        }
        return new String[]{response.stdout, response.stderr};
    }

    public static String[] runCommandGetOutputThrowErrors(String cmd) throws Exception {
        Process p = Runtime.getRuntime().exec(cmd);
        p.getOutputStream().close();
        ByteArrayOutputStream sout = new ByteArrayOutputStream();
        ByteArrayOutputStream eout = new ByteArrayOutputStream();
        ProcessPrinter pp = new ProcessPrinter(p, sout, eout);
        p.waitFor();
        pp.waitForAllOutput();
        return new String[]{new String(sout.toByteArray()), new String(eout.toByteArray())};
    }

    public static int getReturnCode(String[] cmd) {
        try {
            CommandResponse commandResponse = RunCommandGetOutput.runCommand(cmd, null, false, false);
            if (commandResponse != null) {
                return commandResponse.returnCode;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public static CommandResponse runCommand(String[] cmd, File wdir, boolean getOutput, boolean throwErrors) throws Exception {
        try {
            ProcessPrinter pp;
            Process p = Runtime.getRuntime().exec(cmd, null, wdir);
            p.getOutputStream().close();
            ByteArrayOutputStream sout = null;
            ByteArrayOutputStream eout = null;
            if (getOutput) {
                sout = new ByteArrayOutputStream();
                eout = new ByteArrayOutputStream();
                pp = new ProcessPrinter(p, sout, eout);
            } else {
                pp = new ProcessPrinter(p, System.out, System.err);
            }
            int ret = p.waitFor();
            pp.waitForAllOutput();
            CommandResponse response = new CommandResponse();
            response.returnCode = ret;
            if (getOutput) {
                response.stdout = sout.toString();
                response.stderr = eout.toString();
            }
            return response;
        }
        catch (Exception e) {
            if (throwErrors) {
                throw e;
            }
            CommandResponse response = new CommandResponse();
            response.error = e;
            return response;
        }
    }

    public static CommandResponse runCommand(String[] cmd) {
        try {
            return RunCommandGetOutput.runCommand(cmd, null, true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CommandResponse runCommand(String[] cmd, File workingDirectory) {
        try {
            return RunCommandGetOutput.runCommand(cmd, workingDirectory, true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class CommandResponse {
        public String stdout = null;
        public String stderr = null;
        public int returnCode = -1;
        public Exception error = null;

        public boolean returned() {
            return this.returnCode != -1 && this.error == null;
        }
    }
}

