/*
 * Decompiled with CFR 0.152.
 */
package utils.ostools;

import java.io.File;
import utils.ostools.OS;

public class OSDirs {
    public static File getDesktopDir() {
        return new File(System.getProperty("user.home"), "Desktop");
    }

    public static File getDocumentsDir() {
        File f;
        if (OS.isWindows() && (f = new File(System.getProperty("user.home"), "My Documents")).exists()) {
            return f;
        }
        return new File(System.getProperty("user.home"), "Documents");
    }

    public static File getDownloadsDir() {
        return new File(System.getProperty("user.home"), "Downloads");
    }

    public static File getTrialFile(String dirname) {
        if (OS.isWindowsVistaOrAbove()) {
            String dir = OSDirs.getNonDesktopSubDir("user.home", "appdata\\locallow\\" + dirname);
            return new File(dir);
        }
        String dir = OSDirs.getNonDesktopSubDir("user.home", dirname);
        return new File(dir);
    }

    private static String getNonDesktopSubDir(String sysprop, String subdir) {
        String userdir = System.getProperty(sysprop);
        if (userdir.endsWith("/")) {
            userdir = userdir.substring(0, userdir.length() - 1);
        }
        if (userdir.endsWith("\\")) {
            userdir = userdir.substring(0, userdir.length() - 1);
        }
        if (userdir.replace('\\', '/').toLowerCase().endsWith("/desktop")) {
            userdir = userdir.substring(0, userdir.length() - "/desktop".length());
        }
        String dir = userdir + "/" + subdir;
        return dir;
    }
}

