/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats.windows;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import utils.message.Message;
import utils.osstats.types.BasicInfo;
import utils.osstats.types.DiskConfig;
import utils.osstats.types.MemoryConfig;
import utils.osstats.types.ProcessorConfig;
import utils.osstats.winutils.WMIRegistry;
import utils.osstats.winutils.WMIResults;
import utils.osstats.winutils.WMIUtils;

public class WindowsBasicInfo
extends BasicInfo {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    public String biosReleaseDate;
    public String biosVersion;
    public String biosVendor;
    public String biosName;
    public String systemVersion;

    public WindowsBasicInfo() {
        this.readBasicInfo();
    }

    public WindowsBasicInfo(boolean fake) {
        super(fake);
        if (fake) {
            this.biosName = "Avanced Phoenix";
            this.biosVendor = "Intel Corp.";
            this.biosReleaseDate = "21/07/2014";
            this.biosVersion = "6.18.5.10";
            this.systemVersion = "1.2";
        }
    }

    public WindowsBasicInfo(Message loadFromMessage) {
        this.loadFromMessage(loadFromMessage);
    }

    @Override
    protected void loadFromMessage(Message m) {
        super.loadFromMessage(m);
        this.biosReleaseDate = m.getNextString();
        this.biosVersion = m.getNextString();
        this.biosVendor = m.getNextString();
        this.biosName = m.getNextString();
        this.systemVersion = m.getNextString();
    }

    @Override
    public Message toMessage() {
        Message m = super.toMessage();
        m.append(this.biosReleaseDate);
        m.append(this.biosVersion);
        m.append(this.biosVendor);
        m.append(this.biosName);
        m.append(this.systemVersion);
        return m;
    }

    private String getWindowsMemoryType(String typeString) {
        int type = 0;
        if (typeString != null) {
            try {
                type = Integer.parseInt(typeString);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        switch (type) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Other";
            }
            case 2: {
                return "DRAM";
            }
            case 3: {
                return "Synchronous DRAM";
            }
            case 4: {
                return "Cache DRAM";
            }
            case 5: {
                return "EDO";
            }
            case 6: {
                return "EDRAM";
            }
            case 7: {
                return "VRAM";
            }
            case 8: {
                return "SRAM";
            }
            case 9: {
                return "RAM";
            }
            case 10: {
                return "ROM";
            }
            case 11: {
                return "Flash";
            }
            case 12: {
                return "EEPROM";
            }
            case 13: {
                return "FEPROM";
            }
            case 14: {
                return "EPROM";
            }
            case 15: {
                return "CDRAM";
            }
            case 16: {
                return "3DRAM";
            }
            case 17: {
                return "SDRAM";
            }
            case 18: {
                return "SGRAM";
            }
            case 19: {
                return "RDRAM";
            }
            case 20: {
                return "DDR";
            }
            case 21: {
                return "DDR2";
            }
            case 22: {
                return "DDR2 FB-DIMM";
            }
            case 24: {
                return "DDR3";
            }
            case 25: {
                return "FBD2";
            }
        }
        return "Unknown";
    }

    @Override
    protected void readBasicInfo() {
        WMIResults wmiResults;
        try {
            wmiResults = WMIRegistry.getProvider().queryWMI("SELECT SerialNumber,Version,Name,Manufacturer from Win32_BIOS");
            this.serial = WMIUtils.getFirstValue(wmiResults, "SerialNumber");
            this.biosVersion = WMIUtils.getFirstValue(wmiResults, "Version");
            this.biosVendor = WMIUtils.getFirstValue(wmiResults, "Manufacturer");
            this.biosName = WMIUtils.getFirstValue(wmiResults, "Name");
            this.biosReleaseDate = WMIUtils.getFirstValue(wmiResults, "ReleaseDate");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            wmiResults = WMIRegistry.getProvider().queryWMI("SELECT IdentifyingNumber,Version,Vendor,Name from Win32_ComputerSystemProduct");
            this.systemVersion = WMIUtils.getFirstValue(wmiResults, "Version");
            this.computerModelManufacturer = WMIUtils.getFirstValue(wmiResults, "Vendor");
            this.computerModelName = WMIUtils.getFirstValue(wmiResults, "Name");
            this.computerModelIdentifier = WMIUtils.getFirstValue(wmiResults, "IdentifyingNumber");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            wmiResults = WMIRegistry.getProvider().queryWMI("SELECT TotalVisibleMemorySize, LastBootUpTime from Win32_OperatingSystem");
            long total = Long.parseLong(WMIUtils.getFirstValue(wmiResults, "TotalVisibleMemorySize"));
            this.memoryTotalBytes = total * 1024L;
            String uptime = WMIUtils.getFirstValue(wmiResults, "LastBootUpTime");
            if (uptime != null) {
                try {
                    this.lastBootTime = this.sdf.parse(uptime).getTime();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.lastBootTime = -1L;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            wmiResults = WMIRegistry.getProvider().queryWMI("SELECT * from Win32_Processor");
            Properties[] allResults = wmiResults.getProperties();
            this.processorConfig = new ProcessorConfig[allResults.length];
            for (int i = 0; i < allResults.length; ++i) {
                String speed;
                ProcessorConfig processor = new ProcessorConfig();
                String width = allResults[i].getProperty("AddressWidth");
                processor.is64bit = width != null && width.equals("64");
                processor.coreCount = 1;
                String cores = allResults[i].getProperty("NumberOfCores");
                if (cores != null) {
                    processor.coreCount = Integer.parseInt(cores);
                }
                if ((speed = allResults[i].getProperty("MaxClockSpeed")) != null) {
                    try {
                        Long speedMHz = Long.parseLong(speed);
                        processor.processorSpeedHz = speedMHz * 1000L * 1000L;
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                processor.processorName = allResults[i].getProperty("Name");
                this.processorConfig[i] = processor;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            wmiResults = WMIRegistry.getProvider().queryWMI("SELECT * from Win32_PhysicalMemory");
            ArrayList<MemoryConfig> memoryList = new ArrayList<MemoryConfig>();
            if (wmiResults == null) {
                System.out.println("[WindowsBasicInfo] Null results for wmi physical mem enquiry");
            } else {
                for (Properties result : wmiResults.getProperties()) {
                    MemoryConfig memory = new MemoryConfig();
                    memory.capacityBytes = WindowsBasicInfo.getAsLong(result.getProperty("Capacity"), 0L);
                    memory.type = this.getWindowsMemoryType(result.getProperty("MemoryType"));
                    memory.speedHz = WindowsBasicInfo.getAsLong(result.getProperty("ConfiguredClockSpeed"), 0L) * 1000L * 1000L;
                    memory.status = result.getProperty("Status");
                    memory.manufacturer = result.getProperty("Manufacturer");
                    memoryList.add(memory);
                }
                this.memoryConfig = memoryList.toArray(new MemoryConfig[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            wmiResults = WMIRegistry.getProvider().queryWMI("SELECT MemoryErrorCorrection from Win32_PhysicalMemoryArray");
            long memoryType = WindowsBasicInfo.getAsLong(WMIUtils.getOnlyValue(wmiResults), 3L);
            this.eccMemory = memoryType == 5L || memoryType == 6L;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            ArrayList<DiskConfig> diskList = new ArrayList<DiskConfig>();
            WMIResults wmiResults2 = WMIRegistry.getProvider().queryWMI("SELECT DeviceID, Name, Model, InterfaceType, MediaType, Size from Win32_DiskDrive");
            if (wmiResults2 == null) {
                System.out.println("[WindowsBasicInfo] Null results for wmi disk enquiry");
            } else {
                for (Properties result : wmiResults2.getProperties()) {
                    DiskConfig config = new DiskConfig();
                    config.disk = result.getProperty("DeviceID");
                    config.deviceName = result.getProperty("Name");
                    config.mediaName = result.getProperty("Model");
                    config.protocol = result.getProperty("InterfaceType");
                    String type = result.getProperty("MediaType");
                    config.internal = type == null || type.equals("Fixed hard disk media");
                    config.type = config.mediaName.contains("SSD") ? "SSD" : "HDD";
                    config.capacityBytes = WindowsBasicInfo.getAsLong(result.getProperty("Size"), 0L);
                    diskList.add(config);
                }
                this.diskConfig = diskList.toArray(new DiskConfig[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

