/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats.osx;

import java.io.IOException;
import java.util.ArrayList;
import utils.message.Message;
import utils.osstats.types.BasicInfo;
import utils.osstats.types.DiskConfig;
import utils.osstats.types.MemoryConfig;
import utils.osstats.types.ProcessorConfig;
import utils.ostools.RunCommandGetOutput;
import utils.string.StringUtil;

public class OSXBasicInfo
extends BasicInfo {
    public String bootROMVersion;
    public String SMCVersion;
    public boolean upgradeableMemory;

    public OSXBasicInfo() {
        this.readBasicInfo();
    }

    @Override
    protected void loadFromMessage(Message m) {
        super.loadFromMessage(m);
        this.bootROMVersion = m.getNextString();
        this.SMCVersion = m.getNextString();
        this.upgradeableMemory = m.getNextBoolean();
    }

    @Override
    public Message toMessage() {
        Message m = super.toMessage();
        m.append(this.bootROMVersion);
        m.append(this.SMCVersion);
        m.append(this.upgradeableMemory);
        return m;
    }

    public OSXBasicInfo(boolean fake) {
        super(fake);
        this.bootROMVersion = "MBP121.0167.B16";
        this.SMCVersion = "2.28f7";
        this.upgradeableMemory = false;
    }

    public OSXBasicInfo(Message loadFromMessage) {
        this.loadFromMessage(loadFromMessage);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("[OSX] ECC Memory: ").append(this.eccMemory).append("\n");
        builder.append("[OSX] Boot ROM Version: ").append(this.bootROMVersion).append("\n");
        builder.append("[OSX] SMC Version (system): ").append(this.SMCVersion).append("\n");
        return builder.toString();
    }

    @Override
    protected void readBasicInfo() {
        String output;
        RunCommandGetOutput.CommandResponse commandResponse;
        String processorName = null;
        long processorSpeedHz = 0L;
        int processorCount = 0;
        int coreCount = 0;
        boolean is64bit = false;
        try {
            commandResponse = RunCommandGetOutput.runCommand(new String[]{"sysctl", "hw.cpu64bit_capable"});
            if (commandResponse.stdout != null) {
                is64bit = commandResponse.stdout.trim().equals("hw.cpu64bit_capable: 1");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            commandResponse = RunCommandGetOutput.runCommand(new String[]{"sysctl", "hw.memsize"});
            if (commandResponse.stdout != null) {
                String response = commandResponse.stdout;
                response = response.substring(response.indexOf(58) + 1).trim();
                this.memoryTotalBytes = Long.parseLong(response);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            String[] lines;
            String output2 = RunCommandGetOutput.runCommandGetOutput(new String[]{"system_profiler", "SPHardwareDataType"})[0];
            for (String s : lines = output2.split("\\n")) {
                int colon = s.indexOf(58);
                if (colon == -1) continue;
                String[] key = s.substring(0, colon).trim();
                String value = s.substring(colon + 1).trim();
                if (key.equals("Model Name")) {
                    this.computerModelName = value;
                    continue;
                }
                if (key.equals("Model Identifier")) {
                    this.computerModelIdentifier = value;
                    continue;
                }
                if (key.equals("Processor Name")) {
                    processorName = value;
                    continue;
                }
                if (key.equals("Processor Speed")) {
                    processorSpeedHz = OSXBasicInfo.getAsHertz(value);
                    continue;
                }
                if (key.equals("Number of Processors")) {
                    processorCount = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("Total Number of Cores")) {
                    coreCount = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("Boot ROM Version")) {
                    this.bootROMVersion = value;
                    continue;
                }
                if (key.equals("SMC Version (system)")) {
                    this.SMCVersion = value;
                    continue;
                }
                if (!key.equals("Serial Number (system)")) continue;
                this.serial = value;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.computerModelManufacturer = "Apple Inc.";
        if (processorName == null) {
            processorCount = 0;
        }
        System.out.println("Processor count: " + processorCount + " (" + processorName + ")");
        this.processorConfig = new ProcessorConfig[processorCount];
        for (int i = 0; i < processorCount; ++i) {
            this.processorConfig[i] = new ProcessorConfig();
            this.processorConfig[i].processorName = processorName;
            this.processorConfig[i].processorSpeedHz = processorSpeedHz;
            this.processorConfig[i].is64bit = is64bit;
            if (i == processorCount - 1) {
                int coreCountForThisCPU = coreCount / processorCount;
                coreCount -= coreCountForThisCPU;
                this.processorConfig[i].coreCount = coreCountForThisCPU;
                continue;
            }
            this.processorConfig[i].coreCount = coreCount;
        }
        try {
            output = RunCommandGetOutput.runCommandGetOutput(new String[]{"system_profiler", "SPMemoryDataType"})[0];
            String[] chunks = output.split("BANK ");
            ArrayList<MemoryConfig> memoryConfigs = new ArrayList<MemoryConfig>();
            for (int i = 1; i < chunks.length; ++i) {
                String[] lines;
                MemoryConfig memory = new MemoryConfig();
                boolean isEmpty = false;
                for (String s : lines = chunks[i].split("\n")) {
                    int colon = s.indexOf(58);
                    if (colon == -1) continue;
                    String key = s.substring(0, colon).trim();
                    String value = s.substring(colon + 1).trim();
                    if (i == 0) {
                        if (key.equals("ECC")) {
                            this.eccMemory = !value.equals("Disabled");
                            continue;
                        }
                        if (!key.equals("Upgradeable Memory")) continue;
                        this.upgradeableMemory = !value.equals("No");
                        continue;
                    }
                    if (key.equals("Size")) {
                        if (!value.equals("Empty")) {
                            memory.capacityBytes = OSXBasicInfo.getAsBytes(value);
                            continue;
                        }
                        memory.capacityBytes = 0L;
                        continue;
                    }
                    if (key.equals("Type")) {
                        if (value != null && value.equals("Empty")) {
                            isEmpty = true;
                            break;
                        }
                        memory.type = value;
                        continue;
                    }
                    if (key.equals("Speed")) {
                        memory.speedHz = OSXBasicInfo.getAsHertz(value);
                        continue;
                    }
                    if (key.equals("Status")) {
                        memory.status = value;
                        continue;
                    }
                    if (!key.equals("Manufacturer")) continue;
                    memory.manufacturer = value;
                }
                if (isEmpty) continue;
                memoryConfigs.add(memory);
            }
            this.memoryConfig = memoryConfigs.toArray(new MemoryConfig[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            output = RunCommandGetOutput.runCommandGetOutput(new String[]{"uptime"})[0];
            this.lastBootTime = this.parseUptimeOutput(output);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            String[] allOutput;
            output = RunCommandGetOutput.runCommandGetOutput(new String[]{"system_profiler", "SPStorageDataType"})[0];
            ArrayList<DiskConfig> diskResults = new ArrayList<DiskConfig>();
            for (String allOutputPart : allOutput = output.split("\n\n")) {
                String value;
                String key;
                int colon;
                DiskConfig disk;
                String[] lines;
                int physicalVolumeIndex;
                if (output.contains("Physical Volumes")) {
                    physicalVolumeIndex = allOutputPart.indexOf("Physical Volumes:");
                    if (physicalVolumeIndex == -1) continue;
                    lines = allOutputPart.substring(physicalVolumeIndex + 1).trim().split("\n");
                    disk = new DiskConfig();
                    diskResults.add(disk);
                    for (String s : lines) {
                        colon = (s = s.trim()).indexOf(58);
                        if (colon == -1) continue;
                        if (s.endsWith(":")) {
                            disk.disk = s.substring(0, s.length() - 1);
                            continue;
                        }
                        key = s.substring(0, colon).trim();
                        value = null;
                        if (s.length() > colon) {
                            value = s.substring(colon + 1).trim();
                        }
                        if (key.equals("Device Name")) {
                            disk.deviceName = value;
                            continue;
                        }
                        if (key.equals("Media Name")) {
                            disk.mediaName = value;
                            continue;
                        }
                        if (key.equals("Size")) {
                            disk.capacityBytes = OSXBasicInfo.getAsBytes(value);
                            continue;
                        }
                        if (key.equals("Medium Type")) {
                            disk.type = value;
                            continue;
                        }
                        if (key.equals("Protocol")) {
                            disk.protocol = value;
                            continue;
                        }
                        if (!key.equals("Internal")) continue;
                        disk.internal = StringUtil.stringIsTrue(value);
                    }
                    continue;
                }
                physicalVolumeIndex = allOutputPart.indexOf("Physical Drive:");
                if (physicalVolumeIndex == -1) continue;
                lines = allOutputPart.substring(physicalVolumeIndex).trim().split("\n");
                disk = new DiskConfig();
                diskResults.add(disk);
                disk.disk = this.popKeyValueFromLine(allOutputPart, "BSD Name");
                for (String s : lines) {
                    colon = (s = s.trim()).indexOf(58);
                    if (colon == -1) continue;
                    key = s.substring(0, colon).trim();
                    value = null;
                    if (s.length() > colon) {
                        value = s.substring(colon + 1).trim();
                    }
                    if (key.equals("Device Name")) {
                        disk.deviceName = value;
                        continue;
                    }
                    if (key.equals("Media Name")) {
                        disk.mediaName = value;
                        continue;
                    }
                    if (key.equals("Size")) {
                        disk.capacityBytes = OSXBasicInfo.getAsBytes(value);
                        continue;
                    }
                    if (key.equals("Medium Type")) {
                        disk.type = value;
                        continue;
                    }
                    if (key.equals("Protocol")) {
                        disk.protocol = value;
                        continue;
                    }
                    if (!key.equals("Internal")) continue;
                    disk.internal = StringUtil.stringIsTrue(value);
                }
                if (disk.capacityBytes == 0L) {
                    disk.capacityBytes = OSXBasicInfo.getAsBytes(this.popKeyValueFromLine(allOutputPart, "Capacity"));
                }
                if (disk.deviceName != null) continue;
                disk.deviceName = disk.mediaName;
            }
            this.diskConfig = diskResults.toArray(new DiskConfig[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String popKeyValueFromLine(String allOutput, String key) {
        int bsdNameIndex = allOutput.indexOf(key + ":");
        if (bsdNameIndex != -1) {
            return allOutput.substring(bsdNameIndex + (key.length() + 1), allOutput.indexOf(10, bsdNameIndex));
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        OSXBasicInfo info = new OSXBasicInfo();
        System.out.println(info);
    }
}

