/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats.linux;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import utils.files.FileUtil;
import utils.message.Message;
import utils.osstats.types.BasicInfo;
import utils.osstats.types.DiskConfig;
import utils.osstats.types.MemoryConfig;
import utils.osstats.types.ProcessorConfig;
import utils.ostools.RunCommandGetOutput;
import utils.string.CharStack;

public class LinuxBasicInfo
extends BasicInfo {
    public String biosReleaseDate;
    public String biosVersion;
    public String biosVendor;

    public LinuxBasicInfo() {
        this.readBasicInfo();
    }

    public LinuxBasicInfo(boolean fake) {
        super(fake);
    }

    public LinuxBasicInfo(Message loadFromMessage) {
        this.loadFromMessage(loadFromMessage);
    }

    @Override
    protected void loadFromMessage(Message m) {
        super.loadFromMessage(m);
        this.biosReleaseDate = m.getNextString();
        this.biosVersion = m.getNextString();
        this.biosVendor = m.getNextString();
    }

    @Override
    public Message toMessage() {
        Message m = super.toMessage();
        m.append(this.biosReleaseDate);
        m.append(this.biosVersion);
        m.append(this.biosVendor);
        return m;
    }

    private static HashMap<String, String> splitIntoKeyValues(String source, char splitChar) {
        String[] lines;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : lines = source.split("\n")) {
            int split;
            if (line.length() <= 0 || (split = line.indexOf(splitChar)) == -1 || split == 0) continue;
            String key = line.substring(0, split);
            String value = line.substring(split + 1);
            result.put(key.trim().toLowerCase(), value.trim());
        }
        return result;
    }

    @Override
    protected void readBasicInfo() {
        CharStack stack;
        block42: {
            try {
                String output = RunCommandGetOutput.runCommandGetOutput(new String[]{"uptime"})[0];
                this.lastBootTime = this.parseUptimeOutput(output);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                String response = FileUtil.readFileAsString_NoBuffer(new File("/proc/meminfo"));
                CharStack stack2 = new CharStack(response);
                stack2.popText(false);
                stack2.popWhitespace();
                this.memoryTotalBytes = stack2.popInteger() * 1024L;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                File biosDateFile = new File("/sys/devices/virtual/dmi/id/bios_date");
                File biosVersionFile = new File("/sys/devices/virtual/dmi/id/bios_version");
                File biosVendorFile = new File("/sys/devices/virtual/dmi/id/bios_vendor");
                if (biosDateFile.exists() && biosVersionFile.exists() && biosVendorFile.exists()) {
                    this.biosReleaseDate = FileUtil.readFileAsString_NoBuffer(biosDateFile);
                    this.biosVendor = FileUtil.readFileAsString_NoBuffer(biosVendorFile);
                    this.biosVersion = FileUtil.readFileAsString_NoBuffer(biosVersionFile);
                } else {
                    RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(new String[]{"dmidecode", "-t", "bios"});
                    if (commandResponse != null && commandResponse.error == null) {
                        CharStack stack3 = new CharStack(commandResponse.stdout);
                        stack3.popUntil("Vendor:");
                        this.biosVendor = stack3.popLine(true).trim();
                        stack3.popUntil("Version:");
                        this.biosVersion = stack3.popLine(true).trim();
                        stack3.popUntil("Release Date:");
                        this.biosReleaseDate = stack3.popLine(true).trim();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                File productNameFile = new File("/sys/devices/virtual/dmi/id/product_name");
                File productVersionFile = new File("/sys/devices/virtual/dmi/id/product_version");
                File productVendorFile = new File("/sys/devices/virtual/dmi/id/sys_vendor");
                File productSerialFile = new File("/sys/devices/virtual/dmi/id/product_serial");
                if (productNameFile.exists() && productVersionFile.exists() && productVendorFile.exists() && productSerialFile.exists()) {
                    this.computerModelName = FileUtil.readFileAsString_NoBuffer(productNameFile);
                    this.computerModelManufacturer = FileUtil.readFileAsString_NoBuffer(productVendorFile);
                    this.computerModelIdentifier = FileUtil.readFileAsString_NoBuffer(productVersionFile);
                    if (this.computerModelName != null) {
                        this.computerModelName = this.computerModelName.trim();
                    }
                    if (this.computerModelManufacturer != null) {
                        this.computerModelManufacturer = this.computerModelManufacturer.trim();
                    }
                    if (this.computerModelIdentifier != null) {
                        this.computerModelIdentifier = this.computerModelIdentifier.trim();
                    }
                    try {
                        this.serial = FileUtil.readFileAsString_NoBuffer(productSerialFile);
                        if (this.serial != null) {
                            this.serial = this.serial.trim();
                        }
                        break block42;
                    }
                    catch (IOException ex) {
                        System.out.println("[LinuxBasicInfo] Unable to retrieve serial number as " + productSerialFile + " could not be read (" + ex.getMessage() + ")");
                    }
                    break block42;
                }
                RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(new String[]{"dmidecode", "-t", "system"});
                if (commandResponse != null && commandResponse.error == null) {
                    stack = new CharStack(commandResponse.stdout);
                    stack.popUntil("Manufacturer:");
                    this.computerModelManufacturer = stack.popLine(true).trim();
                    stack.popUntil("Product Name:");
                    this.computerModelName = stack.popLine(true).trim();
                    stack.popUntil("Version:");
                    this.computerModelIdentifier = stack.popLine(true).trim();
                    stack.popUntil("Serial Number:");
                    this.serial = stack.popLine(true).trim();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ArrayList<ProcessorConfig> processorList = new ArrayList<ProcessorConfig>();
        File cpuFile = new File("/proc/cpuinfo");
        try {
            String cpuInfo = FileUtil.readFileAsString_NoBuffer(cpuFile);
            String[] processorBlocks = cpuInfo.split("processor\\s+\\:");
            for (int i = 1; i < processorBlocks.length; ++i) {
                String flags;
                String cores;
                String processorBlock = processorBlocks[i];
                HashMap<String, String> keyValues = LinuxBasicInfo.splitIntoKeyValues(processorBlock, ':');
                ProcessorConfig processorConfig = new ProcessorConfig();
                processorConfig.processorName = keyValues.get("model name");
                String mhz = keyValues.get("cpu mhz");
                if (mhz != null) {
                    processorConfig.processorSpeedHz = LinuxBasicInfo.getAsHertz(mhz, (long)Math.pow(1000.0, 2.0));
                }
                if ((cores = keyValues.get("cpu cores")) != null) {
                    processorConfig.coreCount = Integer.parseInt(cores);
                }
                processorConfig.is64bit = (flags = keyValues.get("flags")) != null && flags.contains(" lm ");
                processorList.add(processorConfig);
                if (i != processorBlocks.length - 1) continue;
                if (this.serial == null || this.serial.length() == 0) {
                    this.serial = keyValues.get("serial");
                }
                if (this.computerModelIdentifier == null || this.computerModelIdentifier.length() == 0) {
                    this.computerModelIdentifier = keyValues.get("revision");
                }
                if (this.computerModelName != null && this.computerModelName.length() != 0) continue;
                this.computerModelName = LinuxBasicInfo.getRaspberryPiNameFrom(keyValues.get("revision"));
                if (this.computerModelName == null) continue;
                this.computerModelManufacturer = "Raspberry Pi Foundation";
            }
            this.processorConfig = processorList.toArray(new ProcessorConfig[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            ArrayList<MemoryConfig> memoryList = new ArrayList<MemoryConfig>();
            RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(new String[]{"dmidecode", "-t", "memory"});
            if (commandResponse != null && commandResponse.error == null) {
                String[] result = commandResponse.stdout.split("Memory Device");
                for (int i = 1; i < result.length; ++i) {
                    MemoryConfig config = new MemoryConfig();
                    stack = new CharStack(result[i]);
                    boolean done = false;
                    String totalWidth = null;
                    String dataWidth = null;
                    while (!stack.isEmpty() && !done) {
                        String line = stack.popLine(true);
                        int colonIndex = line.indexOf(58);
                        if (colonIndex == -1) continue;
                        String key = line.substring(0, colonIndex).trim();
                        String value = line.substring(colonIndex + 1);
                        if (key.equals("Size")) {
                            try {
                                config.capacityBytes = LinuxBasicInfo.getAsBytes(value);
                            }
                            catch (NumberFormatException e) {
                                done = true;
                            }
                            continue;
                        }
                        if (key.equals("Form Factor")) {
                            config.type = value;
                            continue;
                        }
                        if (key.equals("Speed")) {
                            config.speedHz = LinuxBasicInfo.getAsHertz(value);
                            continue;
                        }
                        if (key.equals("Manufacturer")) {
                            config.manufacturer = value;
                            continue;
                        }
                        if (key.equals("Total Width")) {
                            totalWidth = value;
                            this.eccMemory = totalWidth != null && dataWidth != null && !totalWidth.equals(dataWidth);
                            continue;
                        }
                        if (key.equals("Data Width")) {
                            dataWidth = value;
                            continue;
                        }
                        if (!key.equals("Locator")) continue;
                        CharStack tempStack = new CharStack(commandResponse.stdout);
                        tempStack.popUntil("Socket Designation: " + value);
                        tempStack.popUntil("Error Status:");
                        tempStack.popWhitespace();
                        config.status = tempStack.popText(true);
                    }
                    if (done) continue;
                    memoryList.add(config);
                }
            }
            if (memoryList.size() == 0) {
                commandResponse = RunCommandGetOutput.runCommand(new String[]{"dmidecode", "--type", "memory"});
            }
            this.memoryConfig = memoryList.toArray(new MemoryConfig[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            ArrayList diskList = new ArrayList();
            this.diskConfig = diskList.toArray(new DiskConfig[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String getRaspberryPiNameFrom(String revision) {
        if (revision == null) {
            return null;
        }
        if (revision.length() > 4) {
            revision = revision.substring(revision.length() - 4, revision.length());
        }
        if (revision.equalsIgnoreCase("0002")) {
            return "Pi B Rev 1.0, 256 MB";
        }
        if (revision.equalsIgnoreCase("0003")) {
            return "Pi B Rev 1.0, 256 MB";
        }
        if (revision.equalsIgnoreCase("0004")) {
            return "Pi B Rev 2.0, 256 MB";
        }
        if (revision.equalsIgnoreCase("0005")) {
            return "Pi B Rev 2.0, 256 MB";
        }
        if (revision.equalsIgnoreCase("0006")) {
            return "Pi B Rev 2.0, 256 MB";
        }
        if (revision.equalsIgnoreCase("0007")) {
            return "Pi A";
        }
        if (revision.equalsIgnoreCase("0008")) {
            return "Pi A";
        }
        if (revision.equalsIgnoreCase("0009")) {
            return "Pi A";
        }
        if (revision.equalsIgnoreCase("000d")) {
            return "Pi B Rev 2.0, 512 MB";
        }
        if (revision.equalsIgnoreCase("000e")) {
            return "Pi B Rev 2.0, 512 MB";
        }
        if (revision.equalsIgnoreCase("000f")) {
            return "Pi B Rev 2.0, 512 MB";
        }
        if (revision.equalsIgnoreCase("0010")) {
            return "Pi B+";
        }
        if (revision.equalsIgnoreCase("0012")) {
            return "Pi A+";
        }
        if (revision.equalsIgnoreCase("0013")) {
            return "Pi B+";
        }
        if (revision.equalsIgnoreCase("0015")) {
            return "Pi A+";
        }
        if (revision.equalsIgnoreCase("0092")) {
            return "Pi Zero Rev 1.2";
        }
        if (revision.equalsIgnoreCase("0093")) {
            return "Pi Zero Rev 1.3";
        }
        if (revision.equalsIgnoreCase("1040")) {
            return "Pi 2B Rev 1.0";
        }
        if (revision.equalsIgnoreCase("1041")) {
            return "Pi 2B Rev 1.1";
        }
        if (revision.equalsIgnoreCase("2082")) {
            return "Pi 3B Rev 1.2";
        }
        if (revision.startsWith("10")) {
            return "Pi 2B";
        }
        if (revision.startsWith("20")) {
            return "Pi 3B";
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(new LinuxBasicInfo().toString());
    }
}

