/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats;

import utils.message.Message;
import utils.osstats.AbstractStats;
import utils.osstats.LinuxStats;
import utils.osstats.MacOSStats;
import utils.osstats.Stats;
import utils.osstats.WindowsStats;
import utils.ostools.OS;

public class OsStats {
    public static Stats getOsStats(boolean fake) {
        if (OS.isWindows()) {
            return new WindowsStats(fake);
        }
        if (OS.isMacOS()) {
            return new MacOSStats(fake);
        }
        if (OS.isLinux()) {
            return new LinuxStats(fake);
        }
        return null;
    }

    public static Stats getOsStats() {
        if (OS.isWindows()) {
            return new WindowsStats(false);
        }
        if (OS.isMacOS()) {
            return new MacOSStats(false);
        }
        if (OS.isLinux()) {
            return new LinuxStats(false);
        }
        return null;
    }

    public static String statsToString(Stats stats) {
        StringBuilder builder = new StringBuilder();
        builder.append(stats.getBasicInfo().toString());
        builder.append("\n");
        builder.append("Memory Used: ").append(stats.getMemoryUsed()).append("\n");
        builder.append("Memory Free: ").append(stats.getMemoryFree()).append("\n");
        builder.append("Memory %: ").append(stats.getMemoryUsedPercent()).append(" %").append("\n");
        builder.append("CPU %: ").append(stats.getCpuUsagePercent()).append(" %").append("\n");
        Stats.ProcessStatistic[] processes = stats.getProcessStatistics();
        System.out.println("Number of processes found is " + processes.length);
        for (int i = 0; i < processes.length; ++i) {
            builder.append("\tProcess: ").append(processes[i].name).append(" - ").append(processes[i].cpuPercentage).append(" % - ").append(processes[i].memPercentage).append(" %").append("\n");
        }
        builder.append("Number of disks found is ").append(stats.getDiskSpaceStatistic().length).append("\n");
        for (Stats.DiskSpaceStatistic disk : stats.getDiskSpaceStatistic()) {
            builder.append("\tDisk: ").append(disk.name).append(" - ").append(disk.free).append(" - ").append(disk.used).append("\n");
        }
        builder.append("Wifi strength: ").append(stats.getWifiSignalPercent()).append(" %").append("\n");
        builder.append("Wifi rate: ").append(stats.getWifiMbitRate()).append("\n");
        builder.append("Battery percent: ").append(stats.getBatteryPercent()).append("\n");
        return builder.toString();
    }

    public static Message toMessage(Stats stats) {
        Message m = null;
        if (stats instanceof WindowsStats) {
            m = new Message(0);
        } else if (stats instanceof LinuxStats) {
            m = new Message(2);
        } else if (stats instanceof MacOSStats) {
            m = new Message(1);
        }
        stats.saveToMessage(m);
        return m;
    }

    public static Stats fromMessage(Message m) {
        AbstractStats stats = null;
        if (m.getType() == 0) {
            stats = new WindowsStats(m);
        } else if (m.getType() == 2) {
            stats = new LinuxStats(m);
        } else if (m.getType() == 1) {
            stats = new MacOSStats(m);
        }
        return stats;
    }
}

