/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats;

import java.util.ArrayList;
import utils.message.Message;
import utils.osstats.Stats;
import utils.osstats.linux.LinuxBasicInfo;
import utils.osstats.types.BasicInfo;
import utils.ostools.OS;

public abstract class AbstractStats
implements Stats {
    private static final byte VERSION = 0;
    protected boolean isFake = false;
    protected BasicInfo basicInfo;
    protected Stats.DiskSpaceStatistic[] diskSpaceStatistics = new Stats.DiskSpaceStatistic[0];
    protected Stats.ProcessStatistic[] processStatistics = new Stats.ProcessStatistic[0];
    protected long usedMemoryBytes;
    protected double cpuPercentage = 0.0;
    protected double wifiPercentage = 0.0;
    protected double wifiMbit = 0.0;
    protected int batteryPercentage;

    public AbstractStats(boolean fake) {
        this.isFake = fake;
        this.basicInfo = this.isFake ? new LinuxBasicInfo(true) : BasicInfo.getBasicInfo();
        this.update();
    }

    protected AbstractStats() {
    }

    @Override
    public abstract void update();

    @Override
    public abstract void updateLight();

    @Override
    public double getWifiSignalPercent() {
        return this.wifiPercentage;
    }

    @Override
    public double getWifiMbitRate() {
        return this.wifiMbit;
    }

    @Override
    public BasicInfo getBasicInfo() {
        return this.basicInfo;
    }

    @Override
    public long getUptimeMs() {
        return this.basicInfo.getUptime();
    }

    @Override
    public int getBatteryPercent() {
        return this.batteryPercentage;
    }

    @Override
    public double getMemoryUsedPercent() {
        return 100.0 / (this.getMemoryUsed() + this.getMemoryFree()) * this.getMemoryUsed();
    }

    @Override
    public Stats.DiskSpaceStatistic[] getDiskSpaceStatistic() {
        return this.diskSpaceStatistics;
    }

    @Override
    public double getMemoryFree() {
        return this.basicInfo.memoryTotalBytes - this.usedMemoryBytes;
    }

    @Override
    public double getMemoryUsed() {
        return this.usedMemoryBytes;
    }

    @Override
    public double getCpuUsagePercent() {
        return this.cpuPercentage;
    }

    @Override
    public Stats.ProcessStatistic[] getProcessStatistics() {
        return this.processStatistics;
    }

    private StringBuffer indent(StringBuffer sb, int n) {
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName() + ":");
        this.indent(sb, 2).append(this.basicInfo.toMessage()).append('\n');
        this.indent(sb, 2).append("OsUsedMem: " + this.usedMemoryBytes).append('\n');
        this.indent(sb, 2).append("OsCpuPc: " + this.cpuPercentage).append('\n');
        this.indent(sb, 2).append("WifiPc: " + this.wifiPercentage).append('\n');
        this.indent(sb, 2).append("WifiMbit: " + this.wifiMbit).append('\n');
        this.indent(sb, 2).append("BatteryPc: " + this.batteryPercentage).append('\n');
        this.indent(sb, 2).append("WifiMbit: " + this.wifiMbit).append('\n');
        this.indent(sb, 2).append("Disks:").append('\n');
        for (Stats.DiskSpaceStatistic diskSpaceStatistic : this.diskSpaceStatistics) {
            this.indent(sb, 4).append(diskSpaceStatistic.name + (diskSpaceStatistic.isRecovery ? " (RECOVERY) " : " (not recovery) ") + (diskSpaceStatistic.isShared ? " (SHARED) " : " (not shared) ")).append('\n');
            this.indent(sb, 6).append("Free: " + diskSpaceStatistic.free).append('\n');
            this.indent(sb, 6).append("Used: " + diskSpaceStatistic.used).append('\n');
            this.indent(sb, 6).append("UsagePc: " + diskSpaceStatistic.getDiskUsagePercent()).append('\n');
        }
        this.indent(sb, 2).append("Processes:").append('\n');
        for (Stats.ProcessStatistic processStatistic : this.processStatistics) {
            this.indent(sb, 4).append(processStatistic.name).append('\n');
            this.indent(sb, 6).append("ID: " + processStatistic.id).append('\n');
            this.indent(sb, 6).append("CmdLine: " + processStatistic.cmdLineNoArgs).append('\n');
            this.indent(sb, 6).append("User: " + processStatistic.user).append('\n');
            this.indent(sb, 6).append("CpuPc: " + processStatistic.cpuPercentage).append('\n');
            this.indent(sb, 6).append("MemPc: " + processStatistic.memPercentage).append('\n');
        }
        return sb.toString();
    }

    @Override
    public void saveToMessage(Message m) {
        m.append((byte)0);
        m.append(this.basicInfo.toMessage());
        m.append(this.usedMemoryBytes);
        m.append(this.cpuPercentage);
        m.append(this.wifiPercentage);
        m.append(this.wifiMbit);
        m.append(this.batteryPercentage);
        m.append(this.diskSpaceStatistics.length);
        for (Stats.DiskSpaceStatistic diskSpaceStatistic : this.diskSpaceStatistics) {
            m.append(diskSpaceStatistic.name);
            m.append(diskSpaceStatistic.free);
            m.append(diskSpaceStatistic.used);
        }
        m.append(this.processStatistics.length);
        for (Stats.ProcessStatistic processStatistic : this.processStatistics) {
            m.append(processStatistic.id);
            m.append(processStatistic.name);
            m.append(processStatistic.cmdLineNoArgs);
            m.append(processStatistic.cpuPercentage);
            m.append(processStatistic.memPercentage);
            m.append(processStatistic.user);
            m.append(processStatistic.cmdLineArgs);
        }
    }

    @Override
    public void loadFromMessage(Message m) {
        int i;
        byte version = m.getNextByte();
        this.basicInfo = BasicInfo.fromMessage(m.getNextMessage());
        this.usedMemoryBytes = m.getNextLong();
        this.cpuPercentage = m.getNextDouble();
        this.wifiPercentage = m.getNextDouble();
        this.wifiMbit = m.getNextDouble();
        this.batteryPercentage = m.getNextInt();
        this.diskSpaceStatistics = new Stats.DiskSpaceStatistic[m.getNextInt()];
        for (i = 0; i < this.diskSpaceStatistics.length; ++i) {
            this.diskSpaceStatistics[i] = new Stats.DiskSpaceStatistic();
            this.diskSpaceStatistics[i].name = m.getNextString();
            this.diskSpaceStatistics[i].free = m.getNextLong();
            this.diskSpaceStatistics[i].used = m.getNextLong();
        }
        this.processStatistics = new Stats.ProcessStatistic[m.getNextInt()];
        for (i = 0; i < this.processStatistics.length; ++i) {
            this.processStatistics[i] = new Stats.ProcessStatistic();
            this.processStatistics[i].id = m.getNextString();
            this.processStatistics[i].name = m.getNextString();
            this.processStatistics[i].cmdLineNoArgs = m.getNextString();
            this.processStatistics[i].cpuPercentage = m.getNextInt();
            this.processStatistics[i].memPercentage = m.getNextInt();
            this.processStatistics[i].user = m.getNextString();
            if (!m.hasNext()) continue;
            this.processStatistics[i].cmdLineArgs = m.getNextString();
        }
    }

    @Override
    public final double getMaxDiskUsagePercent(long minimumDiskSize, String[] exclusions) {
        Stats.DiskSpaceStatistic[] ds;
        double max = 0.0;
        for (Stats.DiskSpaceStatistic d : ds = this.getMeaningfulDriveList(exclusions)) {
            long totalSize = d.free + d.used;
            if (totalSize <= minimumDiskSize) continue;
            max = Math.max(max, d.getDiskUsagePercent());
        }
        return max;
    }

    @Override
    public final Stats.DiskSpaceStatistic[] getMeaningfulDriveList(String[] exclusions) {
        ArrayList<Stats.DiskSpaceStatistic> result = new ArrayList<Stats.DiskSpaceStatistic>();
        Stats.DiskSpaceStatistic[] ds = this.getDiskSpaceStatistic();
        if (ds != null) {
            for (Stats.DiskSpaceStatistic d : ds) {
                if (d.isRecovery || d.isShared) continue;
                String driveName = d.name;
                if (OS.isWindows() && driveName.charAt(1) != ':' || !OS.isWindows() && !driveName.startsWith("/")) continue;
                if (exclusions != null && d.name != null) {
                    boolean exclude = false;
                    for (String exclusion : exclusions) {
                        if (!d.name.contains(exclusion)) continue;
                        exclude = true;
                        break;
                    }
                    if (exclude) continue;
                }
                result.add(d);
            }
        }
        return result.toArray(new Stats.DiskSpaceStatistic[0]);
    }
}

