/*
 * Decompiled with CFR 0.152.
 */
package utils.multiplex;

import bcutil.BCUtil;
import bcutil.BCUtilOutputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import utils.stream.OpenByteArrayOutputStream;
import utils.stream.StreamUtils;
import utils.switches.Switches;
import utils.sync.UnqueuedMutex;

public class FastMxOutputStream
implements utils.multiplex.MultiplexingOutput {
    OutputStream outstream;
    private Object lock = new Object();
    HashMap streams = new HashMap();
    HashMap locks = new HashMap();
    boolean dumpLargeWrites = true;
    IOException ioexception;
    boolean compressPackets = false;
    static final int MINCHUNK = 10240;
    double uncompressedB = 0.0;
    double compressedB = 0.0;

    public void resetStats() {
        this.uncompressedB = 0.0;
        this.compressedB = 0.0;
    }

    public int getCompressionPercent() {
        return (int)(100.0 / this.uncompressedB * this.compressedB);
    }

    public void compressPackets(boolean b) {
        this.compressPackets = b;
    }

    private void checkIoException(String err) throws IOException {
        if (this.ioexception != null) {
            IOException tmp = new IOException(err);
            tmp.initCause(this.ioexception);
            throw tmp;
        }
    }

    public FastMxOutputStream(OutputStream out) {
        this.outstream = new BufferedOutputStream(out);
    }

    public FastMxOutputStream(OutputStream out, String name) {
        this.outstream = new BufferedOutputStream(out);
    }

    public FastMxOutputStream(OutputStream out, String name, ThreadGroup tg) {
        this.outstream = new BufferedOutputStream(out);
    }

    public void closeAll(IOException err) {
        this.ioexception = err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnqueuedMutex getLock(short n) {
        Integer N = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            UnqueuedMutex nlock = (UnqueuedMutex)this.locks.get(N);
            if (nlock == null) {
                nlock = new UnqueuedMutex();
                this.locks.put(N, nlock);
            }
            return nlock;
        }
    }

    public OutputStream getBcuBufOutputStream(short n, BCUtil bcu) {
        return new BufferedOutputStream(new BCUtilOutputStream(this.getBufOutputStream(n), bcu.clone()));
    }

    public OutputStream getBufOutputStream(short n) {
        return new BufferedOutputStream(this.getOutputStream(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream(short n) {
        HashMap hashMap = this.streams;
        synchronized (hashMap) {
            Integer N = new Integer(n);
            OutputStream out = (OutputStream)this.streams.get(N);
            if (out == null) {
                out = new MultiplexingOutput(n);
                this.streams.put(N, out);
            }
            return out;
        }
    }

    @Override
    public void flushAll() throws IOException {
        Collection tmp = this.streams.values();
        Iterator it = tmp.iterator();
        while (it.hasNext()) {
            ((MultiplexingOutput)it.next()).flush();
        }
    }

    class MultiplexingOutput
    extends FilterOutputStream {
        short n;
        Object boutlock;
        OpenByteArrayOutputStream zipper;
        OpenByteArrayOutputStream bout;

        public MultiplexingOutput(short n) {
            super(FastMxOutputStream.this.outstream);
            this.boutlock = new Object();
            this.zipper = new OpenByteArrayOutputStream();
            this.bout = new OpenByteArrayOutputStream();
            this.n = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeChunk() throws IOException {
            Object object = FastMxOutputStream.this.lock;
            synchronized (object) {
                if (this.bout.size() > 0) {
                    if (FastMxOutputStream.this.compressPackets) {
                        FastMxOutputStream.this.outstream.write(9);
                        this.zipper.reset();
                        GZIPOutputStream dout = new GZIPOutputStream(this.zipper);
                        StreamUtils.writeShort(dout, this.n);
                        StreamUtils.writeBytes(dout, this.bout.getByteArray(), 0, this.bout.size());
                        dout.finish();
                        StreamUtils.writeBytes(FastMxOutputStream.this.outstream, this.zipper.getByteArray(), 0, this.zipper.size());
                        FastMxOutputStream.this.uncompressedB += (double)this.bout.size();
                        FastMxOutputStream.this.compressedB += (double)this.zipper.size();
                    } else {
                        FastMxOutputStream.this.outstream.write(1);
                        StreamUtils.writeShort(FastMxOutputStream.this.outstream, this.n);
                        StreamUtils.writeBytes(FastMxOutputStream.this.outstream, this.bout.getByteArray(), 0, this.bout.size());
                        FastMxOutputStream.this.uncompressedB += (double)this.bout.size();
                        FastMxOutputStream.this.compressedB += (double)this.zipper.size();
                    }
                    this.bout.reset();
                }
            }
        }

        @Override
        public void flush() throws IOException {
            FastMxOutputStream.this.checkIoException("Error flushing output stream");
            this.writeChunk();
            FastMxOutputStream.this.outstream.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            FastMxOutputStream.this.checkIoException("Error writing to output stream");
            if (Switches.SH_XXXX_mxDumpOnWrite && len > 10240) {
                Object object = FastMxOutputStream.this.lock;
                synchronized (object) {
                    if (this.bout.size() > 0) {
                        this.writeChunk();
                    }
                    if (FastMxOutputStream.this.compressPackets) {
                        FastMxOutputStream.this.outstream.write(9);
                        this.zipper.reset();
                        GZIPOutputStream dout = new GZIPOutputStream(this.zipper);
                        StreamUtils.writeShort(dout, this.n);
                        StreamUtils.writeBytes(dout, b, off, len);
                        dout.finish();
                        StreamUtils.writeBytes(FastMxOutputStream.this.outstream, this.zipper.getByteArray(), 0, this.zipper.size());
                        FastMxOutputStream.this.uncompressedB += (double)len;
                        FastMxOutputStream.this.compressedB += (double)this.zipper.size();
                    } else {
                        FastMxOutputStream.this.outstream.write(1);
                        StreamUtils.writeShort(FastMxOutputStream.this.outstream, this.n);
                        StreamUtils.writeBytes(FastMxOutputStream.this.outstream, b, 0, len);
                        FastMxOutputStream.this.uncompressedB += (double)len;
                        FastMxOutputStream.this.compressedB += (double)len;
                    }
                }
            } else {
                this.bout.write(b, off, len);
                if (this.bout.size() > 10240) {
                    this.writeChunk();
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            FastMxOutputStream.this.checkIoException("Error writing to output stream");
            this.bout.write(b);
            if (this.bout.size() > 10240) {
                this.writeChunk();
            }
        }
    }
}

