/*
 * Decompiled with CFR 0.152.
 */
package utils.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import utils.message.MTTransactionClient;
import utils.message.MTTransactionResponse;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.switches.Switches;

public class BasicMTTransactionClient
implements MTTransactionClient {
    public static final int MT_WRAP = -1524849380;
    public static final int MT_SINGLE = -1289964772;
    public static final int MT_EXCEPTION = -1173209;
    public static final boolean DEBUG = false;
    private final Object LOCK = new Object();
    MessageReader min;
    MessageWriter mout;
    HashMap<Integer, MTTransactionResponse> onetime = new HashMap();
    Object uid_LOCK = new Object();
    int uid = 0;
    boolean dead = false;
    Reader reader;
    long responseTimeout = 0L;
    long lastClear = 0L;
    boolean autoHandleExceptions = false;

    public void setAutoHandleExceptions(boolean b) {
        this.autoHandleExceptions = b;
    }

    public void setResponseTimeout(long ms) {
        System.out.println("[MTTransactions] response timeout set to " + ms);
        this.responseTimeout = ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getNextUniqueConversation() {
        Object object = this.uid_LOCK;
        synchronized (object) {
            int tmp = this.uid++;
            return new Integer(tmp);
        }
    }

    public BasicMTTransactionClient(InputStream bin, OutputStream bout, ThreadGroup tg, String name) {
        this.min = new MessageReader(bin, tg, name);
        this.mout = new MessageWriter(bout);
        this.reader = new Reader();
        this.reader.start();
    }

    public BasicMTTransactionClient(InputStream bin, OutputStream bout) {
        this.min = new MessageReader(bin);
        this.mout = new MessageWriter(bout);
        this.reader = new Reader();
        this.reader.start();
    }

    private void clearTimedOut() {
        if (System.currentTimeMillis() - this.lastClear > 60000L) {
            Object[] keys;
            this.lastClear = System.currentTimeMillis();
            int cleared = 0;
            for (Object key : keys = this.onetime.keySet().toArray()) {
                MTTransactionResponse resp = this.onetime.get(key);
                if (Switches.SH_XXXX_mtTransactionClientHonourInfiniteTimeout) {
                    if (resp.timeout <= 0L || System.currentTimeMillis() <= resp.timeout) continue;
                    this.onetime.remove(key);
                    ++cleared;
                    continue;
                }
                if (System.currentTimeMillis() <= resp.timeout) continue;
                this.onetime.remove(key);
                ++cleared;
            }
            if (cleared > 0) {
                System.out.println("[MTTransactions] Cleared " + cleared);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSend(Message m) throws IOException {
        Message wrap = new Message(-1289964772);
        wrap.append(m);
        Object object = this.LOCK;
        synchronized (object) {
            this.mout.write(wrap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSendNoFlush(Message m) throws IOException {
        Message wrap = new Message(-1289964772);
        wrap.append(m);
        Object object = this.LOCK;
        synchronized (object) {
            this.mout.writeNoFlush(wrap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFlush() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.mout.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message doTransaction(Message m) throws IOException {
        if (this.dead && Switches.SH_mttransThrowErrorOnDead) {
            throw new IOException("MTTransactionClient is dead");
        }
        Integer conv = this.getNextUniqueConversation();
        MTTransactionResponse me = new MTTransactionResponse();
        if (this.responseTimeout != 0L) {
            me.timeout = System.currentTimeMillis() + this.responseTimeout;
        }
        Message wrap = new Message(-1524849380);
        wrap.append(conv);
        wrap.append(m);
        Object object = this.LOCK;
        synchronized (object) {
            this.onetime.put(conv, me);
            this.mout.write(wrap);
            this.clearTimedOut();
        }
        m = me.waitForResponse();
        return m;
    }

    private class Reader
    extends Thread {
        public Reader() {
            super("BasicMTTransactionClient-Reader");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!BasicMTTransactionClient.this.dead) {
                    Integer conv;
                    Message m = BasicMTTransactionClient.this.min.read();
                    if (m.getType() == -1173209 && BasicMTTransactionClient.this.autoHandleExceptions) {
                        conv = m.getNextInt();
                        String errorLine = m.getNextString();
                        String errorTrace = m.getNextString();
                        Object object = BasicMTTransactionClient.this.LOCK;
                        synchronized (object) {
                            MTTransactionResponse response = BasicMTTransactionClient.this.onetime.remove(conv);
                            if (response != null) {
                                response.responseError(errorLine, errorTrace);
                            } else {
                                System.out.println("[BasicMTTransactionClient] MTTransactionResponse was not found for conv:" + conv);
                            }
                            continue;
                        }
                    }
                    if (m.getType() == -1524849380) {
                        conv = m.getNextInt();
                        Message resp = m.getNextMessage();
                        Object object = BasicMTTransactionClient.this.LOCK;
                        synchronized (object) {
                            MTTransactionResponse response = BasicMTTransactionClient.this.onetime.remove(conv);
                            if (response != null) {
                                response.response(resp);
                            } else {
                                System.out.println("[BasicMTTransactionClient] MTTransactionResponse was not found for conv:" + conv);
                            }
                            continue;
                        }
                    }
                    System.out.println("[BasicMTTransactionClient] Unexpected message type in BMTTransactionClient " + m.getType());
                }
            }
            catch (IOException x) {
                Throwable root = x;
                while (root.getCause() != null) {
                    root = root.getCause();
                }
                root.printStackTrace();
            }
            try {
                BasicMTTransactionClient.this.dead = true;
                if (!Switches.SH_mttransClearResponsesOnDead) return;
                Object object = BasicMTTransactionClient.this.LOCK;
                synchronized (object) {
                    Object[] objs;
                    Object[] objectArray = objs = BasicMTTransactionClient.this.onetime.values().toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        MTTransactionResponse mt = (MTTransactionResponse)o;
                        mt.response(null);
                        ++n2;
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

