/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.ui.repository;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Window;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import utils.loggingframework.TestResourceBundle;
import utils.loggingframework.logmapping.LogMapping;
import utils.loggingframework.ui.repository.LogWizard;
import utils.swing.SwingStyleInterface;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;

public class LogWizardGlassDialog
extends ScaledGlassDialog {
    private ResourceBundle bundle;
    private SwingStyleInterface style;
    private LogWizard wizard;

    public LogWizardGlassDialog(RootPaneContainer rootPane, ResourceBundle bundle, SwingStyleInterface style) {
        this(rootPane, bundle, style, null);
    }

    public LogWizardGlassDialog(RootPaneContainer rootPane, ResourceBundle bundle, SwingStyleInterface style, LogMapping mapping) {
        super(rootPane, 700, 500, true, true, false);
        this.bundle = bundle;
        this.style = style;
        this.setModal(true);
        this.initUI(mapping);
        this.setVisible(true);
    }

    public LogMapping getResult() {
        return this.wizard.getResult();
    }

    private void initUI(LogMapping mapping) {
        this.setTitle(this.bundle.getString("LOG_WIZARD_TITLE"));
        this.wizard = new LogWizard(this.bundle, this, this.style, mapping);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add("Center", this.wizard.getRootComponent());
        this.getContentPane().add(contentPanel);
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException, IOException, InterruptedException {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setDefaultCloseOperation(3);
        ((Window)frame).setSize(500, 500);
        frame.setVisible(true);
        Thread.sleep(1000L);
        LogWizardGlassDialog dialog = new LogWizardGlassDialog(frame, new TestResourceBundle(), new SwingStyleInterface(){

            @Override
            public Border getBorder() {
                return null;
            }

            @Override
            public Color getInnerBorderColor() {
                return Color.red;
            }

            @Override
            public Color getBorderColor() {
                return Color.green;
            }

            @Override
            public ImageIcon getImageIcon(String key) {
                return null;
            }

            @Override
            public ImageIcon getDisabledImageIcon(String key) {
                return null;
            }

            @Override
            public Color getExampleTextColor() {
                return null;
            }
        });
        dialog.setVisible(true);
    }
}

