/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.LocatableTarget;
import utils.loggingframework.targets.TargetRepository;
import utils.loggingframework.targets.TargetUI;
import utils.loggingframework.targets.TargetUIListener;
import utils.loggingframework.targets.donothing.DoNothing;
import utils.swing.SwingStyleInterface;
import utils.swing.components.JWrapLabel;
import utils.swing.components.SHComboBox;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class SelectTargetComponent {
    private SHComboBox scopeBox;
    private SHComboBox targetBox;
    private JPanel targetPanel;
    private JWrapLabel descriptionLabel = new JWrapLabel();
    private JPanel configurationPanel;
    private CardLayout cLayout = new CardLayout();
    private GbPanel rootComponent;
    private HashMap<String, TargetUI> nameToTargetUIMap = new HashMap();
    private TargetUI currentUI;
    private TargetUIListener canProceedListener;
    private LogEvent[] eventsToTarget = null;
    private SwingStyleInterface style;
    private boolean initialising;
    private GbPanel tPanel;
    private ResourceBundle bundle;
    private AbstractTarget currentSelection;
    private boolean showPerMachineOption;

    public SelectTargetComponent(ResourceBundle bundle, TargetUIListener canProceedListener, SwingStyleInterface style, boolean showPerMachineOption) {
        this.canProceedListener = canProceedListener;
        this.style = style;
        this.bundle = bundle;
        this.showPerMachineOption = showPerMachineOption;
        this.initUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(AbstractTarget target) {
        this.initialising = true;
        try {
            this.currentSelection = target;
            for (TargetUI targetUI : this.nameToTargetUIMap.values()) {
                targetUI.initWithTarget(target);
                if (targetUI.getRootComponent() == null) continue;
                targetUI.getRootComponent().repaint();
            }
            if (target != null) {
                this.targetBox.setSelectedItem(target);
            } else {
                this.targetBox.setSelectedIndex(0);
            }
            this.targetBox.repaint();
            if (this.showPerMachineOption) {
                if (target instanceof LocatableTarget) {
                    LocatableTarget locTarget = (LocatableTarget)((Object)target);
                    if (locTarget.runPerMachine()) {
                        this.scopeBox.setSelectedIndex(1);
                    } else {
                        this.scopeBox.setSelectedIndex(0);
                    }
                    if (locTarget.runPerMachineIsOptional()) {
                        this.scopeBox.setEnabled(true);
                    } else {
                        this.scopeBox.setEnabled(false);
                    }
                }
            } else {
                this.scopeBox.setVisible(false);
                this.scopeBox.setSelectedIndex(0);
            }
        }
        finally {
            this.initialising = false;
        }
    }

    public void setLogEventsToTarget(LogEvent[] eventsToTarget) {
        if (this.eventsToTarget != null && Arrays.equals(eventsToTarget, this.eventsToTarget)) {
            return;
        }
        AbstractTarget[] targetInstances = this.filterTargetInstances(TargetRepository.INSTANCE.getTargetInstances(this.bundle));
        this.initTargetBox(targetInstances);
        this.eventsToTarget = eventsToTarget;
        if (this.currentUI != null) {
            this.currentUI.setEventsToTarget(eventsToTarget);
        }
    }

    protected AbstractTarget[] filterTargetInstances(AbstractTarget[] instances) {
        return instances;
    }

    private void initUI() {
        AbstractTarget[] targetInstances = this.filterTargetInstances(TargetRepository.INSTANCE.getTargetInstances(this.bundle));
        this.rootComponent = new GbPanel();
        this.scopeBox = new SHComboBox(new String[]{this.bundle.getString("ACTION_FOR_ONCE"), this.bundle.getString("ACTION_FOR_EVERY_MACHINE")});
        this.initTargetBox(targetInstances);
        this.initConfigurationPanel(this.bundle, targetInstances);
        this.initTargetPanel();
        JLabel label = new JLabel(this.bundle.getString("LOGGING_FRAMEWORK_ACTION"));
        this.rootComponent.add(label, 0, 0, 1, 1, 0, 0, 13, 0, new Insets(3, 3, 3, 3));
        this.rootComponent.add(this.targetBox, 1, 0, 1, 1, 1, 0, 17, 0, new Insets(3, 3, 3, 3));
        this.rootComponent.add(this.scopeBox, 2, 0, 1, 1, 1, 0, 17, 0, new Insets(3, 3, 3, 3));
        this.rootComponent.add(new JPanel(), 2, 0, 1, 1, 1000, 0, 17, 2, new Insets(3, 3, 3, 3));
        this.rootComponent.add(this.targetPanel, 0, 1, 4, 1, 1, 1, 10, 1, new Insets(3, 3, 3, 3));
        this.targetBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractTarget target = (AbstractTarget)SelectTargetComponent.this.targetBox.getSelectedItem();
                SelectTargetComponent.this.setSelectedTarget(target);
            }
        });
        this.scopeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!SelectTargetComponent.this.initialising && SelectTargetComponent.this.currentSelection != null && SelectTargetComponent.this.currentSelection instanceof LocatableTarget) {
                    ((LocatableTarget)((Object)SelectTargetComponent.this.currentSelection)).setRunPerMachine(SelectTargetComponent.this.scopeBox.getSelectedIndex() == 1);
                    if (SelectTargetComponent.this.currentUI != null) {
                        SelectTargetComponent.this.currentUI.notifyIfComplete();
                    }
                }
            }
        });
    }

    protected void setSelectedTarget(AbstractTarget target) {
        if (!this.initialising) {
            this.load(target);
        }
        this.cLayout.show(this.configurationPanel, target.getName());
        this.descriptionLabel.setText(target.getDescription());
        this.currentUI = this.nameToTargetUIMap.get(target.getName());
        this.currentUI.setEventsToTarget(this.eventsToTarget);
        if (!this.initialising) {
            this.currentUI.notifyIfComplete();
        }
        boolean showConfiguration = !(target instanceof DoNothing);
        this.descriptionLabel.setVisible(showConfiguration);
        this.configurationPanel.setVisible(showConfiguration);
        if (showConfiguration) {
            this.targetPanel.setBorder(this.style.getBorder());
        } else {
            this.targetPanel.setBorder(SHBorderFactory.createEmptyBorder());
        }
        if (!(target instanceof LocatableTarget)) {
            this.scopeBox.setSelectedIndex(0);
            this.scopeBox.setEnabled(false);
        }
    }

    private void initTargetPanel() {
        this.tPanel = new GbPanel(new ScaledInsets(4, 4, 4, 4));
        this.tPanel.add(this.descriptionLabel, 0, 1, 1, 1, 1, 1, 17, 2, new Insets(4, 4, 10, 4));
        this.tPanel.add(this.configurationPanel, 0, 2, 1, 1, 1, 100, 17, 1);
        this.targetPanel = this.tPanel;
        this.setTargetPanelBorder();
    }

    private void setTargetPanelBorder() {
        this.targetPanel.setBorder(this.style.getBorder());
    }

    private void initConfigurationPanel(ResourceBundle bundle, AbstractTarget[] targetInstances) {
        this.configurationPanel = new JPanel();
        this.configurationPanel.setLayout(this.cLayout);
        if (this.style.getInnerBorderColor() != null) {
            this.configurationPanel.setBackground(this.style.getInnerBorderColor());
        }
        for (int i = 0; i < targetInstances.length; ++i) {
            TargetUI targetUI = targetInstances[i].getTargetUI();
            targetUI.setResources(bundle, this.style);
            targetUI.setEventsToTarget(this.eventsToTarget);
            targetUI.addTargetUIListener(this.canProceedListener);
            if (targetUI.getRootComponent() != null) {
                this.configurationPanel.add((Component)targetUI.getRootComponent(), targetInstances[i].getName());
            }
            this.nameToTargetUIMap.put(targetInstances[i].getName(), targetUI);
        }
    }

    private void initTargetBox(AbstractTarget[] targetInstances) {
        if (this.targetBox == null) {
            this.targetBox = new SHComboBox(targetInstances);
        } else {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.targetBox.getModel();
            ArrayList<AbstractTarget> removals = new ArrayList<AbstractTarget>();
            for (int i = 0; i < model.getSize(); ++i) {
                AbstractTarget targetInModel = (AbstractTarget)model.getElementAt(i);
                boolean found = false;
                for (AbstractTarget targetInstance : targetInstances) {
                    if (!targetInstance.equals(targetInModel)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                removals.add(targetInModel);
            }
            for (AbstractTarget target : removals) {
                model.removeElement(target);
            }
        }
    }

    public JComponent getComponent() {
        return this.rootComponent;
    }

    public AbstractTarget getSelectedAbstractTarget() {
        AbstractTarget target = (AbstractTarget)this.targetBox.getSelectedItem();
        if ((target = TargetRepository.INSTANCE.getNewTargetInstance(target)) instanceof LocatableTarget) {
            ((LocatableTarget)((Object)target)).setRunPerMachine(this.scopeBox.getSelectedIndex() == 1);
        }
        if (this.currentUI != null) {
            this.currentUI.populateTarget(target);
        }
        return target;
    }
}

