/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.filters.LogFilter;
import utils.loggingframework.logmapping.LogMapping;
import utils.loggingframework.logmapping.LogMappingImpl;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.TargetUIListener;
import utils.loggingframework.ui.LoggingIcons;
import utils.loggingframework.ui.SelectEventTable;
import utils.loggingframework.ui.SelectTargetComponent;
import utils.loggingframework.ui.SpecifyFiltersUI;
import utils.swing.SwingStyleInterface;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public abstract class LogMappingWizard
implements ActionListener {
    private JComponent rootComponent = new JPanel();
    private CardLayout rootCardLayout = new CardLayout();
    private JPanel selectTargetPanel;
    private JPanel selectEventsPanel;
    private JPanel specifyFiltersPanel;
    private ResourceBundle bundle;
    private JButton nextToTargetsButton;
    private JButton nextToFiltersButton;
    private JButton doneButton;
    private JTextField nameField = new JTextField();
    private SelectEventTable eventsTable;
    private SelectTargetComponent targetSelectComponent;
    private SwingStyleInterface style;
    private LogMapping loadedMapping;
    private SpecifyFiltersUI filterUI;
    TargetUIListener canFinishListener = new TargetUIListener(){

        @Override
        public void targetUIComplete() {
            if (LogMappingWizard.this.doneButton != null) {
                LogMappingWizard.this.doneButton.setEnabled(true);
            }
        }

        @Override
        public void targetUIIncomplete() {
            if (LogMappingWizard.this.doneButton != null) {
                LogMappingWizard.this.doneButton.setEnabled(false);
            }
        }

        @Override
        public void targetChanged() {
        }
    };

    public abstract void cancelled();

    public abstract void done(LogMapping var1);

    public LogMappingWizard(ResourceBundle bundle, SwingStyleInterface style, LogMapping mapping) {
        this.bundle = bundle;
        this.style = style;
        this.initUI(mapping);
    }

    public Component getRootComponent() {
        return this.rootComponent;
    }

    protected Border getBorder(String title) {
        return SHBorderFactory.createTitledBorder(this.style.getBorder(), title);
    }

    private void initUI(LogMapping mapping) {
        this.loadedMapping = mapping;
        this.rootComponent.setLayout(this.rootCardLayout);
        if (mapping == null) {
            this.initSelectTargetPanel(null);
            this.initSpecifyFilterPanel();
            this.initSelectEventsPanel(null, null);
        } else {
            this.initSelectTargetPanel(mapping.getTarget());
            this.initSpecifyFilterPanel();
            this.initSelectEventsPanel(mapping.getLogMappingDescription(), mapping.getLogEventIDs());
        }
        this.rootComponent.add((Component)this.selectEventsPanel, "EVENT");
        this.rootComponent.add((Component)this.specifyFiltersPanel, "FILTER");
        this.rootComponent.add((Component)this.selectTargetPanel, "TARGET");
    }

    private void checkEventsEnabled() {
        if (this.eventsTable.getSelectedEventIDs() == null || this.eventsTable.getSelectedEventIDs().length == 0 || this.nameField.getText().length() == 0) {
            this.nextToFiltersButton.setEnabled(false);
        } else {
            this.nextToFiltersButton.setEnabled(true);
        }
        this.nextToTargetsButton.setEnabled(this.filterUI.isComplete());
    }

    private void initSpecifyFilterPanel() {
        this.specifyFiltersPanel = new JPanel(new BorderLayout());
        this.filterUI = new SpecifyFiltersUI(this.bundle, this.style, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogMappingWizard.this.checkEventsEnabled();
            }
        });
        GbPanel headerPanel = new GbPanel();
        JLabel nameLabel = new JLabel(this.bundle.getString("LOGGING_UI_FILTER_EVENTS_DESC"));
        nameLabel.setIcon(this.style.getImageIcon(LoggingIcons.LOG_FILTER_LARGE));
        nameLabel.setIconTextGap(8);
        headerPanel.add(nameLabel, 0, 0, 1, 1, 0, 0, 13, 0, new Insets(10, 3, 10, 3));
        headerPanel.add(this.filterUI.getRootComponent(), 0, 2, 2, 1, 1, 100, 10, 1, new Insets(3, 3, 3, 3));
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(2, 10, 2, 10));
        this.nextToTargetsButton = new JButton(this.bundle.getString("NEXT"));
        this.nextToTargetsButton.setEnabled(false);
        SwingUtil.makeButtonBlue(this.nextToTargetsButton);
        JButton cancelButton = new JButton(this.bundle.getString("CANCEL"));
        JPanel buttonWidthPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        buttonWidthPanel.add(cancelButton);
        buttonWidthPanel.add(this.nextToTargetsButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogMappingWizard.this.cancelled();
            }
        });
        buttonsPanel.add(buttonWidthPanel, 0, 0, 1, 1, 1, 1, 13, 0);
        buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.nextToTargetsButton.addActionListener(this);
        this.specifyFiltersPanel.add((Component)headerPanel, "Center");
        this.specifyFiltersPanel.add((Component)buttonsPanel, "South");
    }

    private void initSelectEventsPanel(String name, String[] eventIDs) {
        this.selectEventsPanel = new JPanel();
        this.selectEventsPanel.setLayout(new BorderLayout());
        this.eventsTable = new SelectEventTable(this.bundle);
        this.eventsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                LogMappingWizard.this.checkEventsEnabled();
            }
        });
        GbPanel tablePanel = new GbPanel();
        JLabel description = new JLabel(this.bundle.getString("LOGGING_UI_SELECT_EVENTS_DESC"));
        JLabel nameLabel = new JLabel(this.bundle.getString("LOGGING_UI_LOG_SET_NAME"));
        nameLabel.setIcon(this.style.getImageIcon(LoggingIcons.LOG_SET_LARGE));
        nameLabel.setIconTextGap(8);
        tablePanel.add(nameLabel, 0, 0, 1, 1, 0, 0, 13, 0, new Insets(10, 3, 10, 3));
        tablePanel.add(this.nameField, 1, 0, 1, 1, 0, 0, 17, 0, new Insets(10, 3, 10, 3));
        tablePanel.add(description, 0, 1, 2, 1, 1, 0, 17, 2, new Insets(3, 3, 3, 3));
        tablePanel.add(this.eventsTable.getScrollPaneComponent(), 0, 2, 2, 1, 1, 1, 13, 1, new Insets(3, 3, 3, 3));
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                LogMappingWizard.this.checkEventsEnabled();
            }
        });
        SwingUtil.setWidth(this.nameField, 300);
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(2, 10, 2, 10));
        this.nextToFiltersButton = new JButton(this.bundle.getString("NEXT"));
        this.nextToFiltersButton.setEnabled(false);
        SwingUtil.makeButtonBlue(this.nextToFiltersButton);
        JButton cancelButton = new JButton(this.bundle.getString("CANCEL"));
        JPanel buttonWidthPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        buttonWidthPanel.add(cancelButton);
        buttonWidthPanel.add(this.nextToFiltersButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogMappingWizard.this.cancelled();
            }
        });
        buttonsPanel.add(buttonWidthPanel, 0, 0, 1, 1, 1, 1, 13, 0);
        buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.nextToFiltersButton.addActionListener(this);
        this.selectEventsPanel.add((Component)tablePanel, "Center");
        this.selectEventsPanel.add((Component)buttonsPanel, "South");
        if (eventIDs != null && name != null) {
            this.nameField.setText(name);
            this.eventsTable.setSelectedEvents(eventIDs);
            this.checkEventsEnabled();
        }
    }

    private void initSelectTargetPanel(AbstractTarget target) {
        this.doneButton = new JButton(this.bundle.getString("DONE"));
        this.doneButton.setEnabled(false);
        SwingUtil.makeButtonBlue(this.doneButton);
        this.selectTargetPanel = new JPanel();
        this.selectTargetPanel.setLayout(new BorderLayout());
        this.targetSelectComponent = new SelectTargetComponent(this.bundle, this.canFinishListener, this.style, false);
        this.targetSelectComponent.load(target);
        GbPanel targetsPanel = new GbPanel();
        JLabel desc = new JLabel(this.bundle.getString("LOGGING_UI_SELECT_TARGET_DESC"));
        desc.setIcon(this.style.getImageIcon(LoggingIcons.LOG_TARGET_LARGE));
        desc.setIconTextGap(8);
        targetsPanel.add(desc, 0, 0, 1, 1, 0, 0, 17, 0, new Insets(10, 3, 10, 3));
        targetsPanel.add(this.targetSelectComponent.getComponent(), 0, 1, 1, 1, 1, 1, 10, 1, new Insets(3, 3, 3, 3));
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(2, 10, 2, 10));
        JButton cancelButton = new JButton(this.bundle.getString("CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogMappingWizard.this.cancelled();
            }
        });
        JPanel buttonWidthPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        buttonWidthPanel.add(cancelButton);
        buttonWidthPanel.add(this.doneButton);
        buttonsPanel.add(buttonWidthPanel, 0, 0, 1, 1, 1, 1, 13, 0);
        buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.doneButton.addActionListener(this);
        this.selectTargetPanel.add((Component)targetsPanel, "Center");
        this.selectTargetPanel.add((Component)buttonsPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.nextToFiltersButton) {
            LogEvent[] events = this.eventsTable.getSelectedEventInstances();
            if (this.loadedMapping == null) {
                this.filterUI.setEvents(events);
            } else {
                this.filterUI.setEvents(events);
                this.filterUI.loadFromExistingFilters(this.loadedMapping.getFilters());
            }
            this.checkEventsEnabled();
            this.rootCardLayout.show(this.rootComponent, "FILTER");
        } else if (e.getSource() == this.nextToTargetsButton) {
            this.targetSelectComponent.setLogEventsToTarget(this.eventsTable.getSelectedEventInstances());
            this.rootCardLayout.show(this.rootComponent, "TARGET");
        } else if (e.getSource() == this.doneButton) {
            String[] events = this.eventsTable.getSelectedEventIDs();
            AbstractTarget target = this.targetSelectComponent.getSelectedAbstractTarget();
            LogFilter[] filters = this.filterUI.getFilters();
            LogMappingImpl mapping = new LogMappingImpl(this.nameField.getText(), events, target, filters);
            this.done(mapping);
        }
    }
}

