/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets.email;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import utils.loggingframework.events.EventRepository;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.AbstractTargetUI;
import utils.loggingframework.targets.email.EmailAddressMap;
import utils.loggingframework.targets.email.EmailTarget;
import utils.loggingframework.targets.email.EventEmailTemplate;
import utils.swing.JComboBoxFixer;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.SHComboBox;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;

public class EmailTargetUI
extends AbstractTargetUI
implements ActionListener,
FocusListener {
    private GbPanel rootComponent = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
    private JLabel toAddressLabel = new JLabel();
    private JTextField toAddressField = new JTextField();
    private JLabel subjectLabel = new JLabel();
    private JLabel eventLabel = new JLabel();
    private JLabel variablesLabel = new JLabel();
    private JComboBox eventsBox = new SHComboBox();
    private JComboBox variablesBox = new SHComboBox();
    private JTextField subject = new JTextField();
    private JTextArea content = new JTextArea();
    private JButton insertButton = new JButton();
    private JButton addButton = new JButton();
    private ArrayList<EventEmailTemplate> eventTemplates = new ArrayList();
    protected KeyListener saveListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent event) {
            EmailTargetUI.this.saveTemplateChange();
        }
    };
    private String[] emailAddressKeys;
    boolean contentWasLastFocused = true;

    private EventEmailTemplate getTemplateForEvent(LogEvent event) {
        for (int i = 0; i < this.eventTemplates.size(); ++i) {
            EventEmailTemplate template = this.eventTemplates.get(i);
            if (!template.isForEvent(event)) continue;
            return template;
        }
        EventEmailTemplate template = EventRepository.INSTANCE.getEmailTemplate(event);
        template = template == null ? new EventEmailTemplate(event) : (EventEmailTemplate)template.clone();
        this.eventTemplates.add(template);
        return template;
    }

    private void saveTemplateChange() {
        LogEvent selectedEvent = (LogEvent)this.eventsBox.getSelectedItem();
        EventEmailTemplate templateForEvent = this.getTemplateForEvent(selectedEvent);
        templateForEvent.setContent(this.subject.getText(), this.content.getText());
        this.notifyChanged();
    }

    @Override
    public void populateTarget(AbstractTarget target) {
        if (target instanceof EmailTarget) {
            EmailTarget emailTarget = (EmailTarget)target;
            emailTarget.toEmailAddresses = this.toAddressField.getText().trim().split("\\,");
            emailTarget.storedEmailTemplates = new EventEmailTemplate[this.eventTemplates.size()];
            this.eventTemplates.toArray(emailTarget.storedEmailTemplates);
        }
    }

    @Override
    public void setEventsToTarget(LogEvent[] events) {
        if (Arrays.equals(events, this.events)) {
            return;
        }
        super.setEventsToTarget(events);
        if (events != null) {
            this.eventsBox.setModel(new DefaultComboBoxModel<LogEvent>(events));
            if (events.length > 0) {
                this.eventsBox.setSelectedIndex(0);
            }
            this.eventsBox.setVisible(events.length > 1);
            this.eventLabel.setVisible(events.length > 1);
        }
        this.emailAddressKeys = EmailTargetUI.getEmailAddressesCommonToAllEvents(events);
        if (this.emailAddressKeys == null || this.emailAddressKeys.length == 0) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                this.getTemplateForEvent(events[i]);
            }
        }
    }

    @Override
    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.toAddressField.setEnabled(enabled);
    }

    @Override
    public void notifyIfComplete() {
        String text = this.toAddressField.getText();
        if (text.length() > 0 && (text.indexOf(64) > 0 || text.indexOf(36) >= 0)) {
            this.notifyComplete();
        } else {
            this.notifyIncomplete();
        }
    }

    @Override
    protected void initUI() {
        this.toAddressLabel.setText(this.bundle.getString("TARGET_UI_EMAIL_TOADDRESS"));
        this.subjectLabel.setText(this.bundle.getString("TARGET_UI_EMAIL_SUBJECT"));
        this.eventLabel.setText(this.bundle.getString("TARGET_UI_EMAIL_EVENTS"));
        this.variablesLabel.setText(this.bundle.getString("TARGET_UI_EMAIL_VARIABLES"));
        this.insertButton.setText(this.bundle.getString("TARGET_UI_EMAIL_INSERT"));
        this.addButton.setText("+");
        this.rootComponent.add(this.toAddressLabel, 0, 0, 1, 1, 0, 1, 13, 3);
        this.rootComponent.add(this.toAddressField, 1, 0, 1, 1, 1, 1, 17, 1, new Insets(3, 3, 0, 0));
        this.rootComponent.add(this.addButton, 2, 0, 1, 1, 1, 1, 17, 3, new Insets(3, 0, 0, 3));
        SwingUtil.setHeight(this.addButton, this.toAddressField.getPreferredSize().height);
        GbPanel configureTemplatesPanel = new GbPanel();
        configureTemplatesPanel.setBackground(this.style.getInnerBorderColor());
        configureTemplatesPanel.setBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, this.style.getBorderColor()));
        JScrollPane sp = new JScrollPane(this.content){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (dim.height < SimpleHelpLookAndFeel.scale(150)) {
                    dim.height = SimpleHelpLookAndFeel.scale(150);
                }
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                if (dim.height < SimpleHelpLookAndFeel.scale(150)) {
                    dim.height = SimpleHelpLookAndFeel.scale(150);
                }
                return dim;
            }
        };
        SwingUtil.setHeight(sp, SimpleHelpLookAndFeel.scale(150));
        this.content.setBackground(Color.WHITE);
        sp.setBackground(Color.WHITE);
        GbPanel variablesPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        variablesPanel.setBackground(this.style.getInnerBorderColor());
        variablesPanel.add(this.variablesLabel, 0, 0, 1, 1, 1, 1, 13, 0);
        variablesPanel.add(this.variablesBox, 1, 0, 1, 1, 1, 1, 17, 0);
        variablesPanel.add(this.insertButton, 2, 0, 1, 1, 0, 1, 17, 0);
        configureTemplatesPanel.add(this.eventLabel, 0, 0, 1, 1, 1, 1, 13, 0, new Insets(3, 0, 3, 3));
        configureTemplatesPanel.add(this.eventsBox, 1, 0, 1, 1, 100, 1, 17, 0, new Insets(3, 3, 3, 0));
        configureTemplatesPanel.add(this.subjectLabel, 0, 1, 1, 1, 1, 1, 13, 0, new Insets(3, 0, 3, 3));
        configureTemplatesPanel.add(this.subject, 1, 1, 1, 1, 100, 1, 17, 0, new Insets(3, 3, 3, 0));
        configureTemplatesPanel.add(sp, 0, 2, 2, 1, 1, 100, 17, 1);
        configureTemplatesPanel.add(variablesPanel, 0, 3, 2, 1, 100, 1, 13, 0);
        this.rootComponent.add(configureTemplatesPanel, 0, 1, 3, 1, 1, 1000, 10, 1, new Insets(3, 3, 3, 3));
        this.toAddressField.addKeyListener(this.changedAllListener);
        SwingUtil.setWidth(this.toAddressField, 300);
        SwingUtil.setWidth(this.subject, 400);
        this.eventsBox.addActionListener(this);
        this.insertButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.content.addFocusListener(this);
        this.subject.addFocusListener(this);
        this.subject.addKeyListener(this.saveListener);
        this.content.addKeyListener(this.saveListener);
        this.variablesBox.setEnabled(false);
        this.insertButton.setEnabled(false);
        SwingUtil.setHeight(this.addButton, this.toAddressField.getPreferredSize().height);
        SHButtonUI.makeButtonSegmentedRight(this.addButton);
        this.rootComponent.setBackground(this.style.getInnerBorderColor());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.eventsBox) {
            LogEvent selectedEvent = (LogEvent)this.eventsBox.getSelectedItem();
            this.loadSelectedEvent(selectedEvent);
        } else if (event.getSource() == this.insertButton) {
            String selectedVariable = "${" + this.variablesBox.getSelectedItem() + "}";
            if (this.contentWasLastFocused) {
                this.content.insert(selectedVariable, this.content.getCaretPosition());
                this.content.requestFocusInWindow();
            } else {
                int pos = this.subject.getCaretPosition();
                this.subject.setText(this.subject.getText().substring(0, pos) + selectedVariable + this.subject.getText().substring(pos));
                this.subject.setCaretPosition(pos + selectedVariable.length());
            }
            this.saveTemplateChange();
        } else if (event.getSource() == this.addButton) {
            JPopupMenu menu = this.getAddEmailAddressMenu();
            Rectangle bounds = this.addButton.getBounds();
            menu.show(this.addButton, -1, bounds.y + bounds.height);
        }
    }

    private void loadSelectedEvent(LogEvent selectedEvent) {
        System.out.println("Loading " + selectedEvent);
        if (selectedEvent != null) {
            EventEmailTemplate templateForEvent = this.getTemplateForEvent(selectedEvent);
            this.subject.setText(templateForEvent.getSubject());
            this.content.setText(templateForEvent.getBody());
            this.variablesBox.setModel(new DefaultComboBoxModel<LogEvent.LogEventVariable>(selectedEvent.getVariables()));
        } else {
            this.subject.setText("");
            this.content.setText("");
            this.variablesBox.setModel(new DefaultComboBoxModel());
        }
    }

    private JPopupMenu getAddEmailAddressMenu() {
        JPopupMenu emailAddressMenu = new JPopupMenu();
        JComboBoxFixer.fix(emailAddressMenu);
        for (int i = 0; i < this.emailAddressKeys.length; ++i) {
            JMenuItem item = new JMenuItem(new InsertEmailAddressAction(this.emailAddressKeys[i]));
            emailAddressMenu.add(item);
        }
        return emailAddressMenu;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.variablesBox.setEnabled(true);
        this.insertButton.setEnabled(true);
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.contentWasLastFocused = arg0.getSource() == this.content;
    }

    @Override
    public void initWithTarget(AbstractTarget target) {
        if (!(target instanceof EmailTarget)) {
            return;
        }
        EmailTarget et = (EmailTarget)target;
        StringBuffer toAddresses = new StringBuffer();
        if (et != null && et.toEmailAddresses != null) {
            for (int i = 0; i < et.toEmailAddresses.length; ++i) {
                if (i > 0) {
                    toAddresses.append(", ");
                }
                toAddresses.append(et.toEmailAddresses[i]);
            }
        }
        this.toAddressField.setText(toAddresses.toString());
        this.eventTemplates.clear();
        EventEmailTemplate[] targetsTemplates = et.storedEmailTemplates;
        if (targetsTemplates != null) {
            for (int i = 0; i < targetsTemplates.length; ++i) {
                this.eventTemplates.add(targetsTemplates[i]);
            }
        }
        LogEvent selectedEvent = (LogEvent)this.eventsBox.getSelectedItem();
        this.loadSelectedEvent(selectedEvent);
    }

    public static String[] getEmailAddressesCommonToAllEvents(LogEvent[] events) {
        ArrayList list = new ArrayList();
        if (events == null || events.length == 0) {
            return new String[0];
        }
        EmailAddressMap possibleEmailAddressesInEvent = events[0].getPossibleEmailAddressesInEvent();
        if (possibleEmailAddressesInEvent == null) {
            return new String[0];
        }
        String[] firstEventKeys = possibleEmailAddressesInEvent.getAllEmailKeys();
        Collections.addAll(list, firstEventKeys);
        for (int i = 1; i < events.length && list.size() != 0; ++i) {
            EmailAddressMap addressMap = events[i].getPossibleEmailAddressesInEvent();
            if (addressMap == null) {
                return new String[0];
            }
            String[] nextEventKeys = addressMap.getAllEmailKeys();
            List<String> nextEventKeysList = Arrays.asList(nextEventKeys);
            for (int j = list.size() - 1; j >= 0; --j) {
                if (nextEventKeysList.contains(list.get(j))) continue;
                list.remove(j);
            }
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    class InsertEmailAddressAction
    extends AbstractAction {
        private String key;

        public InsertEmailAddressAction(String key) {
            super(key);
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean existingAddress;
            boolean bl = existingAddress = EmailTargetUI.this.toAddressField.getText().trim().length() > 0;
            if (existingAddress) {
                EmailTargetUI.this.toAddressField.setText(EmailTargetUI.this.toAddressField.getText() + ", ${" + this.key + "}");
            } else {
                EmailTargetUI.this.toAddressField.setText("${" + this.key + "}");
            }
            EmailTargetUI.this.notifyIfComplete();
        }
    }
}

