/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets.command;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.AbstractTargetUI;
import utils.loggingframework.targets.VariableUtil;
import utils.loggingframework.targets.command.CommandTarget;
import utils.swing.components.SHComboBox;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class CommandTargetUI
extends AbstractTargetUI
implements ActionListener {
    private GbPanel rootComponent = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private JTextArea content = new JTextArea();
    private JLabel variablesLabel = new JLabel();
    private JComboBox variablesBox = new SHComboBox();
    private JButton insertButton = new JButton();

    @Override
    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void populateTarget(AbstractTarget target) {
        if (!(target instanceof CommandTarget)) {
            return;
        }
        String command = this.content.getText();
        String[] tokens = CommandTargetUI.getCommandTokens(command);
        CommandTarget ct = (CommandTarget)target;
        ct.commandToRun = tokens;
    }

    private static String[] getCommandTokens(String command) {
        ArrayList<String> matchTokens = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(command);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchTokens.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchTokens.add(regexMatcher.group(2));
                continue;
            }
            matchTokens.add(regexMatcher.group());
        }
        return matchTokens.toArray(new String[0]);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.content.setEnabled(enabled);
        this.insertButton.setEnabled(enabled);
        this.variablesBox.setEnabled(enabled);
        this.variablesLabel.setEnabled(enabled);
        this.rootComponent.setEnabled(enabled);
    }

    @Override
    public void notifyIfComplete() {
        String contentString = this.content.getText();
        if (contentString != null && contentString.trim().length() > 0) {
            this.notifyComplete();
        } else {
            this.notifyIncomplete();
        }
    }

    @Override
    public void initWithTarget(AbstractTarget target) {
        if (!(target instanceof CommandTarget)) {
            return;
        }
        CommandTarget ct = (CommandTarget)target;
        String[] command = ct.commandToRun;
        StringBuffer completeCommand = new StringBuffer();
        if (command != null) {
            for (int i = 0; i < command.length; ++i) {
                if (i > 0) {
                    completeCommand.append(' ');
                }
                if (command[i].indexOf(32) != -1) {
                    completeCommand.append('\"').append(command[i]).append('\"');
                    continue;
                }
                completeCommand.append(command[i]);
            }
        }
        this.content.setText(completeCommand.toString());
    }

    @Override
    protected void initUI() {
        this.rootComponent.setBackground(this.style.getInnerBorderColor());
        this.variablesLabel.setText(this.bundle.getString("TARGET_UI_EMAIL_VARIABLES"));
        this.insertButton.setText(this.bundle.getString("TARGET_UI_EMAIL_INSERT"));
        JScrollPane sp = new JScrollPane(this.content);
        this.content.setLineWrap(true);
        this.content.setBackground(Color.WHITE);
        sp.setBackground(Color.WHITE);
        GbPanel variablesPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        variablesPanel.setBackground(this.style.getInnerBorderColor());
        variablesPanel.add(this.variablesLabel, 0, 0, 1, 1, 1, 1, 13, 0);
        variablesPanel.add(this.variablesBox, 1, 0, 1, 1, 1, 1, 17, 0);
        variablesPanel.add(this.insertButton, 2, 0, 1, 1, 0, 1, 17, 0);
        this.rootComponent.add(sp, 0, 2, 2, 1, 1, 100, 17, 1);
        this.rootComponent.add(variablesPanel, 0, 3, 2, 1, 100, 1, 13, 0);
        this.insertButton.addActionListener(this);
        this.content.addKeyListener(this.changedAllListener);
    }

    @Override
    public void setEventsToTarget(LogEvent[] events) {
        super.setEventsToTarget(events);
        if (events != null) {
            LogEvent.LogEventVariable[] commonVariables = VariableUtil.getCommonVariables(events);
            this.variablesBox.setModel(new DefaultComboBoxModel<LogEvent.LogEventVariable>(commonVariables));
            if (commonVariables.length > 0) {
                this.variablesBox.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.insertButton) {
            String selectedVariable = "${" + this.variablesBox.getSelectedItem() + "}";
            this.content.insert(selectedVariable, this.content.getCaretPosition());
            this.content.requestFocusInWindow();
            this.notifyIfComplete();
            this.notifyChanged();
        }
    }
}

