/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import utils.email.CommonEmailer;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.events.VariableProcessor;
import utils.loggingframework.targets.email.EventEmailTemplate;

public class EventRepository {
    public static EventRepository INSTANCE = new EventRepository();
    private HashMap<String, Class<? extends LogEvent>> idToEventMap = new HashMap();
    private HashMap<Class<? extends LogEvent>, String> eventToIDMap = new HashMap();
    private ArrayList<LogEventWrapper> logEventWrappers = new ArrayList();
    private ArrayList<VariableProcessor> variableProcessors = new ArrayList();
    private CommonEmailer emailUtil = null;
    private HashMap<String, EventEmailTemplate> eventToEmailTemplateMap = new HashMap();

    public EventEmailTemplate getEmailTemplate(LogEvent event) {
        return this.eventToEmailTemplateMap.get(event.getEventType());
    }

    public String getEventIDForClass(Class<? extends LogEvent> logEventClass) {
        return null;
    }

    public void putEmailTemplate(LogEvent event, String subject, String content) {
        EventEmailTemplate template = new EventEmailTemplate(event);
        template.setContent(subject, content);
        this.eventToEmailTemplateMap.put(event.getEventType(), template);
    }

    public int getEmailTemplateSize() {
        return this.eventToEmailTemplateMap.size();
    }

    public void setEmailUtil(CommonEmailer email) {
        this.emailUtil = email;
    }

    public static LogEvent[] getEventInstances(ArrayList<Class<? extends LogEvent>> classes) {
        ArrayList<LogEvent> result = new ArrayList<LogEvent>();
        for (Class<? extends LogEvent> eventClass : classes) {
            try {
                result.add(eventClass.newInstance());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result.toArray(new LogEvent[0]);
    }

    public LogEvent[] getEventInstances(String group) {
        ArrayList<LogEvent> result = new ArrayList<LogEvent>();
        for (LogEventWrapper wrapper : this.logEventWrappers) {
            String groupName = wrapper.groupName;
            if (!group.equals(groupName)) continue;
            try {
                result.add(wrapper.logEventClass.newInstance());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result.toArray(new LogEvent[0]);
    }

    public LogEvent[] getAllEventInstances() {
        ArrayList<LogEvent> result = new ArrayList<LogEvent>();
        for (LogEventWrapper wrapper : this.logEventWrappers) {
            try {
                result.add(wrapper.logEventClass.newInstance());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result.toArray(new LogEvent[0]);
    }

    public void addEvent(String groupTitle, LogEvent event) {
        this.addEvent(groupTitle, event.getID(), event.getClass());
    }

    public void addEvent(String groupTitle, String id, Class<? extends LogEvent> eventClass) {
        this.eventToIDMap.put(eventClass, id);
        this.idToEventMap.put(id, eventClass);
        LogEventWrapper wrapper = new LogEventWrapper();
        wrapper.logEventClass = eventClass;
        wrapper.groupName = groupTitle;
        this.logEventWrappers.add(wrapper);
    }

    public void removeEvent(String id) {
        Class<? extends LogEvent> clazz = this.idToEventMap.remove(id);
        this.eventToIDMap.remove(clazz);
        for (int i = 0; i < this.logEventWrappers.size(); ++i) {
            if (this.logEventWrappers.get((int)i).logEventClass != clazz) continue;
            this.logEventWrappers.remove(i);
            return;
        }
    }

    public String[] getGroupTitles() {
        LinkedHashSet<String> setOfGroupNames = new LinkedHashSet<String>();
        for (LogEventWrapper wrapper : this.logEventWrappers) {
            setOfGroupNames.add(wrapper.groupName);
        }
        return setOfGroupNames.toArray(new String[0]);
    }

    public Class<? extends LogEvent> getEventClass(String eventID) {
        return this.idToEventMap.get(eventID);
    }

    public CommonEmailer getEmailUtil() {
        return this.emailUtil;
    }

    public VariableProcessor getVariableProcessor(Class typeClass) {
        for (int i = 0; i < this.variableProcessors.size(); ++i) {
            VariableProcessor processor = this.variableProcessors.get(i);
            if (processor.whichClassCanProcess() != typeClass) continue;
            return processor;
        }
        return null;
    }

    public void addVariableProcessor(VariableProcessor variableProcessor) {
        this.variableProcessors.add(variableProcessor);
    }

    class LogEventWrapper {
        Class<? extends LogEvent> logEventClass;
        String groupName;

        LogEventWrapper() {
        }
    }
}

