/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import utils.loggingframework.LogEventListener;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.logmapping.LogMapping;
import utils.loggingframework.logmapping.LogMappingRepository;

public class LoggingFramework {
    public static LoggingFramework INSTANCE = new LoggingFramework();
    private LogMappingRepository mappingRepository = new LogMappingRepository();
    private ArrayList<LogEventListener> eventListeners = new ArrayList();
    private LinkedList<LogEvent> eventList = new LinkedList();
    private static final int MAX_EVENT_LIST_SIZE = 2000;
    private EventProcessingThread processingThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEvent(LogEvent event) {
        if (this.processingThread == null) {
            this.processingThread = new EventProcessingThread();
            this.processingThread.start();
        }
        LinkedList<LogEvent> linkedList = this.eventList;
        synchronized (linkedList) {
            if (this.eventList.size() == 2000) {
                System.out.println("[LoggingFramework] Discaring event since maximum number of events have been reached.");
                this.eventList.removeFirst();
            }
            this.eventList.add(event);
            this.eventList.notify();
        }
    }

    public LogMappingRepository getLogMappingRepository() {
        return this.mappingRepository;
    }

    public void addLogEventListener(LogEventListener eventListener) {
        if (!this.eventListeners.contains(eventListener)) {
            this.eventListeners.add(eventListener);
        }
    }

    public void removeLogEventListener(LogEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    class EventProcessingThread
    extends Thread {
        public EventProcessingThread() {
            super("LoggingFramework-EventProcessingThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: while (true) {
                LogEvent event;
                LinkedList linkedList = LoggingFramework.this.eventList;
                synchronized (linkedList) {
                    while (LoggingFramework.this.eventList.size() == 0) {
                        try {
                            LoggingFramework.this.eventList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    event = (LogEvent)LoggingFramework.this.eventList.removeFirst();
                }
                System.out.println("[LoggingFramework] Logging event " + event.getEventType() + " (" + event.getDisplayName() + ")");
                try {
                    Iterator<LogMapping> it = LoggingFramework.this.mappingRepository.mappingsIterator();
                    while (true) {
                        if (!it.hasNext()) continue block9;
                        LogMapping mapping = it.next();
                        if (!mapping.canLogEvent(event)) continue;
                        try {
                            System.out.println("[LoggingFramework] Log mapping '" + mapping.getLogMappingDescription() + "' is processing event");
                            mapping.getTarget().logEvent(event);
                        }
                        catch (Throwable t) {
                            System.out.println("[LoggingFramework] Target '" + mapping.getTarget() + "' failed to log event '" + event + "': " + t.getMessage());
                            t.printStackTrace();
                        }
                    }
                }
                catch (Throwable t) {
                    System.out.println("[LoggingFramework] Severe logging error: " + t.getMessage());
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

