/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import utils.files.ZFilter;

public class ZipUtils {
    public static boolean VERBOSE = false;

    public static boolean isZipFile(File file) {
        try {
            ZipFile zf = new ZipFile(file);
            zf.close();
            return true;
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
    }

    public static void convertToStoredZip(File srcFile, File destZip) throws IOException {
        ZipUtils.repackZip(srcFile, destZip, 0);
    }

    public static void repackZip(File srcFile, File destZip, int newCompressionLevel) throws IOException {
        ZipUtils.repackZip(srcFile, destZip, newCompressionLevel, null);
    }

    public static void repackZip(File srcFile, File destZip, int newCompressionLevel, ZFilter ff) throws IOException {
        byte[] buf = new byte[64000];
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
        out.setLevel(newCompressionLevel);
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(srcFile)));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            boolean accept = true;
            if (ff != null) {
                accept = ff.accept(name);
            }
            if (accept) {
                int len;
                out.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            entry = zin.getNextEntry();
        }
        zin.close();
        out.close();
    }

    public static void mergeZips(File[] srcFile, File destZip, boolean ignoreDups) throws IOException {
        byte[] buf = new byte[64000];
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
        HashMap<String, String> dups = new HashMap<String, String>();
        for (int i = 0; i < srcFile.length; ++i) {
            ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(srcFile[i])));
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (!ignoreDups || !dups.containsKey(name)) {
                    int len;
                    out.putNextEntry(new ZipEntry(name));
                    while ((len = zin.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                dups.put(name, name);
                entry = zin.getNextEntry();
            }
            zin.close();
        }
        out.close();
    }

    public static void addFilesToZipstream(ZipOutputStream out, File file) throws IOException {
        if (!file.getName().equals("CVS")) {
            if (file.isDirectory()) {
                File[] tmp;
                for (File child : tmp = file.listFiles()) {
                    ZipUtils.addFilesToZipstream(out, child);
                }
            } else {
                int len;
                byte[] buf = new byte[64000];
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                out.putNextEntry(new ZipEntry(file.getName()));
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                ((InputStream)in).close();
            }
        }
    }

    public static void addFilesToNewZip(File destZip, File[] files) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
        for (int i = 0; i < files.length; ++i) {
            ZipUtils.addFilesToZipstream(out, files[i]);
        }
        out.close();
    }

    public static void addFilesToExistingZip(File srcFile, File destZip, File[] files) throws IOException {
        byte[] buf = new byte[64000];
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(srcFile)));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            int len;
            String name = entry.getName();
            out.putNextEntry(new ZipEntry(name));
            while ((len = zin.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            entry = zin.getNextEntry();
        }
        zin.close();
        for (int i = 0; i < files.length; ++i) {
            int len;
            if (files[i].getName().equals("CVS")) continue;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(files[i]));
            out.putNextEntry(new ZipEntry(files[i].getName()));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            ((InputStream)in).close();
        }
        out.close();
    }

    public static void extractZip(File zipFile, File destDir) throws IOException {
        ZipUtils.extractJar(zipFile, destDir, false);
    }

    public static void extractJar(File zipFile, File destDir, boolean skipMetaInf) throws IOException {
        if (skipMetaInf) {
            ZipUtils.extractZip(zipFile, destDir, new String[]{"META-INF"});
        } else {
            ZipUtils.extractZip(zipFile, destDir, new String[0]);
        }
    }

    public static void extractZip(File zipFile, File destDir, String[] skips) throws IOException {
        String path = destDir + "";
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        byte[] buf = new byte[50000];
        ZipFile jar = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> en = jar.entries();
        while (en.hasMoreElements()) {
            ZipEntry file = en.nextElement();
            File f = new File(path + file.getName());
            if (VERBOSE) {
                System.out.println("Extracting " + f);
            }
            String ename = file.getName();
            boolean skip = false;
            for (int i = 0; i < skips.length; ++i) {
                if (ename.equals(skips[i])) {
                    skip = true;
                } else if (ename.startsWith(skips[i] + "/")) {
                    skip = true;
                } else if (ename.endsWith("/" + skips[i])) {
                    skip = true;
                } else if (ename.indexOf("/" + skips[i] + "/") != -1) {
                    skip = true;
                }
                if (skip) break;
            }
            if (skip) continue;
            if (file.isDirectory()) {
                f.mkdirs();
                continue;
            }
            BufferedInputStream in = new BufferedInputStream(jar.getInputStream(file));
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            int n = 0;
            while (n != -1) {
                n = ((InputStream)in).read(buf);
                if (n <= 0) continue;
                ((OutputStream)out).write(buf, 0, n);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static void main(String[] args) throws Exception {
        ZipOutputStream zout = ZipUtils.createZip(new File("test.zip"));
        ZipUtils.appendAllToZip(zout, new File("bin"), new File("bin"));
        zout.close();
    }

    public static void zipSingleFile(File orig, boolean andDelete) throws IOException {
        File zip = new File(orig.getParentFile(), orig.getName() + ".zip");
        ZipOutputStream zout = ZipUtils.createZip(zip);
        ZipUtils.appendAllToZip(zout, orig.getParentFile(), orig);
        zout.close();
        if (andDelete) {
            orig.delete();
        }
    }

    public static ZipOutputStream createZip(File f) throws IOException {
        return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
    }

    public static void appendAllToZip(ZipOutputStream zout, File parent, File append) throws IOException {
        ZipUtils.appendAllToZip(zout, parent, append, null);
    }

    public static void appendAllToZip(ZipOutputStream zout, File parent, File append, String[] ignoreList) throws IOException {
        ZipUtils.appendAllToZip(zout, parent.getCanonicalPath(), append, new byte[50000], ignoreList);
    }

    public static void appendAllToZip(ZipOutputStream zout, String ppath, File append, byte[] buf) throws IOException {
        ZipUtils.appendAllToZip(zout, ppath, append, buf, null);
    }

    private static void appendAllToZip(ZipOutputStream zout, String ppath, File append, byte[] buf, String[] ignoreList) throws IOException {
        if (ignoreList != null) {
            for (String ignoreName : ignoreList) {
                if (!ignoreName.equals(append.getName())) continue;
                return;
            }
        }
        if (append.isDirectory()) {
            File[] files = append.listFiles();
            for (int i = 0; i < files.length; ++i) {
                ZipUtils.appendAllToZip(zout, ppath, files[i], buf, ignoreList);
            }
        } else {
            String bigpath = append.getCanonicalPath();
            String cutpath = bigpath.substring(ppath.length()).replace('\\', '/');
            if (cutpath.startsWith("/")) {
                cutpath = cutpath.substring(1);
            }
            System.out.println("[ZipFileUtils] Adding " + cutpath);
            ZipEntry zipEntry = new ZipEntry(cutpath);
            zout.putNextEntry(zipEntry);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(append));
            int n = 0;
            while (n != -1) {
                n = ((InputStream)in).read(buf);
                if (n <= 0) continue;
                zout.write(buf, 0, n);
            }
            zout.closeEntry();
            ((InputStream)in).close();
        }
    }
}

