/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.File;
import utils.files.FileUtil;

public class AtomicSafeDeleter {
    public static boolean deleteIfNotInUse(File folder) {
        if (!folder.exists()) {
            return true;
        }
        File safeToDelete = new File(folder + ".pending_deletion");
        System.out.println("[AtomicSafeDeleter] Renaming folder " + folder + " to " + safeToDelete);
        if (safeToDelete.exists()) {
            System.out.println("[AtomicSafeDeleter] Target exists already, deleting");
            FileUtil.deleteDir(safeToDelete);
            if (safeToDelete.exists()) {
                System.out.println("[AtomicSafeDeleter] Unable to delete target, quitting");
                return false;
            }
        }
        folder.renameTo(safeToDelete);
        if (!folder.exists() && safeToDelete.exists()) {
            System.out.println("[AtomicSafeDeleter] Deleting (" + folder.getName() + ") now...");
            FileUtil.deleteDir(safeToDelete);
            return true;
        }
        System.out.println("[AtomicSafeDeleter] Unable to move source (" + folder.getName() + ") for deletion");
        return false;
    }
}

