/*
 * Decompiled with CFR 0.152.
 */
package utils.encryption.aes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class Rijndael {
    private static final boolean DEBUG = false;
    private static final Random random = new Random();
    public static final int DIR_ENCRYPT = 1;
    public static final int DIR_DECRYPT = 2;
    public static final int DIR_BOTH = 3;
    public static final int BLOCK_BITS = 128;
    public static final int BLOCK_SIZE = 16;
    private static final String SS = "\u637c\u777b\uf26b\u6fc5\u3001\u672b\ufed7\uab76\uca82\uc97d\ufa59\u47f0\uadd4\ua2af\u9ca4\u72c0\ub7fd\u9326\u363f\uf7cc\u34a5\ue5f1\u71d8\u3115\u04c7\u23c3\u1896\u059a\u0712\u80e2\ueb27\ub275\u0983\u2c1a\u1b6e\u5aa0\u523b\ud6b3\u29e3\u2f84\u53d1\u00ed\u20fc\ub15b\u6acb\ube39\u4a4c\u58cf\ud0ef\uaafb\u434d\u3385\u45f9\u027f\u503c\u9fa8\u51a3\u408f\u929d\u38f5\ubcb6\uda21\u10ff\uf3d2\ucd0c\u13ec\u5f97\u4417\uc4a7\u7e3d\u645d\u1973\u6081\u4fdc\u222a\u9088\u46ee\ub814\ude5e\u0bdb\ue032\u3a0a\u4906\u245c\uc2d3\uac62\u9195\ue479\ue7c8\u376d\u8dd5\u4ea9\u6c56\uf4ea\u657a\uae08\uba78\u252e\u1ca6\ub4c6\ue8dd\u741f\u4bbd\u8b8a\u703e\ub566\u4803\uf60e\u6135\u57b9\u86c1\u1d9e\ue1f8\u9811\u69d9\u8e94\u9b1e\u87e9\uce55\u28df\u8ca1\u890d\ubfe6\u4268\u4199\u2d0f\ub054\ubb16";
    private static final byte[] Se = new byte[256];
    private static final int[] Te0 = new int[256];
    private static final int[] Te1 = new int[256];
    private static final int[] Te2 = new int[256];
    private static final int[] Te3 = new int[256];
    private static final byte[] Sd = new byte[256];
    private static final int[] Td0 = new int[256];
    private static final int[] Td1 = new int[256];
    private static final int[] Td2 = new int[256];
    private static final int[] Td3 = new int[256];
    private static final int[] rcon = new int[10];
    private int Nr = 0;
    private int Nk = 0;
    private int Nw = 0;
    private int[] rek = null;
    private int[] rdk = null;
    byte[] iv;
    byte[] enc = new byte[16];
    private static final int DIGEST_LENGTH = 32;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;
    private int H8;
    private int[] X = new int[64];
    private int xOff;
    private byte[] xBuf;
    private int xBufOff;
    private long byteCount;
    static final int[] K;

    public static void main(String[] args) throws Exception {
        int i;
        Rijndael tf = new Rijndael();
        tf.init("one$%^&*()$%^&*(sadsfahjkfhafhbkjfahkafgjvbkgwyu4g2yugkyugo81g234ogfyudsakvhckjg");
        byte[] dat = new byte[1000000];
        new Random().nextBytes(dat);
        byte[] enc = tf.encryptCTR(dat, 0, dat.length);
        byte[] dec = tf.decryptCTR(enc, 0);
        for (i = 0; i < dat.length; ++i) {
            if (dat[i] == dec[i]) continue;
            System.out.println("ENCRYPTION FAILED AT " + i);
            return;
        }
        System.out.println("ENCRYPTION OK");
        System.out.println();
        tf = new Rijndael();
        tf.init("one");
        dat = new byte[33];
        for (int i2 = 0; i2 < dat.length; ++i2) {
            System.out.print(dat[i2] + "\t");
            if ((i2 + 1) % 4 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println();
        byte[] encrypted = tf.encryptCTR(dat, 0, dat.length);
        for (int i3 = 0; i3 < encrypted.length; ++i3) {
            System.out.print(encrypted[i3] + "\t");
            if ((i3 + 1) % 4 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println();
        tf.init("one");
        byte[] decrypted = tf.decryptCTR(encrypted, 0);
        for (i = 0; i < decrypted.length; ++i) {
            System.out.print(decrypted[i] + "\t");
            if ((i + 1) % 4 != 0) continue;
            System.out.println();
        }
    }

    private void expandKey(byte[] cipherKey) {
        int temp;
        int r = 0;
        int i = 0;
        int k = 0;
        while (i < this.Nk) {
            this.rek[i] = cipherKey[k] << 24 | (cipherKey[k + 1] & 0xFF) << 16 | (cipherKey[k + 2] & 0xFF) << 8 | cipherKey[k + 3] & 0xFF;
            ++i;
            k += 4;
        }
        i = this.Nk;
        int n = 0;
        while (i < this.Nw) {
            temp = this.rek[i - 1];
            if (n == 0) {
                n = this.Nk;
                temp = Se[temp >>> 16 & 0xFF] << 24 | (Se[temp >>> 8 & 0xFF] & 0xFF) << 16 | (Se[temp & 0xFF] & 0xFF) << 8 | Se[temp >>> 24] & 0xFF;
                temp ^= rcon[r++];
            } else if (this.Nk == 8 && n == 4) {
                temp = Se[temp >>> 24] << 24 | (Se[temp >>> 16 & 0xFF] & 0xFF) << 16 | (Se[temp >>> 8 & 0xFF] & 0xFF) << 8 | Se[temp & 0xFF] & 0xFF;
            }
            this.rek[i] = this.rek[i - this.Nk] ^ temp;
            ++i;
            --n;
        }
        temp = 0;
    }

    private void invertKey() {
        int d = 0;
        int e = 4 * this.Nr;
        this.rdk[d] = this.rek[e];
        this.rdk[d + 1] = this.rek[e + 1];
        this.rdk[d + 2] = this.rek[e + 2];
        this.rdk[d + 3] = this.rek[e + 3];
        d += 4;
        e -= 4;
        for (int r = 1; r < this.Nr; ++r) {
            int w = this.rek[e];
            this.rdk[d] = Td0[Se[w >>> 24] & 0xFF] ^ Td1[Se[w >>> 16 & 0xFF] & 0xFF] ^ Td2[Se[w >>> 8 & 0xFF] & 0xFF] ^ Td3[Se[w & 0xFF] & 0xFF];
            w = this.rek[e + 1];
            this.rdk[d + 1] = Td0[Se[w >>> 24] & 0xFF] ^ Td1[Se[w >>> 16 & 0xFF] & 0xFF] ^ Td2[Se[w >>> 8 & 0xFF] & 0xFF] ^ Td3[Se[w & 0xFF] & 0xFF];
            w = this.rek[e + 2];
            this.rdk[d + 2] = Td0[Se[w >>> 24] & 0xFF] ^ Td1[Se[w >>> 16 & 0xFF] & 0xFF] ^ Td2[Se[w >>> 8 & 0xFF] & 0xFF] ^ Td3[Se[w & 0xFF] & 0xFF];
            w = this.rek[e + 3];
            this.rdk[d + 3] = Td0[Se[w >>> 24] & 0xFF] ^ Td1[Se[w >>> 16 & 0xFF] & 0xFF] ^ Td2[Se[w >>> 8 & 0xFF] & 0xFF] ^ Td3[Se[w & 0xFF] & 0xFF];
            d += 4;
            e -= 4;
        }
        this.rdk[d] = this.rek[e];
        this.rdk[d + 1] = this.rek[e + 1];
        this.rdk[d + 2] = this.rek[e + 2];
        this.rdk[d + 3] = this.rek[e + 3];
    }

    public void makeKey(byte[] cipherKey, int keyBits, int direction) throws RuntimeException {
        if (keyBits != 128 && keyBits != 192 && keyBits != 256) {
            throw new RuntimeException("Invalid AES key size (" + keyBits + " bits)");
        }
        this.Nk = keyBits >>> 5;
        this.Nr = 10;
        this.Nw = 4 * (this.Nr + 1);
        this.rek = new int[this.Nw];
        this.rdk = new int[this.Nw];
        if ((direction & 3) != 0) {
            this.expandKey(cipherKey);
            if ((direction & 2) != 0) {
                this.invertKey();
            }
        }
    }

    public void makeKey(byte[] cipherKey, int keyBits) throws RuntimeException {
        this.makeKey(cipherKey, keyBits, 3);
    }

    public void encrypt(byte[] pt, byte[] ct) {
        int k = 0;
        int t0 = (pt[0] << 24 | (pt[1] & 0xFF) << 16 | (pt[2] & 0xFF) << 8 | pt[3] & 0xFF) ^ this.rek[0];
        int t1 = (pt[4] << 24 | (pt[5] & 0xFF) << 16 | (pt[6] & 0xFF) << 8 | pt[7] & 0xFF) ^ this.rek[1];
        int t2 = (pt[8] << 24 | (pt[9] & 0xFF) << 16 | (pt[10] & 0xFF) << 8 | pt[11] & 0xFF) ^ this.rek[2];
        int t3 = (pt[12] << 24 | (pt[13] & 0xFF) << 16 | (pt[14] & 0xFF) << 8 | pt[15] & 0xFF) ^ this.rek[3];
        for (int r = 1; r < this.Nr; ++r) {
            int a0 = Te0[t0 >>> 24] ^ Te1[t1 >>> 16 & 0xFF] ^ Te2[t2 >>> 8 & 0xFF] ^ Te3[t3 & 0xFF] ^ this.rek[k += 4];
            int a1 = Te0[t1 >>> 24] ^ Te1[t2 >>> 16 & 0xFF] ^ Te2[t3 >>> 8 & 0xFF] ^ Te3[t0 & 0xFF] ^ this.rek[k + 1];
            int a2 = Te0[t2 >>> 24] ^ Te1[t3 >>> 16 & 0xFF] ^ Te2[t0 >>> 8 & 0xFF] ^ Te3[t1 & 0xFF] ^ this.rek[k + 2];
            int a3 = Te0[t3 >>> 24] ^ Te1[t0 >>> 16 & 0xFF] ^ Te2[t1 >>> 8 & 0xFF] ^ Te3[t2 & 0xFF] ^ this.rek[k + 3];
            t0 = a0;
            t1 = a1;
            t2 = a2;
            t3 = a3;
        }
        int v = this.rek[k += 4];
        ct[0] = (byte)(Se[t0 >>> 24] ^ v >>> 24);
        ct[1] = (byte)(Se[t1 >>> 16 & 0xFF] ^ v >>> 16);
        ct[2] = (byte)(Se[t2 >>> 8 & 0xFF] ^ v >>> 8);
        ct[3] = (byte)(Se[t3 & 0xFF] ^ v);
        v = this.rek[k + 1];
        ct[4] = (byte)(Se[t1 >>> 24] ^ v >>> 24);
        ct[5] = (byte)(Se[t2 >>> 16 & 0xFF] ^ v >>> 16);
        ct[6] = (byte)(Se[t3 >>> 8 & 0xFF] ^ v >>> 8);
        ct[7] = (byte)(Se[t0 & 0xFF] ^ v);
        v = this.rek[k + 2];
        ct[8] = (byte)(Se[t2 >>> 24] ^ v >>> 24);
        ct[9] = (byte)(Se[t3 >>> 16 & 0xFF] ^ v >>> 16);
        ct[10] = (byte)(Se[t0 >>> 8 & 0xFF] ^ v >>> 8);
        ct[11] = (byte)(Se[t1 & 0xFF] ^ v);
        v = this.rek[k + 3];
        ct[12] = (byte)(Se[t3 >>> 24] ^ v >>> 24);
        ct[13] = (byte)(Se[t0 >>> 16 & 0xFF] ^ v >>> 16);
        ct[14] = (byte)(Se[t1 >>> 8 & 0xFF] ^ v >>> 8);
        ct[15] = (byte)(Se[t2 & 0xFF] ^ v);
    }

    public void decrypt(byte[] ct, byte[] pt) {
        int k = 0;
        int t0 = (ct[0] << 24 | (ct[1] & 0xFF) << 16 | (ct[2] & 0xFF) << 8 | ct[3] & 0xFF) ^ this.rdk[0];
        int t1 = (ct[4] << 24 | (ct[5] & 0xFF) << 16 | (ct[6] & 0xFF) << 8 | ct[7] & 0xFF) ^ this.rdk[1];
        int t2 = (ct[8] << 24 | (ct[9] & 0xFF) << 16 | (ct[10] & 0xFF) << 8 | ct[11] & 0xFF) ^ this.rdk[2];
        int t3 = (ct[12] << 24 | (ct[13] & 0xFF) << 16 | (ct[14] & 0xFF) << 8 | ct[15] & 0xFF) ^ this.rdk[3];
        for (int r = 1; r < this.Nr; ++r) {
            int a0 = Td0[t0 >>> 24] ^ Td1[t3 >>> 16 & 0xFF] ^ Td2[t2 >>> 8 & 0xFF] ^ Td3[t1 & 0xFF] ^ this.rdk[k += 4];
            int a1 = Td0[t1 >>> 24] ^ Td1[t0 >>> 16 & 0xFF] ^ Td2[t3 >>> 8 & 0xFF] ^ Td3[t2 & 0xFF] ^ this.rdk[k + 1];
            int a2 = Td0[t2 >>> 24] ^ Td1[t1 >>> 16 & 0xFF] ^ Td2[t0 >>> 8 & 0xFF] ^ Td3[t3 & 0xFF] ^ this.rdk[k + 2];
            int a3 = Td0[t3 >>> 24] ^ Td1[t2 >>> 16 & 0xFF] ^ Td2[t1 >>> 8 & 0xFF] ^ Td3[t0 & 0xFF] ^ this.rdk[k + 3];
            t0 = a0;
            t1 = a1;
            t2 = a2;
            t3 = a3;
        }
        int v = this.rdk[k += 4];
        pt[0] = (byte)(Sd[t0 >>> 24] ^ v >>> 24);
        pt[1] = (byte)(Sd[t3 >>> 16 & 0xFF] ^ v >>> 16);
        pt[2] = (byte)(Sd[t2 >>> 8 & 0xFF] ^ v >>> 8);
        pt[3] = (byte)(Sd[t1 & 0xFF] ^ v);
        v = this.rdk[k + 1];
        pt[4] = (byte)(Sd[t1 >>> 24] ^ v >>> 24);
        pt[5] = (byte)(Sd[t0 >>> 16 & 0xFF] ^ v >>> 16);
        pt[6] = (byte)(Sd[t3 >>> 8 & 0xFF] ^ v >>> 8);
        pt[7] = (byte)(Sd[t2 & 0xFF] ^ v);
        v = this.rdk[k + 2];
        pt[8] = (byte)(Sd[t2 >>> 24] ^ v >>> 24);
        pt[9] = (byte)(Sd[t1 >>> 16 & 0xFF] ^ v >>> 16);
        pt[10] = (byte)(Sd[t0 >>> 8 & 0xFF] ^ v >>> 8);
        pt[11] = (byte)(Sd[t3 & 0xFF] ^ v);
        v = this.rdk[k + 3];
        pt[12] = (byte)(Sd[t3 >>> 24] ^ v >>> 24);
        pt[13] = (byte)(Sd[t2 >>> 16 & 0xFF] ^ v >>> 16);
        pt[14] = (byte)(Sd[t1 >>> 8 & 0xFF] ^ v >>> 8);
        pt[15] = (byte)(Sd[t0 & 0xFF] ^ v);
    }

    public final void finalize() {
        int i;
        if (this.rek != null) {
            for (i = 0; i < this.rek.length; ++i) {
                this.rek[i] = 0;
            }
            this.rek = null;
        }
        if (this.rdk != null) {
            for (i = 0; i < this.rdk.length; ++i) {
                this.rdk[i] = 0;
            }
            this.rdk = null;
        }
    }

    public void init(String key) {
        try {
            this.init(key.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.init(key.getBytes());
        }
    }

    public void init(boolean ignored, byte[] key) {
        this.init(key);
    }

    public void init(byte[] key) {
        int i;
        byte[] keypop = new byte[32];
        for (i = 0; i < keypop.length; ++i) {
            keypop[i] = key[i % key.length];
        }
        for (i = keypop.length; i < key.length; ++i) {
            keypop[i % keypop.length] = (byte)(keypop[i % keypop.length] ^ key[i]);
        }
        this.makeKey(keypop, 256);
        this.iv = new byte[16];
        random.nextBytes(this.iv);
    }

    public final void writeInt(OutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public final void writeByte(OutputStream out, int v) throws IOException {
        out.write(v);
    }

    public final int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public final byte readByte(InputStream in) throws IOException {
        int ch = in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public byte[] encryptCTR(byte[] orig, int off, int len) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.writeInt(bout, len);
            for (int i = 0; i < this.iv.length; ++i) {
                this.writeByte(bout, this.iv[i]);
            }
            byte[] digest = new byte[32];
            this.SHA_reset();
            this.SHA_genupdate(orig, off, Math.min(64, len));
            if (len > 64) {
                this.SHA_genupdate(orig, off + len - 64, 64);
            }
            this.SHA_doFinal(digest, 0);
            byte[] tmp = new byte[32];
            this.processCtr(digest, 0, 32, tmp, 0, true);
            bout.write(tmp);
            tmp = new byte[orig.length + 32];
            this.processCtr(orig, off, len, tmp, 0, true);
            bout.write(tmp);
        }
        catch (IOException x) {
            throw new IllegalStateException("Unable to write to encrypted data");
        }
        return bout.toByteArray();
    }

    public byte[] decryptCTR(byte[] orig, int off) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(orig, off, orig.length - off);
        Object badness = null;
        try {
            int len = this.readInt(bin);
            for (int i = 0; i < this.iv.length; ++i) {
                this.iv[i] = this.readByte(bin);
            }
            byte[] digest = new byte[32];
            this.processCtr(orig, orig.length - bin.available(), 32, digest, 0, false);
            byte[] decr = new byte[len];
            long T = System.currentTimeMillis();
            this.processCtr(orig, orig.length - bin.available() + 32, len, decr, 0, false);
            T = System.currentTimeMillis() - T;
            byte[] mydigest = new byte[32];
            this.SHA_reset();
            this.SHA_genupdate(decr, 0, Math.min(64, decr.length));
            if (len > 64) {
                this.SHA_genupdate(decr, len - 64, 64);
            }
            this.SHA_doFinal(mydigest, 0);
            for (int i = 0; i < digest.length; ++i) {
                if (digest[i] == mydigest[i]) continue;
                throw new IOException("Encrypted data integrity check failed");
            }
            return decr;
        }
        catch (IOException x) {
            if (x.getMessage() != null && x.getMessage().equals("Encrypted data integrity check failed")) {
                throw x;
            }
            throw new IOException("Unable to write to read encrypted data (" + x + ")");
        }
    }

    private static void writeLong(byte[] dat, int offset, long n) {
        dat[offset] = (byte)(n >>> 56);
        dat[offset + 1] = (byte)(n >>> 48);
        dat[offset + 2] = (byte)(n >>> 40);
        dat[offset + 3] = (byte)(n >>> 32);
        dat[offset + 4] = (byte)(n >>> 24);
        dat[offset + 5] = (byte)(n >>> 16);
        dat[offset + 6] = (byte)(n >>> 8);
        dat[offset + 7] = (byte)n;
    }

    private static long readLong(byte[] dat, int offset) {
        long n = 0L;
        for (int i = 0; i < 8; ++i) {
            n = n << 8 | 0xFFL & (long)dat[offset + i];
        }
        return n;
    }

    private void processCtr(byte[] orig, int off, int len, byte[] target, int toff, boolean encrypt) {
        for (int i = 0; i < len; i += 16) {
            int iplus = off + i;
            int tplus = toff + i;
            if (encrypt) {
                int k2;
                try {
                    for (k2 = 0; k2 < 16; ++k2) {
                        this.enc[k2] = (byte)(orig[iplus + k2] ^ this.iv[k2]);
                    }
                }
                catch (ArrayIndexOutOfBoundsException k2) {
                    // empty catch block
                }
                this.encrypt(this.enc, this.enc);
                try {
                    for (k2 = 0; k2 < 16; ++k2) {
                        target[tplus + k2] = this.enc[k2];
                    }
                }
                catch (ArrayIndexOutOfBoundsException k3) {
                    // empty catch block
                }
                try {
                    for (int k4 = 0; k4 < 16; ++k4) {
                        this.iv[k4] = (byte)(orig[iplus + k4] ^ this.enc[k4]);
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException k4) {
                    continue;
                }
            }
            try {
                for (int k = 0; k < 16; ++k) {
                    this.enc[k] = orig[iplus + k];
                }
            }
            catch (ArrayIndexOutOfBoundsException k) {
                // empty catch block
            }
            this.decrypt(this.enc, this.enc);
            try {
                for (int k = 0; k < 16; ++k) {
                    target[tplus + k] = (byte)(this.enc[k] ^ this.iv[k]);
                }
            }
            catch (ArrayIndexOutOfBoundsException k) {
                // empty catch block
            }
            try {
                for (int k = 0; k < 16; ++k) {
                    this.iv[k] = (byte)(orig[iplus + k] ^ target[tplus + k]);
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public String SHA_getAlgorithmName() {
        return "SHA-256";
    }

    public int SHA_getDigestSize() {
        return 32;
    }

    protected void SHA_processWord(byte[] in, int inOff) {
        int n = in[inOff] << 24;
        n |= (in[++inOff] & 0xFF) << 16;
        n |= (in[++inOff] & 0xFF) << 8;
        this.X[this.xOff] = n |= in[++inOff] & 0xFF;
        if (++this.xOff == 16) {
            this.SHA_processBlock();
        }
    }

    protected void SHA_processLength(long bitLength) {
        if (this.xOff > 14) {
            this.SHA_processBlock();
        }
        this.X[14] = (int)(bitLength >>> 32);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
    }

    public static void SHA_intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public int SHA_doFinal(byte[] out, int outOff) {
        this.SHA_genfinish();
        Rijndael.SHA_intToBigEndian(this.H1, out, outOff);
        Rijndael.SHA_intToBigEndian(this.H2, out, outOff + 4);
        Rijndael.SHA_intToBigEndian(this.H3, out, outOff + 8);
        Rijndael.SHA_intToBigEndian(this.H4, out, outOff + 12);
        Rijndael.SHA_intToBigEndian(this.H5, out, outOff + 16);
        Rijndael.SHA_intToBigEndian(this.H6, out, outOff + 20);
        Rijndael.SHA_intToBigEndian(this.H7, out, outOff + 24);
        Rijndael.SHA_intToBigEndian(this.H8, out, outOff + 28);
        this.SHA_reset();
        return 32;
    }

    public void SHA_genreset() {
        this.byteCount = 0L;
        this.xBuf = new byte[4];
        this.xBufOff = 0;
    }

    public void SHA_genfinish() {
        long bitLength = this.byteCount << 3;
        this.SHA_genupdate((byte)-128);
        while (this.xBufOff != 0) {
            this.SHA_genupdate((byte)0);
        }
        this.SHA_processLength(bitLength);
        this.SHA_processBlock();
    }

    public void SHA_genupdate(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == this.xBuf.length) {
            this.SHA_processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    public void SHA_genupdate(byte[] in, int inOff, int len) {
        while (this.xBufOff != 0 && len > 0) {
            this.SHA_genupdate(in[inOff]);
            ++inOff;
            --len;
        }
        while (len > this.xBuf.length) {
            this.SHA_processWord(in, inOff);
            inOff += this.xBuf.length;
            len -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (len > 0) {
            this.SHA_genupdate(in[inOff]);
            ++inOff;
            --len;
        }
    }

    public void SHA_reset() {
        this.SHA_genreset();
        this.H1 = 1779033703;
        this.H2 = -1150833019;
        this.H3 = 1013904242;
        this.H4 = -1521486534;
        this.H5 = 1359893119;
        this.H6 = -1694144372;
        this.H7 = 528734635;
        this.H8 = 1541459225;
        this.xOff = 0;
        for (int i = 0; i != this.X.length; ++i) {
            this.X[i] = 0;
        }
    }

    protected void SHA_processBlock() {
        int i;
        for (int t = 16; t <= 63; ++t) {
            this.X[t] = this.Theta1(this.X[t - 2]) + this.X[t - 7] + this.Theta0(this.X[t - 15]) + this.X[t - 16];
        }
        int a = this.H1;
        int b = this.H2;
        int c = this.H3;
        int d = this.H4;
        int e = this.H5;
        int f = this.H6;
        int g = this.H7;
        int h = this.H8;
        int t = 0;
        for (i = 0; i < 8; ++i) {
            d += (h += this.Sum1(e) + this.Ch(e, f, g) + K[t] + this.X[t]);
            h += this.Sum0(a) + this.Maj(a, b, c);
            c += (g += this.Sum1(d) + this.Ch(d, e, f) + K[++t] + this.X[t]);
            g += this.Sum0(h) + this.Maj(h, a, b);
            b += (f += this.Sum1(c) + this.Ch(c, d, e) + K[++t] + this.X[t]);
            f += this.Sum0(g) + this.Maj(g, h, a);
            a += (e += this.Sum1(b) + this.Ch(b, c, d) + K[++t] + this.X[t]);
            e += this.Sum0(f) + this.Maj(f, g, h);
            h += (d += this.Sum1(a) + this.Ch(a, b, c) + K[++t] + this.X[t]);
            d += this.Sum0(e) + this.Maj(e, f, g);
            g += (c += this.Sum1(h) + this.Ch(h, a, b) + K[++t] + this.X[t]);
            c += this.Sum0(d) + this.Maj(d, e, f);
            f += (b += this.Sum1(g) + this.Ch(g, h, a) + K[++t] + this.X[t]);
            b += this.Sum0(c) + this.Maj(c, d, e);
            e += (a += this.Sum1(f) + this.Ch(f, g, h) + K[++t] + this.X[t]);
            a += this.Sum0(b) + this.Maj(b, c, d);
            ++t;
        }
        this.H1 += a;
        this.H2 += b;
        this.H3 += c;
        this.H4 += d;
        this.H5 += e;
        this.H6 += f;
        this.H7 += g;
        this.H8 += h;
        this.xOff = 0;
        for (i = 0; i < 16; ++i) {
            this.X[i] = 0;
        }
    }

    private int Ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private int Maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private int Sum0(int x) {
        return (x >>> 2 | x << 30) ^ (x >>> 13 | x << 19) ^ (x >>> 22 | x << 10);
    }

    private int Sum1(int x) {
        return (x >>> 6 | x << 26) ^ (x >>> 11 | x << 21) ^ (x >>> 25 | x << 7);
    }

    private int Theta0(int x) {
        return (x >>> 7 | x << 25) ^ (x >>> 18 | x << 14) ^ x >>> 3;
    }

    private int Theta1(int x) {
        return (x >>> 17 | x << 15) ^ (x >>> 19 | x << 13) ^ x >>> 10;
    }

    static {
        int ROOT = 283;
        for (int i1 = 0; i1 < 256; ++i1) {
            int t;
            int i8;
            int i4;
            int c = SS.charAt(i1 >>> 1);
            int s1 = (byte)((i1 & 1) == 0 ? c >>> 8 : c) & 0xFF;
            int s2 = s1 << 1;
            if (s2 >= 256) {
                s2 ^= ROOT;
            }
            int s3 = s2 ^ s1;
            int i2 = i1 << 1;
            if (i2 >= 256) {
                i2 ^= ROOT;
            }
            if ((i4 = i2 << 1) >= 256) {
                i4 ^= ROOT;
            }
            if ((i8 = i4 << 1) >= 256) {
                i8 ^= ROOT;
            }
            int i9 = i8 ^ i1;
            int ib = i9 ^ i2;
            int id = i9 ^ i4;
            int ie = i8 ^ i4 ^ i2;
            Rijndael.Se[i1] = (byte)s1;
            Rijndael.Te0[i1] = t = s2 << 24 | s1 << 16 | s1 << 8 | s3;
            Rijndael.Te1[i1] = t >>> 8 | t << 24;
            Rijndael.Te2[i1] = t >>> 16 | t << 16;
            Rijndael.Te3[i1] = t >>> 24 | t << 8;
            Rijndael.Sd[s1] = (byte)i1;
            Rijndael.Td0[s1] = t = ie << 24 | i9 << 16 | id << 8 | ib;
            Rijndael.Td1[s1] = t >>> 8 | t << 24;
            Rijndael.Td2[s1] = t >>> 16 | t << 16;
            Rijndael.Td3[s1] = t >>> 24 | t << 8;
        }
        int r = 1;
        Rijndael.rcon[0] = r << 24;
        for (int i = 1; i < 10; ++i) {
            if ((r <<= 1) >= 256) {
                r ^= ROOT;
            }
            Rijndael.rcon[i] = r << 24;
        }
        K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    }
}

