/*
 * Decompiled with CFR 0.152.
 */
package utils.encryption;

import bcutil.BCUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import utils.stream.StreamUtils;

public class OptionalEncrypt {
    private static long OE_MAGIC_1 = 1236578216721392197L;
    private static long OE_MAGIC_2 = 982888676519231742L;
    private static long OE_MAGIC_3 = 1932245523849864455L;
    private static long OE_MAGIC_4 = 1182364462377777753L;

    public static byte[] encrypt(byte[] data, String secret) throws IOException {
        String salt = BCUtil.generateBase64Salt(64);
        byte[] encrypted = BCUtil.encryptWithSecret(data, salt, secret, 200);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamUtils.writeLong(bout, OE_MAGIC_1);
        StreamUtils.writeLong(bout, OE_MAGIC_2);
        StreamUtils.writeLong(bout, OE_MAGIC_3);
        StreamUtils.writeLong(bout, OE_MAGIC_4);
        StreamUtils.writeStringUTF8(bout, salt);
        StreamUtils.writeBytes(bout, encrypted);
        return bout.toByteArray();
    }

    public static byte[] decryptIfEncrypted(byte[] data, String secret) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        try {
            if (StreamUtils.readLong(bin) != OE_MAGIC_1) {
                return data;
            }
            if (StreamUtils.readLong(bin) != OE_MAGIC_2) {
                return data;
            }
            if (StreamUtils.readLong(bin) != OE_MAGIC_3) {
                return data;
            }
            if (StreamUtils.readLong(bin) != OE_MAGIC_4) {
                return data;
            }
        }
        catch (IOException x) {
            return data;
        }
        String salt = StreamUtils.readNStringUTF8(bin, 512);
        byte[] encrypted = StreamUtils.readNBytes(bin, 500000000);
        return BCUtil.decryptWithSecret(encrypted, salt, secret, 200);
    }

    public static void main(String[] args) throws Exception {
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            byte[] dat = new byte[250000];
            r.nextBytes(dat);
            boolean encrypt = r.nextBoolean();
            byte[] stored = encrypt ? OptionalEncrypt.encrypt(dat, "Moonpig") : dat;
            byte[] loaded = OptionalEncrypt.decryptIfEncrypted(stored, "Moonpig");
            if (Arrays.equals(dat, loaded)) continue;
            throw new Exception("NO MATCHY! (encrypted=" + encrypt + ")");
        }
    }
}

