/*
 * Decompiled with CFR 0.152.
 */
package utils.email;

import java.io.File;
import java.util.Date;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import utils.email.CommonEmailer;

public class HtmlEmailer
extends CommonEmailer {
    public HtmlEmailer(CommonEmailer.Settings provider, String user, String pass, String from, String encoding) {
        super(provider, user, pass, from, encoding);
    }

    private static boolean isHTML(String content) {
        return content != null && content.trim().substring(0, 5).toUpperCase().startsWith("<HTML");
    }

    @Override
    public void send(String subject, String content) throws Exception {
        if (HtmlEmailer.isHTML(content)) {
            this.send(new String[]{this.std_from}, subject, content, MIME_HTML, null);
        } else {
            this.send(new String[]{this.std_from}, subject, content, MIME_PLAIN_TEXT, null);
        }
    }

    @Override
    public void send(String[] to, String subject, String content) throws Exception {
        if (HtmlEmailer.isHTML(content)) {
            this.send(to, subject, content, MIME_HTML, null);
        } else {
            this.send(to, subject, content, MIME_PLAIN_TEXT, null);
        }
    }

    public void sendHtmlAndPlainTextEmail(String[] to, String subject, String plaintTextContent, String htmlContent, String[] replyTo, String overrideFrom, File[] attachedFiles) throws Exception {
        MimeMessage msg = this.initMimeMessage(to, subject, replyTo, overrideFrom);
        MimeMultipart allContent = new MimeMultipart("mixed");
        MimeMultipart bodyContent = new MimeMultipart("alternative");
        MimeBodyPart bodyPart = new MimeBodyPart();
        if (this.encoding == null || this.encoding.equals("ASCII")) {
            bodyPart.setContent((Object)plaintTextContent, "text/plain");
        } else {
            bodyPart.setContent((Object)plaintTextContent, "text/plain;charset=" + this.encoding);
        }
        bodyContent.addBodyPart((BodyPart)bodyPart);
        bodyPart = new MimeBodyPart();
        if (this.encoding == null || this.encoding.equals("ASCII")) {
            bodyPart.setContent((Object)htmlContent, "text/html");
        } else {
            bodyPart.setContent((Object)htmlContent, "text/html;charset=" + this.encoding);
        }
        bodyContent.addBodyPart((BodyPart)bodyPart);
        MimeBodyPart bodyContentWrapper = new MimeBodyPart();
        bodyContentWrapper.setContent((Multipart)bodyContent);
        allContent.addBodyPart((BodyPart)bodyContentWrapper);
        if (attachedFiles != null) {
            for (int i = 0; i < attachedFiles.length; ++i) {
                MimeBodyPart attachmentBody = new MimeBodyPart();
                attachmentBody.attachFile(attachedFiles[i]);
                allContent.addBodyPart((BodyPart)attachmentBody);
            }
        }
        msg.setContent((Multipart)allContent);
        msg.setSentDate(new Date());
        try {
            Transport.send((Message)msg);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t.getMessage(), t.getCause());
        }
    }
}

