/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.local.datalist;

import java.io.File;
import java.io.IOException;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.gziplist.util.TypeCoverter;
import utils.dataservice.local.datalist.ByteList;
import utils.dataservice.local.datalist.TimedList;

public class DoubleList
extends TimedList {
    public DoubleList(File file) throws IOException {
        super(file, DoubleList.getAggregators());
    }

    public DoubleList(File file, ChunkHeader header) throws IOException {
        super(file, DoubleList.getAggregators(), header);
    }

    public static byte[] getAggregators() {
        byte[] validAggregators = new byte[]{0, 1, 2, 3, 4};
        return validAggregators;
    }

    @Override
    public Class getDataClass() {
        return Double.class;
    }

    @Override
    public void initializeByteContainer() {
        this.byteContainer = new byte[16];
    }

    @Override
    public int writeEventData(Object object) throws Exception {
        Double d = (Double)object;
        TypeCoverter.doubleToByte(d, this.byteContainer, 8);
        return this.byteContainer.length;
    }

    @Override
    public Object parseEventValue(byte[] bytes) {
        return new Double(TypeCoverter.byteToDouble(bytes, 8));
    }

    public Double getDoubleValue(long index) {
        return (Double)this.getValue(index);
    }

    public void addDouble(double timestamp, Double doubleValue) {
        this.add(timestamp, doubleValue);
    }

    public static void main(String[] args) throws IOException {
        File temp = File.createTempFile("woot", "toot");
        System.out.println(temp.getAbsolutePath());
        byte[] data = new byte[30];
        for (int i = 0; i < data.length; ++i) {
            data[i] = -86;
        }
        ChunkHeader header = new ChunkHeader(data.length);
        header.setHeaderData(data);
        DoubleList list = new DoubleList(temp, header);
        long count = 86400L;
        for (long i = 0L; i < count; ++i) {
            list.addDouble(i, new Double(i % 100L));
        }
        list.close();
        System.out.println("[Double] " + count + " entries. " + temp.length() + " bytes. " + temp.length() / 1024L / 1024L + " MB.");
        temp.delete();
        temp = File.createTempFile("woot", "toot");
        System.out.println(temp.getAbsolutePath());
        header = new ChunkHeader(data.length);
        header.setHeaderData(data);
        ByteList list2 = new ByteList(temp, header);
        for (long i = 0L; i < count; ++i) {
            list2.addByte(i, new Byte((byte)(i % 100L)));
        }
        list2.close();
        System.out.println("[Byte] " + count + " entries. " + temp.length() + " bytes. " + temp.length() / 1024L / 1024L + " MB.");
    }
}

