/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.local.datalist;

import java.io.File;
import java.io.IOException;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.local.datalist.TimedList;

public class ByteList
extends TimedList {
    public ByteList(File file) throws IOException {
        super(file, ByteList.getAggregators());
    }

    public ByteList(File file, ChunkHeader header) throws IOException {
        super(file, ByteList.getAggregators(), header);
    }

    public static byte[] getAggregators() {
        byte[] validAggregators = new byte[]{0, 1, 2, 3, 4};
        return validAggregators;
    }

    @Override
    public Class getDataClass() {
        return Byte.class;
    }

    @Override
    public void initializeByteContainer() {
        this.byteContainer = new byte[9];
    }

    @Override
    public int writeEventData(Object object) throws Exception {
        Byte d = (Byte)object;
        this.byteContainer[8] = d;
        return this.byteContainer.length;
    }

    @Override
    public Object parseEventValue(byte[] bytes) {
        return new Byte(bytes[8]);
    }

    public Byte getByteValue(long index) {
        return (Byte)this.getValue(index);
    }

    public void addByte(double timestamp, Byte byteValue) {
        this.add(timestamp, byteValue);
    }
}

