/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.local;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import utils.dataservice.DataList;
import utils.dataservice.UnsupportedDataTypeException;
import utils.dataservice.local.datalist.BooleanList;
import utils.dataservice.local.datalist.DoubleList;
import utils.dataservice.local.datalist.StringList;

public abstract class LocalDataList
implements DataList {
    private static Class[] supportedDataTypes = new Class[]{String.class, Double.class, Boolean.class};
    private static Class[] supportedDataList = new Class[]{StringList.class, DoubleList.class, BooleanList.class};
    protected File file;
    private static HashMap fileMap = new HashMap();

    public LocalDataList(File file) {
        this.file = file;
    }

    public static final int getIndexForDataType(Class clazz) {
        for (int i = 0; i < supportedDataTypes.length; ++i) {
            if (!supportedDataTypes[i].equals(clazz)) continue;
            return i;
        }
        return -1;
    }

    public static final Class getDataTypeForIndex(int index) {
        return supportedDataTypes[index];
    }

    public static LocalDataList newList(Class dataListType, File workingDir) throws UnsupportedDataTypeException, IOException {
        HashMap hashMap = fileMap;
        synchronized (hashMap) {
            String path = workingDir.getCanonicalPath();
            LocalDataList list = (LocalDataList)fileMap.get(path);
            if (list != null) {
                return list;
            }
            for (int i = 0; i < supportedDataTypes.length; ++i) {
                if (!supportedDataTypes[i].equals(dataListType)) continue;
                try {
                    Constructor constructor = supportedDataList[i].getConstructor(File.class);
                    Object dataListObject = constructor.newInstance(workingDir);
                    if (!(dataListObject instanceof LocalDataList)) continue;
                    fileMap.put(path, dataListObject);
                    return (LocalDataList)dataListObject;
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    throw new UnsupportedDataTypeException("Unable to instantiate data type list for type " + dataListType.getName(), e);
                }
            }
            throw new UnsupportedDataTypeException("The type " + dataListType.getName() + " is not a support data type");
        }
    }

    public static void addNewListImplementation(Class dataTypeClass, Class dataListClass) {
        Class[] newDataTypes = new Class[supportedDataTypes.length + 1];
        System.arraycopy(supportedDataTypes, 0, newDataTypes, 0, supportedDataTypes.length);
        newDataTypes[LocalDataList.supportedDataTypes.length + 1] = dataTypeClass;
        supportedDataTypes = newDataTypes;
        Class[] newDataLists = new Class[supportedDataList.length + 1];
        System.arraycopy(supportedDataList, 0, newDataLists, 0, supportedDataList.length);
        newDataLists[LocalDataList.supportedDataList.length + 1] = dataListClass;
        supportedDataList = newDataLists;
    }

    @Override
    public abstract Class getDataClass();

    @Override
    public abstract long size();

    @Override
    public abstract void add(double var1, Object var3);

    @Override
    public void add(double timestamp, Object object, boolean keepOriginalTimeStamp) {
        this.add(timestamp, object);
    }

    @Override
    public abstract double getTime(long var1);

    @Override
    public abstract Object getValue(long var1);

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCachedList(LocalDataList dataList) throws IOException {
        HashMap hashMap = fileMap;
        synchronized (hashMap) {
            String path = dataList.file.getCanonicalPath();
            fileMap.remove(path);
        }
    }
}

