/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.util;

import java.io.IOException;
import java.io.InputStream;

public class ClearableBufferedInputStream
extends InputStream {
    int n = 0;
    int pos = 0;
    byte[] buf;
    InputStream in;

    public ClearableBufferedInputStream(InputStream in, int size) {
        this.in = in;
        this.buf = new byte[size];
    }

    public void clearBuffer() {
        this.pos = 0;
        this.n = 0;
    }

    @Override
    public int read() throws IOException {
        while (this.pos == this.n) {
            this.n = this.in.read(this.buf);
            this.pos = 0;
        }
        if (this.n == -1) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }
}

