/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.aggregator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import utils.dataservice.gziplist.AggregateChunk;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.stream.StreamUtils;

public class MinAggregator
extends Aggregator {
    double min = Double.MAX_VALUE;
    long count = 0L;
    double[][] sub_min;

    protected MinAggregator(int chunkSpan, boolean subAggregator) {
        super((byte)1, chunkSpan, subAggregator);
        this.initSubAggregator();
        this.reset();
    }

    private void initSubAggregator() {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            this.sub_min = new double[subLevels][];
            for (int i = 0; i < subLevels; ++i) {
                int subEventSpan = AggregateChunk.SUB_EVENT_SPAN[i];
                int bucketCount = AggregateChunk.AGGREGATE_EVENT_SPANS[0] / subEventSpan;
                this.sub_min[i] = new double[bucketCount];
            }
        }
    }

    private void writeSubToStream(OutputStream outStream) throws IOException {
        if (this.subAggregator) {
            StreamUtils.writeLong(outStream, this.count);
            int levels = this.sub_min.length;
            StreamUtils.writeShort(outStream, (short)levels);
            for (int i = 0; i < levels; ++i) {
                StreamUtils.writeDoubleArray(outStream, this.sub_min[i]);
            }
        }
    }

    private void readSubFromStream(InputStream inStream) throws IOException {
        if (this.subAggregator) {
            this.count = StreamUtils.readLong(inStream);
            int levels = StreamUtils.readShort(inStream);
            for (int i = 0; i < levels; ++i) {
                StreamUtils.readDoubleArray(inStream, this.sub_min[i]);
            }
        }
    }

    private void resetSubAggregator() {
        if (this.subAggregator) {
            this.count = 0L;
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                Arrays.fill(this.sub_min[i], Double.MAX_VALUE);
            }
        }
    }

    private void addSubAggregatorValue(Number number) {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                int bucket = (int)(this.count / (long)AggregateChunk.SUB_EVENT_SPAN[i]);
                this.sub_min[i][bucket] = Math.min(number.doubleValue(), this.sub_min[i][bucket]);
            }
            ++this.count;
        }
    }

    private void addSubAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
        for (int i = 0; i < subLevels; ++i) {
            if ((long)AggregateChunk.SUB_EVENT_SPAN[i] != eventSpan) continue;
            long subStartIndex = startIndex % (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0];
            int bucket = (int)(subStartIndex / eventSpan);
            this.min = Math.min(((MinAggregator)agg).sub_min[i][bucket], this.min);
            this.count += eventSpan;
        }
    }

    @Override
    public Object getValue() {
        if (this.min == Double.MAX_VALUE) {
            return new Double(Double.NaN);
        }
        return new Double(this.min);
    }

    @Override
    public void writeToStream(OutputStream outStream) throws IOException {
        StreamUtils.writeDouble(outStream, this.min);
        this.writeSubToStream(outStream);
    }

    @Override
    public void readFromStream(InputStream inStream) throws IOException {
        this.min = StreamUtils.readDouble(inStream);
        this.readSubFromStream(inStream);
    }

    @Override
    public void reset() {
        this.min = Double.MAX_VALUE;
        this.resetSubAggregator();
    }

    @Override
    public void addValue(double timestamp, Object object, double previousTimestamp, Object previousObject) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (Double.isNaN(number.doubleValue())) {
                return;
            }
            this.addSubAggregatorValue(number);
            this.min = Math.min(((Number)object).doubleValue(), this.min);
        }
    }

    @Override
    public void addAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        if (agg instanceof MinAggregator) {
            if (eventSpan < (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0]) {
                this.addSubAggregateValue(agg, startIndex, eventSpan);
            } else {
                MinAggregator minAgg = (MinAggregator)agg;
                this.min = Math.min(minAgg.min, this.min);
            }
        }
    }
}

