/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.aggregator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import utils.dataservice.gziplist.AggregateChunk;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.stream.StreamUtils;

public class AverageAggregator
extends Aggregator {
    double sum = 0.0;
    long count = 0L;
    double[][] sub_sum;

    protected AverageAggregator(int chunkSpan, boolean subAggregator) {
        super((byte)3, chunkSpan, subAggregator);
        this.initSubAggregator();
        this.reset();
    }

    private void initSubAggregator() {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            this.sub_sum = new double[subLevels][];
            for (int i = 0; i < subLevels; ++i) {
                int subEventSpan = AggregateChunk.SUB_EVENT_SPAN[i];
                int bucketCount = AggregateChunk.AGGREGATE_EVENT_SPANS[0] / subEventSpan;
                this.sub_sum[i] = new double[bucketCount];
            }
        }
    }

    private void writeSubToStream(OutputStream outStream) throws IOException {
        if (this.subAggregator) {
            int levels = this.sub_sum.length;
            StreamUtils.writeShort(outStream, (short)levels);
            for (int i = 0; i < levels; ++i) {
                StreamUtils.writeDoubleArray(outStream, this.sub_sum[i]);
            }
        }
    }

    private void readSubFromStream(InputStream inStream) throws IOException {
        if (this.subAggregator) {
            int levels = StreamUtils.readShort(inStream);
            for (int i = 0; i < levels; ++i) {
                StreamUtils.readDoubleArray(inStream, this.sub_sum[i]);
            }
        }
    }

    private void resetSubAggregator() {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                Arrays.fill(this.sub_sum[i], 0.0);
            }
        }
    }

    private void addSubAggregatorValue(Number number) {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                int bucket = (int)(this.count / (long)AggregateChunk.SUB_EVENT_SPAN[i]);
                double[] dArray = this.sub_sum[i];
                int n = bucket;
                dArray[n] = dArray[n] + number.doubleValue();
            }
        }
    }

    private void addSubAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
        for (int i = 0; i < subLevels; ++i) {
            if ((long)AggregateChunk.SUB_EVENT_SPAN[i] != eventSpan) continue;
            long subStartIndex = startIndex % (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0];
            int bucket = (int)(subStartIndex / eventSpan);
            this.sum += ((AverageAggregator)agg).sub_sum[i][bucket];
            this.count += eventSpan;
        }
    }

    @Override
    public Object getValue() {
        if (this.count == 0L) {
            return new Double(Double.NaN);
        }
        return new Double(this.sum / (double)this.count);
    }

    @Override
    public void writeToStream(OutputStream outStream) throws IOException {
        StreamUtils.writeDouble(outStream, this.sum);
        StreamUtils.writeLong(outStream, this.count);
        this.writeSubToStream(outStream);
    }

    @Override
    public void readFromStream(InputStream inStream) throws IOException {
        this.sum = StreamUtils.readDouble(inStream);
        this.count = StreamUtils.readLong(inStream);
        this.readSubFromStream(inStream);
    }

    @Override
    public void reset() {
        this.sum = 0.0;
        this.count = 0L;
        this.resetSubAggregator();
    }

    @Override
    public void addValue(double timestamp, Object object, double previousTimestamp, Object previousObject) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (Double.isNaN(number.doubleValue())) {
                return;
            }
            this.addSubAggregatorValue(number);
            this.sum += ((Number)object).doubleValue();
            ++this.count;
        }
    }

    @Override
    public void addAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        if (eventSpan < (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0]) {
            this.addSubAggregateValue(agg, startIndex, eventSpan);
        } else {
            this.sum += ((AverageAggregator)agg).sum;
            this.count += ((AverageAggregator)agg).count;
        }
    }
}

