/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import utils.dataservice.gziplist.RAFileCache;

public class PooledRAFile {
    static final Object POOL_LOCK = new Object();
    private static final int MAX = 100;
    private static final RAFileCache cache = new RAFileCache(100);
    private static HashMap<File, Integer> countMap = new HashMap();
    public static int LIMIT = 1000;
    public static boolean USE_DEBUG_BREAK = false;

    public static int getSize() {
        return cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void method(File file) throws FileNotFoundException {
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long length(File file) throws FileNotFoundException, IOException {
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
            return raFile.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(File file) throws FileNotFoundException, IOException {
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile != null) {
                cache.removeFromCache(file);
                raFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFilePointer(File file) throws FileNotFoundException, IOException {
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
            return raFile.getFilePointer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, byte[] b, int off, int len) throws FileNotFoundException, IOException {
        if (USE_DEBUG_BREAK) {
            PooledRAFile.DEBUG_break_write(file, b, off, len);
            return;
        }
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
            raFile.write(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, int b) throws FileNotFoundException, IOException {
        if (USE_DEBUG_BREAK) {
            PooledRAFile.DEBUG_break_write(file, b);
            return;
        }
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
            raFile.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, byte[] b) throws FileNotFoundException, IOException {
        if (USE_DEBUG_BREAK) {
            PooledRAFile.DEBUG_break_write(file, b);
            return;
        }
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
            raFile.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void seek(File file, long pos) throws FileNotFoundException, IOException {
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
            raFile.seek(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int read(File file) throws FileNotFoundException, IOException {
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
            return raFile.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int read(File file, byte[] b, int off, int len) throws FileNotFoundException, IOException {
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
            return raFile.read(b, off, len);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, InterruptedException {
        File test = new File("test");
        test.mkdir();
        for (int i = 0; i < 10000; ++i) {
            File target = new File(test, "" + i);
            PooledRAFile.write(target, new byte[]{0});
        }
        System.gc();
        System.gc();
        System.gc();
        Thread.sleep(10000L);
    }

    private static int incrementCount(File file) {
        Integer val = countMap.get(file);
        if (val == null) {
            val = new Integer(0);
        }
        if ((val = new Integer(val + 1)) > LIMIT) {
            System.out.println("Exit after " + LIMIT + " bytes written to file " + file.getName());
            System.exit(1);
        }
        countMap.put(file, val);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DEBUG_break_write(File file, byte[] b, int off, int len) throws FileNotFoundException, IOException {
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
            for (int i = off; i < off + len; ++i) {
                raFile.write(b[i]);
                PooledRAFile.incrementCount(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DEBUG_break_write(File file, int b) throws FileNotFoundException, IOException {
        Object object = POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                cache.addToCache(file, raFile);
            }
            raFile.write(b);
            PooledRAFile.incrementCount(file);
        }
    }

    public static void DEBUG_break_write(File file, byte[] b) throws FileNotFoundException, IOException {
        PooledRAFile.DEBUG_break_write(file, b, 0, b.length);
    }
}

