/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist;

import utils.dataservice.gziplist.AggregateChunk;
import utils.dataservice.gziplist.Chunk;

public class IndexHelper {
    public static long getAggregateStartIndex(long chunkIndex, long eventSpan) {
        long endIndex = IndexHelper.getChunkEndIndex(chunkIndex - 1L);
        return endIndex - eventSpan;
    }

    public static long getAggregateEndIndex(long chunkIndex) {
        return IndexHelper.getChunkEndIndex(chunkIndex - 1L);
    }

    public static long getPreviousAggregateChunk(long chunkIndex, long chunkSpan) {
        if (chunkIndex <= chunkSpan) {
            return 0L;
        }
        long tempIndex = chunkIndex - chunkIndex % chunkSpan;
        return tempIndex;
    }

    public static long getNextAggregateChunk(long chunkIndex, long aggSpan) {
        return chunkIndex + aggSpan - chunkIndex % aggSpan;
    }

    public static long getChunkEndIndex(long chunkIndex) {
        long numAggChunksInBetween = chunkIndex / (long)AggregateChunk.AGGREGATE_CHUNK_SPANS[0];
        long relativeChunkIndex = chunkIndex - 1L - numAggChunksInBetween;
        return (relativeChunkIndex + 1L) * (long)Chunk.EVENT_COUNT;
    }

    public static long getChunkStartIndex(long chunkIndex) {
        long numAggChunksInBetween = chunkIndex / (long)AggregateChunk.AGGREGATE_CHUNK_SPANS[0];
        long relativeChunkIndex = chunkIndex - 1L - numAggChunksInBetween;
        return relativeChunkIndex * (long)Chunk.EVENT_COUNT;
    }

    public static boolean isAggregateChunk(long chunkIndex) {
        return chunkIndex % (long)AggregateChunk.AGGREGATE_CHUNK_SPANS[0] == 0L;
    }
}

