/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import utils.dataservice.gziplist.Chunk;
import utils.dataservice.gziplist.Killer;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.stream.StreamUtils;

public class AggregateChunk {
    public static final boolean COMPRESSED = false;
    public static final int[] AGGREGATE_CHUNK_SPANS = new int[]{10, 100, 1000};
    public static final int[] AGGREGATE_EVENT_SPANS = new int[]{AGGREGATE_CHUNK_SPANS[0] / AGGREGATE_CHUNK_SPANS[0] * (AGGREGATE_CHUNK_SPANS[0] - 1) * Chunk.EVENT_COUNT, AGGREGATE_CHUNK_SPANS[1] / AGGREGATE_CHUNK_SPANS[0] * (AGGREGATE_CHUNK_SPANS[0] - 1) * Chunk.EVENT_COUNT, AGGREGATE_CHUNK_SPANS[2] / AGGREGATE_CHUNK_SPANS[0] * (AGGREGATE_CHUNK_SPANS[0] - 1) * Chunk.EVENT_COUNT};
    public static final int[] SUB_EVENT_SPAN = new int[]{Chunk.EVENT_COUNT / 20, Chunk.EVENT_COUNT / 10, Chunk.EVENT_COUNT / 2, Chunk.EVENT_COUNT};
    private ArrayList<Aggregator> aggregators = new ArrayList();
    double startTime = -1.0;
    double endTime = -1.0;

    public Aggregator getAggregator(byte aggType, int chunkSpan) {
        for (int i = 0; i < this.aggregators.size(); ++i) {
            Aggregator agg = this.aggregators.get(i);
            if (agg.getAggregatorType() != aggType || agg.getChunkSpan() != chunkSpan) continue;
            return agg;
        }
        return null;
    }

    public ArrayList<Aggregator> getAggregators(int chunkspan) {
        ArrayList<Aggregator> list = new ArrayList<Aggregator>();
        for (int i = 0; i < this.aggregators.size(); ++i) {
            Aggregator agg = this.aggregators.get(i);
            if (agg.getChunkSpan() != chunkspan) continue;
            list.add(agg);
        }
        return list;
    }

    public void addValue(double timestamp, Object object, double previousTimestamp, Object previousObject) {
        if (this.startTime == -1.0) {
            this.startTime = timestamp;
        }
        this.endTime = timestamp;
        for (int i = 0; i < this.aggregators.size(); ++i) {
            this.aggregators.get(i).addValue(timestamp, object, previousTimestamp, previousObject);
        }
    }

    public void toStream(OutputStream outStream, long chunkCount) throws IOException {
        int i;
        ArrayList<Aggregator> aggregatorsToWrite = new ArrayList<Aggregator>();
        long chunkSpanThreshold = 0L;
        for (i = AGGREGATE_CHUNK_SPANS.length - 1; i >= 0 && chunkSpanThreshold == 0L; --i) {
            if (chunkCount % (long)AGGREGATE_CHUNK_SPANS[i] != 0L) continue;
            chunkSpanThreshold = AGGREGATE_CHUNK_SPANS[i];
        }
        for (i = 0; i < this.aggregators.size(); ++i) {
            Aggregator agg = this.aggregators.get(i);
            if ((long)agg.getChunkSpan() > chunkSpanThreshold) continue;
            aggregatorsToWrite.add(agg);
        }
        int size = aggregatorsToWrite.size();
        StreamUtils.writeShort(outStream, (short)size);
        for (int i2 = 0; i2 < size; ++i2) {
            Aggregator agg = (Aggregator)aggregatorsToWrite.get(i2);
            agg.toStream(outStream);
            agg.reset();
            this.startTime = -1.0;
        }
        Killer.kill();
    }

    public static AggregateChunk fromStream(InputStream inStream) throws IOException {
        AggregateChunk chunk = new AggregateChunk();
        int size = StreamUtils.readShort(inStream);
        for (int i = 0; i < size; ++i) {
            chunk.addAggregator(Aggregator.fromStream(inStream));
        }
        return chunk;
    }

    private void addAggregator(Aggregator aggregator) {
        if (!this.aggregators.contains(aggregator)) {
            this.aggregators.add(aggregator);
        }
    }

    public void addAggregators(Aggregator[] newAggs) {
        for (int i = 0; i < newAggs.length; ++i) {
            this.addAggregator(newAggs[i]);
        }
    }

    public void addAggregators(byte[] aggregatorTypes) {
        for (int i = 0; i < AGGREGATE_CHUNK_SPANS.length; ++i) {
            for (int j = 0; j < aggregatorTypes.length; ++j) {
                this.addAggregator(Aggregator.getAggregator(aggregatorTypes[j], AGGREGATE_CHUNK_SPANS[i], null));
            }
        }
    }

    public double getEndTime() {
        return this.endTime;
    }

    public double getStartTime() {
        return this.startTime;
    }
}

