/*
 * Decompiled with CFR 0.152.
 */
package testing.classes.access;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.ProxyServerStartup;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientAdapter;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanel;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.alerts.model.AlertTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ResourceBundle;
import testing.Credentials;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageHelper;

public class AccessPanelTester {
    static int testport = -1;
    static String testpass = "";
    static MachineTreeModel machineModel;
    private AlertTreeModel alertModel;
    static TestTechClientListener testListener;

    private static int shPort() {
        if (testport == -1) {
            testport = Credentials.getLocalServerPort();
            testpass = Credentials.getLocalServerPassword();
        }
        return testport;
    }

    private static String shPassword() {
        AccessPanelTester.shPort();
        return testpass;
    }

    private static boolean isServerRunning(int port) {
        try {
            URL url = new URL("http://localhost:" + port + "/server_version");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            connection.disconnect();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        TechClient tc = new TechClient("en.txt", (ResourceBundle)Language.DEFLANG, "localhost", 5401, new TechCredentials(OemBranding.OEM_ADMIN_USERNAME, "password", null), true, testListener);
    }

    private void runTest() throws Exception {
        Language.loadTranslations();
        AccessPanelTester.shPort();
        AccessPanel.TESTING = true;
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        Robot r = new Robot();
        long T = System.currentTimeMillis();
        AccessPanel.TEST_THUMB = ImageHelper.toBufferedImageRGB(r.createScreenCapture(new Rectangle(0, 0, d.width, d.height)));
        AccessPanel.TEST_THUMB = ImageHelper.scaleDownToFitInside(AccessPanel.TEST_THUMB, 300, 200, true);
        T = System.currentTimeMillis() - T;
        System.out.println("Scale took " + T + "ms");
        AccessPanel.TEST_SCREEN = ImageHelper.toBufferedImageRGB(r.createScreenCapture(new Rectangle(0, 0, d.width, d.height)));
        AccessPanel.TEST_SCREEN = ImageHelper.scaleDownToFitInside(AccessPanel.TEST_SCREEN, 800, 600, true);
        if (!AccessPanelTester.isServerRunning(AccessPanelTester.shPort())) {
            new ProxyServerStartup();
        }
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setBounds(frame.getX() - 100, frame.getY(), frame.getWidth() + 250, frame.getHeight());
        TechClient tc = AccessPanelTester.getTechClient();
        machineModel = new MachineTreeModel();
        machineModel.setTechClient(tc);
        this.alertModel = new AlertTreeModel();
        this.alertModel.setTechClient(tc);
        AccessPanel accessPanel = new AccessPanel(machineModel, this.alertModel, null);
        accessPanel.setTechClient(tc);
        frame.getContentPane().add(accessPanel.getRootComponent());
        TreeElement[] allMachines = tc.getEntireMachineList_Expensive();
        machineModel.addElements(allMachines);
        machineModel.addSessions(tc.getRemoteAccessSessions_Expensive());
        frame.setVisible(true);
    }

    public static TechClient getTechClient() throws Exception {
        return AccessPanelTester.getTechClient(testListener);
    }

    public static TechClient getTechClient(TechClientListener listener) throws Exception {
        return AccessPanelTester.getTechClient(null, AccessPanelTester.shPassword(), listener);
    }

    public static TechClient getTechClient(String username, String password) throws Exception {
        return AccessPanelTester.getTechClient(username, password, testListener);
    }

    public static TechClient getTechClient(String username, String password, TechClientListener listener) throws Exception {
        return new TechClient("en.txt", (ResourceBundle)Language.DEFLANG, "localhost", AccessPanelTester.shPort(), new TechCredentials(username, password, TechClient.NULL_SESSION_ID), true, listener);
    }

    static {
        testListener = new TestTechClientListener();
    }

    static class TestTechClientListener
    extends TechClientAdapter {
        TestTechClientListener() {
        }

        @Override
        public void machineAdded(Machine machine) {
            System.out.println("ASYNC NOTIFICATION machineAdded " + machine);
            machineModel.addElements(new Machine[]{machine});
        }

        @Override
        public void machineRemoved(Machine machine) {
            System.out.println("ASYNC NOTIFICATION machineRemoved " + machine);
            machineModel.removeElements(new Machine[]{machine});
        }

        @Override
        public void machineOnline(Machine machine) {
            System.out.println("ASYNC NOTIFICATION machineOnline " + machine);
            machineModel.updateMachine(machine);
        }

        @Override
        public void machineOffline(Machine machine) {
            System.out.println("ASYNC NOTIFICATION machineOffline " + machine);
            machineModel.updateMachine(machine);
        }

        @Override
        public void machineDataChanged(Machine machine) {
            System.out.println("ASYNC NOTIFICATION machineDataChanged " + machine + " monitored=" + machine.isMonitored());
            machineModel.updateMachine(machine);
        }

        @Override
        public void machineFilterableInfoChanged(Machine machine) {
            System.out.println("ASYNC NOTIFICATION machineFilterableInfoChanged " + machine);
            machineModel.updateMachine(machine);
        }

        @Override
        public void customerListChanged() {
        }

        @Override
        public void customerLiveListChanged() {
        }

        @Override
        public void demoListChanged() {
        }

        @Override
        public void setWarningMessage(String text) {
        }

        public void updateSessionCounts(boolean isJoinedSessionCounts, boolean isEvaluation, int shSessions, int sgSessions, int maxSHSessions, int maxSGSessions) {
        }

        public String requestTwoTierCode(boolean showIncorrectWarning, String techEmailAddress) {
            return null;
        }

        @Override
        public void sessionAdded(AccessSession session) {
            System.out.println("ASYNC NOTIFICATION sessionAdded " + session);
            machineModel.addSessions(new AccessSession[]{session});
        }

        @Override
        public void sessionRemoved(AccessSession session) {
            System.out.println("ASYNC NOTIFICATION sessionRemoved " + session);
            machineModel.removeSessions(new AccessSession[]{session});
        }

        @Override
        public void licenseChanged() {
        }

        public void alertAdded(LocatedAlert alert) {
        }

        public void alertRemoved(LocatedAlert alert) {
        }

        public void alertChanged(LocatedAlert alert) {
        }
    }
}

