/*
 * Decompiled with CFR 0.152.
 */
package testing;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class Credentials {
    static Properties props = null;

    private static void loadCredentials() {
        if (props != null) {
            return;
        }
        System.out.println("[AccessPanelTester] Loading local SH server credentials");
        props = new Properties();
        try {
            File file;
            File credentialsFolder = new File("../Credentials");
            if (!credentialsFolder.exists()) {
                credentialsFolder = new File("../../Credentials");
            }
            if (!credentialsFolder.exists()) {
                credentialsFolder = new File("Credentials");
            }
            if (!(file = new File(credentialsFolder, "LocalShServerCredentials.properties")).exists()) {
                System.out.println("[AccessPanelTester] WARNING: Unable to load local SH server credentials!");
                System.out.println("[AccessPanelTester] Please create Credentials/LocalShServerCredentials.properties with shPort=xxx and shPassword=yyyy");
            } else {
                System.out.println("[AccessPanelTester] Loading credentials from: " + file);
            }
            FileInputStream fin = new FileInputStream(file);
            try {
                props.load(new BufferedInputStream(fin));
            }
            finally {
                fin.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static String getSHSiteUsername() {
        Credentials.loadCredentials();
        return props.getProperty("shSiteUsername");
    }

    public static String getSHSitePassword() {
        Credentials.loadCredentials();
        return props.getProperty("shSitePassword");
    }

    public static String getGDCSiteUsername() {
        Credentials.loadCredentials();
        return props.getProperty("gdcSiteUsername");
    }

    public static String getGDCSitePassword() {
        Credentials.loadCredentials();
        return props.getProperty("gdcSitePassword");
    }

    public static int getLocalServerPort() {
        Credentials.loadCredentials();
        return Integer.parseInt(props.getProperty("shPort").trim());
    }

    public static String getLocalServerPassword() {
        Credentials.loadCredentials();
        return props.getProperty("shPassword");
    }

    public static void main(String[] args) {
        System.out.println(Credentials.getLocalServerPort());
        System.out.println(Credentials.getLocalServerPassword());
    }
}

