/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import org.fife.ui.rsyntaxtextarea.RtfToText;

class RtfTransferable
implements Transferable {
    private byte[] data;
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{new DataFlavor("text/rtf", "RTF"), DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};

    RtfTransferable(byte[] data) {
        this.data = data;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(FLAVORS[0])) {
            return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
        }
        if (flavor.equals(FLAVORS[1])) {
            return this.data == null ? "" : RtfToText.getPlainText((byte[])this.data);
        }
        if (flavor.equals(FLAVORS[2])) {
            String text = "";
            if (this.data != null) {
                text = RtfToText.getPlainText((byte[])this.data);
            }
            return new StringReader(text);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < FLAVORS.length; ++i) {
            if (!flavor.equals(FLAVORS[i])) continue;
            return true;
        }
        return false;
    }
}

