/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.params.DSAKeyParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class DSASigner
implements DSA {
    DSAKeyParameters key;
    SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (DSAPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (DSAPrivateKeyParameters)param;
            }
        } else {
            this.key = (DSAPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger k;
        DSAParameters params = this.key.getParameters();
        BigInteger m = this.calculateE(params.getQ(), message);
        int qBitLength = params.getQ().bitLength();
        while ((k = new BigInteger(qBitLength, this.random)).compareTo(params.getQ()) >= 0) {
        }
        BigInteger r = params.getG().modPow(k, params.getP()).mod(params.getQ());
        k = k.modInverse(params.getQ()).multiply(m.add(((DSAPrivateKeyParameters)this.key).getX().multiply(r)));
        BigInteger s = k.mod(params.getQ());
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        DSAParameters params = this.key.getParameters();
        BigInteger m = this.calculateE(params.getQ(), message);
        BigInteger zero = BigInteger.valueOf(0L);
        if (zero.compareTo(r) >= 0 || params.getQ().compareTo(r) <= 0) {
            return false;
        }
        if (zero.compareTo(s) >= 0 || params.getQ().compareTo(s) <= 0) {
            return false;
        }
        BigInteger w = s.modInverse(params.getQ());
        BigInteger u1 = m.multiply(w).mod(params.getQ());
        BigInteger u2 = r.multiply(w).mod(params.getQ());
        u1 = params.getG().modPow(u1, params.getP());
        u2 = ((DSAPublicKeyParameters)this.key).getY().modPow(u2, params.getP());
        BigInteger v = u1.multiply(u2).mod(params.getP()).mod(params.getQ());
        return v.equals(r);
    }

    private BigInteger calculateE(BigInteger n, byte[] message) {
        if (n.bitLength() >= message.length * 8) {
            return new BigInteger(1, message);
        }
        byte[] trunc = new byte[n.bitLength() / 8];
        System.arraycopy(message, 0, trunc, 0, trunc.length);
        return new BigInteger(1, trunc);
    }
}

