/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import utils.files.FileUtil;
import utils.progtools.URIUtil;

public class DownloaderInputStream
extends InputStream {
    private static final boolean DEBUG_LOAD_SLOW = false;
    private final URL archiveURL;
    private InputStream urlStream;
    private long totalSize = 0L;
    private long totalDownloaded = 0L;
    private ProgressListener progressListener;
    private long lastNotification = 0L;

    public DownloaderInputStream(URL url) throws IOException {
        this.archiveURL = URIUtil.tryGetSafeURLFrom(url);
        this.initialiseStream();
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListener = listener;
    }

    private void notifyProgressListener() {
        if (this.progressListener == null) {
            return;
        }
        if (this.totalDownloaded == this.totalSize || System.currentTimeMillis() - this.lastNotification > 30L) {
            this.lastNotification = System.currentTimeMillis();
            this.progressListener.progressChanged(this.totalDownloaded, this.totalSize);
        }
    }

    public void initialiseStream() throws IOException {
        System.out.println("[DownloaderInputStream] Fetching " + this.archiveURL);
        URLConnection conn = this.archiveURL.openConnection();
        try {
            this.totalSize = Long.parseLong(conn.getHeaderField("content-length"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.urlStream = new BufferedInputStream(conn.getInputStream(), 500000);
    }

    public int read() throws IOException {
        int read = this.urlStream.read();
        if (read != -1) {
            ++this.totalDownloaded;
        }
        this.notifyProgressListener();
        return read;
    }

    public void close() {
        FileUtil.robustClose(this.urlStream);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.urlStream.read(b, off, len);
        if (read != -1) {
            this.totalDownloaded += (long)read;
        }
        this.notifyProgressListener();
        return read;
    }

    public static interface ProgressListener {
        public void progressChanged(long var1, long var3);
    }
}

