/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.ui;

import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jwrapper.ui.JWLanguage;
import utils.swing.SafeLookAndFeel;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.messagefields.MessagePasswordTextField;
import utils.swing.components.messagefields.MessageTextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.layout.GbPanel;

public class ProxyCredentialsDialog
extends JDialog
implements ActionListener,
KeyListener {
    private MessageTextField proxyUsernameField = new MessageTextField(JWLanguage.getString("USERNAME"), null);
    private MessagePasswordTextField proxyPasswordField = new MessagePasswordTextField(JWLanguage.getString("PASSWORD"), null);
    private JButton okButton;
    private JButton cancelButton;
    private String proxyPassword;
    private String proxyUsername;
    private String appName;

    public static void main(String[] args) {
        new ProxyCredentialsDialog("Remote Support");
    }

    public String getPassword() {
        return this.proxyPassword;
    }

    public String getUsername() {
        return this.proxyUsername;
    }

    public static ProxyCredentialsDialog showDialog(String name) {
        try {
            SafeLookAndFeel.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new ProxyCredentialsDialog(name);
    }

    private ProxyCredentialsDialog(String appName) {
        super((Frame)null);
        this.appName = appName;
        this.setSize(420, 190);
        this.setModal(true);
        this.proxyPasswordField.setMessageText(JWLanguage.getString("PASSWORD"));
        GbPanel proxyPanel = new GbPanel();
        this.initGraphics(proxyPanel);
        this.getContentPane().add(proxyPanel);
        this.setTitle(JWLanguage.getString("PROXY_DIALOG_TITLE"));
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.addKeyListener(this);
        this.setVisible(true);
    }

    private void initGraphics(GbPanel proxyPanel) {
        int Y = 0;
        InputStream fin = this.getClass().getResourceAsStream("padlock.png");
        BufferedImage padlockImage = null;
        try {
            padlockImage = ImageIO.read(fin);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ImageIcon padlockIcon = null;
        try {
            padlockIcon = new ImageIcon(padlockImage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JWrapLabel desc = new JWrapLabel("<html>" + this.appName + " " + JWLanguage.getString("PROXY_DESCRIPTION") + "</html>");
        this.okButton = new JButton(JWLanguage.getString("AUTHENTICATE"));
        this.cancelButton = new JButton(JWLanguage.getString("CANCEL"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.proxyUsernameField.addKeyListener(this);
        this.proxyPasswordField.addKeyListener(this);
        this.okButton.setEnabled(false);
        GbPanel buttonsPanel = new GbPanel();
        buttonsPanel.add(this.cancelButton, 0, 0, 1, 1, 100, 1, 13, 0);
        buttonsPanel.add(this.okButton, 1, 0, 1, 1, 0, 1, 13, 0, new Insets(0, 10, 0, 0));
        SwingUtil.setWidth(this.proxyUsernameField, 250);
        SwingUtil.setWidth(this.proxyPasswordField, 250);
        proxyPanel.setBorder(SHBorderFactory.createEmptyBorder(15, 15, 15, 15));
        proxyPanel.add(desc, 0, Y++, 2, 1, 0, 1, 10, 2, new Insets(5, 10, 0, 10));
        proxyPanel.add(new JLabel(padlockIcon), 0, Y, 1, 2, 0, 1, 10, 2, new Insets(10, 10, 10, 10));
        proxyPanel.add(this.proxyUsernameField, 1, Y++, 1, 1, 1, 1, 17, 0, new Insets(10, 10, 10, 0));
        proxyPanel.add(this.proxyPasswordField, 1, Y++, 1, 1, 1, 1, 17, 0, new Insets(0, 10, 10, 0));
        proxyPanel.add(buttonsPanel, 0, Y++, 2, 1, 1, 0, 10, 2, new Insets(0, 0, 0, 0));
        proxyPanel.add(new JPanel(), 0, Y++, 1, 1, 0, 100, 10, 2, new Insets(0, 0, 0, 0));
    }

    private void updateEnabled() {
        if (this.proxyUsernameField.getText().length() > 0) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.processAction(e.getSource());
    }

    private void processAction(Object source) {
        if (source == this.okButton) {
            this.proxyUsername = this.proxyUsernameField.getText();
            this.proxyPassword = this.proxyPasswordField.getText();
        } else {
            this.proxyUsername = null;
        }
        this.setVisible(false);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.updateEnabled();
        if (e.getKeyCode() == 10) {
            this.processAction(this.okButton);
        } else if (e.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    public void keyTyped(KeyEvent e) {
    }
}

