/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Iterator;
import java.util.LinkedList;
import utils.stream.StreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWProxyList {
    private LinkedList<Proxy> list = new LinkedList();
    private int maxSize;

    public JWProxyList(int maxSize) {
        this.maxSize = maxSize;
    }

    public Object clone() {
        JWProxyList newList = new JWProxyList(this.maxSize);
        newList.list = (LinkedList)this.list.clone();
        return newList;
    }

    public boolean containsProxy(Proxy proxy) {
        return this.list.contains(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File file) throws IOException {
        if (file.exists()) {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
            try {
                int proxyCount = StreamUtils.readInt(bin);
                for (int i = 0; i < proxyCount; ++i) {
                    String type = StreamUtils.readStringUTF8(bin);
                    String hostname = StreamUtils.readStringUTF8(bin);
                    int port = StreamUtils.readInt(bin);
                    try {
                        InetSocketAddress address = new InetSocketAddress(hostname, port);
                        Proxy newProxy = new Proxy(Proxy.Type.valueOf(type), address);
                        if (this.list.contains(newProxy)) continue;
                        this.list.add(newProxy);
                        System.out.println("[JWProxyList] Added detected proxy: " + newProxy);
                        continue;
                    }
                    catch (Throwable t) {
                        System.out.println("[JWProxyList] Could not load proxy " + type + ":" + hostname + ":" + port + ".");
                        t.printStackTrace();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                bin.close();
            }
        }
    }

    public static String getHostnameFrom(InetSocketAddress isa) {
        try {
            Method method = InetSocketAddress.class.getDeclaredMethod("getHostString", new Class[0]);
            method.setAccessible(true);
            Object result = method.invoke((Object)isa, new Object[0]);
            if (result != null) {
                return result.toString();
            }
            System.out.println("[JWProxyList] Warning: JWProxyList returned null for getHostString");
            return isa.getHostName();
        }
        catch (Throwable t) {
            System.out.println("[JWProxyList] Warning: JWProxyList failed to call getHostString (" + t.getMessage() + ")");
            return isa.getHostName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws IOException {
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file));
        try {
            StreamUtils.writeInt(bout, this.list.size());
            for (int i = 0; i < this.list.size(); ++i) {
                Proxy proxy = this.list.get(i);
                if (proxy == null) continue;
                InetSocketAddress address = (InetSocketAddress)proxy.address();
                StreamUtils.writeStringUTF8(bout, proxy.type().name());
                StreamUtils.writeStringUTF8(bout, JWProxyList.getHostnameFrom(address));
                StreamUtils.writeInt(bout, address.getPort());
            }
            System.out.println("[JWProxyList] Saved " + this.list.size() + " proxy descriptions");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            bout.close();
        }
    }

    public Iterator<Proxy> getProxyIterator() {
        return this.list.iterator();
    }

    public void addProxyToFront(Proxy proxy) {
        if (proxy.address() == null) {
            return;
        }
        if (this.containsProxy(proxy)) {
            return;
        }
        this.list.addFirst(proxy);
        if (this.list.size() > this.maxSize) {
            this.list.removeLast();
        }
    }
}

