/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import jwrapper.jwutils.JWSystem;
import jwrapper.proxy.JWProxyAuthenticator;
import jwrapper.proxy.JWProxyCredentials;
import jwrapper.proxy.JWProxyList;
import jwrapper.proxy.NullProxySelector;
import utils.stream.StreamUtils;

public class JWDetectedProxy {
    public static boolean DETECTED_PROXY_OK = false;
    public static Proxy DETECTED_PROXY = null;
    public static boolean DETECTED_PROXY_OVERWRITE_SELECTOR = false;
    private static String oldHttpHostProperty = null;
    private static String oldHttpPortProperty = null;
    private static String oldHttpsHostProperty = null;
    private static String oldHttpsPortProperty = null;
    private static String oldSocksHostProperty = null;
    private static String oldSocksPortProperty = null;
    public static ProxySelector DEFAULT_SELECTOR = null;

    public static URLConnection openConnection(URL url) throws IOException {
        if (DETECTED_PROXY_OK) {
            return url.openConnection(DETECTED_PROXY);
        }
        return url.openConnection();
    }

    public static InputStream openStream(URL url) throws IOException {
        return JWDetectedProxy.openConnection(url).getInputStream();
    }

    public static void revertDefaultProxySettings() {
        if (oldHttpHostProperty != null) {
            System.setProperty("http.proxyHost", oldHttpHostProperty);
        }
        if (oldHttpPortProperty != null) {
            System.setProperty("http.proxyPort", oldHttpPortProperty);
        }
        if (oldHttpsHostProperty != null) {
            System.setProperty("https.proxyHost", oldHttpsHostProperty);
        }
        if (oldHttpsPortProperty != null) {
            System.setProperty("https.proxyPort", oldHttpsPortProperty);
        }
        if (oldSocksHostProperty != null) {
            System.setProperty("socksProxyHost", oldSocksHostProperty);
        }
        if (oldSocksPortProperty != null) {
            System.setProperty("socksProxyPort", oldSocksPortProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDetectedProxy() {
        File sharedFolder = JWSystem.getAllAppVersionsSharedFolder();
        File lastWorking = new File(sharedFolder, "LastProxy");
        lastWorking.delete();
        if (DETECTED_PROXY_OK && DETECTED_PROXY != null && DETECTED_PROXY != Proxy.NO_PROXY) {
            System.out.println("[JWDetectedProxy] [Save] Detected " + DETECTED_PROXY + " so saving it now...");
            SocketAddress address = DETECTED_PROXY.address();
            if (address == null || !(address instanceof InetSocketAddress)) {
                return;
            }
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            String hostname = JWProxyList.getHostnameFrom(inetAddress);
            int port = inetAddress.getPort();
            if (hostname == null) {
                return;
            }
            try {
                FileOutputStream fout = new FileOutputStream(lastWorking);
                try {
                    StreamUtils.writeBoolean(fout, DETECTED_PROXY.type() == Proxy.Type.HTTP);
                    StreamUtils.writeStringUTF8(fout, hostname);
                    StreamUtils.writeInt(fout, port);
                    StreamUtils.writeBoolean(fout, DETECTED_PROXY_OVERWRITE_SELECTOR);
                }
                finally {
                    fout.close();
                }
                System.out.println("[JWDetectedProxy] [Save] Proxy saved.");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLastDetectedProxy() {
        File sharedFolder = JWSystem.getAllAppVersionsSharedFolder();
        File lastWorking = new File(sharedFolder, "LastProxy");
        File credentialsFile = new File(sharedFolder, "ProxyCredentials");
        if (!lastWorking.exists() || lastWorking.length() == 0L) {
            System.out.println("[JWDetectedProxy] No proxy configuration found to load.");
            DETECTED_PROXY_OK = false;
            return;
        }
        try {
            FileInputStream fin = new FileInputStream(lastWorking);
            try {
                boolean isHTTP = StreamUtils.readBoolean(fin);
                String hostname = StreamUtils.readStringUTF8(fin);
                int port = StreamUtils.readInt(fin);
                boolean overwriteSelector = false;
                try {
                    overwriteSelector = StreamUtils.readBoolean(fin);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                InetSocketAddress isa = new InetSocketAddress(hostname, port);
                Proxy proxy = isHTTP ? new Proxy(Proxy.Type.HTTP, isa) : new Proxy(Proxy.Type.SOCKS, isa);
                DETECTED_PROXY = proxy;
                DETECTED_PROXY_OK = true;
                DETECTED_PROXY_OVERWRITE_SELECTOR = overwriteSelector;
                JWDetectedProxy.setDetectedProxyAsDefault();
                System.out.println("[JWDetectedProxy] Loaded detected proxy configuration. Setting up authenticator.");
                JWProxyCredentials credentials = new JWProxyCredentials();
                try {
                    credentials.loadFromFile(credentialsFile);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                JWProxyAuthenticator authenticator = new JWProxyAuthenticator(credentials);
                System.out.println("[JWDetectedProxy] Set up authenticator.");
            }
            catch (Throwable t) {
                t.printStackTrace();
                DETECTED_PROXY_OK = false;
            }
            finally {
                try {
                    fin.close();
                }
                catch (IOException isHTTP) {}
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            DETECTED_PROXY_OK = false;
        }
    }

    public static void setDetectedProxyAsDefault() {
        System.out.println("[JWDetectedProxy] Asked to set as default (" + DETECTED_PROXY_OK + "," + DETECTED_PROXY_OVERWRITE_SELECTOR + "," + DEFAULT_SELECTOR + "," + NullProxySelector.isDefaultProxySelectorNull() + ")");
        if (DETECTED_PROXY_OK) {
            if (!NullProxySelector.isDefaultProxySelectorNull() && DETECTED_PROXY_OVERWRITE_SELECTOR) {
                System.out.println("[JWDetectedProxy] Clearing proxy selector, preparing for override.");
                DEFAULT_SELECTOR = ProxySelector.getDefault();
                ProxySelector.setDefault(NullProxySelector.INSTANCE);
            }
            if (NullProxySelector.isDefaultProxySelectorNull() && !DETECTED_PROXY_OVERWRITE_SELECTOR) {
                System.out.println("[JWDetectedProxy] Setting default proxy selector: " + DEFAULT_SELECTOR);
                ProxySelector.setDefault(DEFAULT_SELECTOR);
            }
        }
        if (DETECTED_PROXY_OK && DETECTED_PROXY != null && DETECTED_PROXY != Proxy.NO_PROXY) {
            SocketAddress address = DETECTED_PROXY.address();
            if (address == null || !(address instanceof InetSocketAddress)) {
                System.out.println("[JWDetectedProxy] The detected proxy address is invalid (" + address + ")");
                return;
            }
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            String hostname = JWProxyList.getHostnameFrom(inetAddress);
            int port = inetAddress.getPort();
            oldHttpHostProperty = System.getProperty("http.proxyHost");
            oldHttpPortProperty = System.getProperty("http.proxyPort");
            oldHttpsHostProperty = System.getProperty("https.proxyHost");
            oldHttpsPortProperty = System.getProperty("https.proxyPort");
            oldSocksHostProperty = System.getProperty("socksProxyHost");
            oldSocksPortProperty = System.getProperty("socksProxyPort");
            if (DETECTED_PROXY.type() == Proxy.Type.HTTP) {
                System.out.println("[JWDetectedProxy] Default HTTP proxy (" + hostname + ":" + port + ")");
                System.setProperty("http.proxyHost", hostname);
                System.setProperty("http.proxyPort", Integer.toString(port));
                System.setProperty("https.proxyHost", hostname);
                System.setProperty("https.proxyPort", Integer.toString(port));
            } else if (DETECTED_PROXY.type() == Proxy.Type.SOCKS) {
                System.out.println("[JWDetectedProxy] Default SOCKS proxy (" + hostname + ":" + port + ")");
                System.setProperty("socksProxyHost", hostname);
                System.setProperty("socksProxyPort", Integer.toString(port));
            }
        }
    }
}

