/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.test;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jwrapper.jwutils.JWConstantClock;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.swing.JWAutomate;
import jwrapper.logging.StdLogging;
import jwrapper.updater.JWLaunchProperties;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.progtools.BatchingTimedThreadLock;
import utils.progtools.StackTracer;
import utils.stream.TinyWebServer;
import utils.string.Normaliser;
import utils.string.StringReplace;
import utils.swing.borders.SimpleShadowBorder;
import utils.swing.browser.Browser;

public class JWTesting {
    public static String JWA_REPORT_PORT = "JWAutomation.ReportPort";
    public static String JWA_REPORT_HOST = "JWAutomation.ReportHost";
    public static String JWA_REPORT_BARRIER = "JWAutomation.BarrierSet";
    public static String BARRIER_SET_COMPLETE = "JWAutomation.BarrierSetComplete";
    private static int JWA_MSG_ATTEMPT = 1;
    private static int JWA_MSG_SUCCESS = 2;
    private static int JWA_MSG_FAIL = 3;
    private static int JWA_MSG_SCREEN = 4;
    private static int JWA_MSG_STATUS = 5;
    private static int JWA_MSG_BARRIER = 6;
    private static int JWA_MSG_KEEPALIVE = 7;
    private BatchingTimedThreadLock btlock = new BatchingTimedThreadLock(2000L);
    private ServerSocket ssock;
    private JWAServer tws;
    private Object LOCK = new Object();
    private HashMap map = new HashMap();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
    private File dir;
    private File report;
    private boolean finished = false;
    private long finishAt = 0L;
    private long finishCases = 0L;
    private long inactivityTimeout = 180000L;
    private boolean noMoreCases = false;
    private Object status_LOCK = new Object();
    private HashMap statuses = new HashMap();
    private UpdateThread updatey;
    String border = "#8EB9CE";
    String header = "#AACDDE";
    String row1 = "B4E7CA";
    String row2 = "A7D9BD";
    String rowx1 = "#DAF7BA";
    String rowx2 = "#D1EAB3";
    String fail = "#F2C5BA";
    String maybe = "#FFE3C3";
    private Object write_LOCK = new Object();
    private static Object reportSock_LOCK = new Object();
    private static Socket reportSock;
    private static DataOutputStream reportDout;
    private static DataInputStream reportDin;
    private static boolean reportSockOK;
    static String latestBarrierReached;
    public static Object barrier_LOCK;
    static int waitingAtBarrier;
    public static String FAKE_CONFIG_FOLDER;

    public void setInactivityTimeout(int ms) {
        this.inactivityTimeout = ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkForLocalFailure(Entry local, String logFile) {
        try {
            while (local.getCertainFailures() > local.failsHandled) {
                System.out.println(local.name + " has failed, will fetch logs and request a failure report");
                ++local.failsHandled;
                System.out.println("Copying log file of failed instance " + logFile + " (" + new File(logFile).exists() + ")");
                Entry fullEntry = this.getEntry(local.name);
                String logName = Normaliser.normaliseShort("Fail - " + local.name + " - " + new File(logFile).getName());
                System.out.println("Copying to " + logName);
                FileUtil.copy(new File(logFile), new File(this.dir, logName));
                Entry entry = fullEntry;
                synchronized (entry) {
                    fullEntry.failLogs.add(logName);
                }
            }
            return;
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(String name) {
        Object object = this.LOCK;
        synchronized (object) {
            Entry entry = (Entry)this.map.get(name);
            if (entry == null) {
                entry = new Entry();
                entry.name = name;
                this.map.put(name, entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReport() {
        Object[] entries;
        Object object = this.LOCK;
        synchronized (object) {
            entries = this.map.values().toArray();
        }
        object = this.write_LOCK;
        synchronized (object) {
            try {
                long totalCases = 0L;
                boolean completeSuccess = false;
                PrintStream pout = new PrintStream(new BufferedOutputStream(new AtomicFileOutputStream(this.report)));
                pout.println("<html>");
                if (!this.finished) {
                    pout.println("<meta http-equiv=\"refresh\" content=\"5\">");
                }
                pout.println("<body bgcolor='#FFFFFF' style='font-family: sans-serif'>");
                pout.println("<table style='background-color: " + this.border + "' cellspacing='0' cellpadding='10' ><tr><td>");
                if (this.finished) {
                    pout.println("<h1 style='margin: 0; padding: 0; display: inline-block' >" + this.dir.getName() + " &nbsp; </h1><h3 style='display: inline'>(Ended) &nbsp; </h3>");
                } else {
                    pout.print("<h1 style='margin: 0; padding: 0' >" + this.dir.getName() + "  ");
                    pout.println("&nbsp; <button formmethod='get' onclick='window.location=\"/terminate\"'>Cancel Test</button> &nbsp; ");
                    pout.println("</h1>");
                }
                pout.println("</td></tr></table>");
                Arrays.sort(entries, new EntryComparator());
                pout.println("<table style='border: 20px solid " + this.border + ";' border='0' cellspacing='0' cellpadding='5' width='100%'>");
                pout.println("<tr bgcolor='" + this.header + "' >");
                pout.println("<td>");
                pout.print("Case");
                pout.println("</td>");
                pout.println("<td>");
                pout.print("Details");
                pout.println("</td>");
                pout.println("<td align='center'>");
                pout.print("Attempts");
                pout.println("</td>");
                pout.println("<td align='center'>");
                pout.print("Successes");
                pout.println("</td>");
                pout.println("<td align='center'>");
                pout.print("Fails");
                pout.println("</td>");
                pout.println("</tr>");
                int completeSuccesses = 0;
                boolean flip = true;
                boolean sflip = true;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PrintStream spout = new PrintStream(bout);
                Object object2 = this.status_LOCK;
                synchronized (object2) {
                    if (!this.finished) {
                        Object[] keys = this.statuses.keySet().toArray();
                        Arrays.sort(keys);
                        for (Object key : keys) {
                            String name = (String)key;
                            String status = (String)this.statuses.get(name);
                            if (status.trim().length() <= 0) continue;
                            if (flip) {
                                pout.println("<tr bgcolor='" + this.rowx1 + "'>");
                            } else {
                                pout.println("<tr bgcolor='" + this.rowx2 + "'>");
                            }
                            flip = !flip;
                            pout.println("<td>");
                            pout.print(name);
                            pout.println("</td>");
                            pout.println("<td colspan='4'>");
                            pout.print(status);
                            pout.println("</td>");
                            pout.println("</tr>");
                        }
                    }
                }
                for (int i = 0; i < entries.length; ++i) {
                    Entry entry = (Entry)entries[i];
                    totalCases += entry.attempts;
                    if (flip) {
                        pout.println("<tr bgcolor='" + this.row1 + "'>");
                    } else {
                        pout.println("<tr bgcolor='" + this.row2 + "'>");
                    }
                    flip = !flip;
                    pout.println("<td><b>");
                    pout.print(entry.name);
                    pout.println("</b></td>");
                    pout.println("<td>");
                    pout.print(entry.details);
                    pout.println("</td>");
                    pout.println("<td align='center'>");
                    pout.print(entry.attempts);
                    pout.println("</td>");
                    pout.println("<td align='center'>");
                    pout.print(entry.successes);
                    pout.println("</td>");
                    long inferred = entry.attempts - entry.successes;
                    if (this.finished || System.currentTimeMillis() > entry.allTimeoutAt || inferred == 0L) {
                        if (inferred > 0L) {
                            pout.println("<td align='center' bgcolor='" + this.fail + "'><b style='font-size: 150%'>");
                            pout.print(entry.attempts - entry.successes);
                            pout.println("</b>");
                            Entry entry2 = entry;
                            synchronized (entry2) {
                                for (int z = 0; z < entry.failLogs.size(); ++z) {
                                    pout.println("<br><a style='text-decoration: none' href='" + entry.failLogs.get(z) + "'>(log)</a>");
                                }
                            }
                            pout.println("</td>");
                        } else {
                            pout.println("<td align='center'>");
                            pout.print(entry.attempts - entry.successes);
                            pout.println("</td>");
                            ++completeSuccesses;
                        }
                    } else {
                        pout.println("<td align='center' bgcolor='" + this.maybe + "'>");
                        long rem = entry.allTimeoutAt - System.currentTimeMillis();
                        long mins = (rem /= 1000L) / 60L;
                        long secs = rem % 60L;
                        pout.print(inferred + "...? (" + mins + "m " + secs + "s)");
                        pout.println("</td>");
                    }
                    pout.println("</tr>");
                    if (entry.screen == null) continue;
                    if (sflip) {
                        spout.println("<tr bgcolor='" + this.rowx1 + "'>");
                    } else {
                        spout.println("<tr bgcolor='" + this.rowx2 + "'>");
                    }
                    sflip = !sflip;
                    spout.println("<td>");
                    spout.print(entry.name);
                    spout.println("</td>");
                    spout.println("<td>");
                    String fname = entry.name + ".png";
                    FileUtil.writeFile(new File(this.dir, fname), entry.screen);
                    spout.println();
                    spout.print("<a href='" + fname + "'><img border='0' height='250' src='" + fname + "'></a>");
                    spout.println("</td>");
                    spout.println("<td></td>");
                    spout.println("<td></td>");
                    spout.println("<td></td>");
                    spout.println("</tr>");
                }
                pout.println(new String(bout.toByteArray()));
                if (completeSuccesses == entries.length) {
                    completeSuccess = true;
                }
                pout.println("</table>");
                pout.println("</body>");
                pout.println("</html>");
                pout.close();
                if (!this.finished && completeSuccess && this.noMoreCases) {
                    if (this.finishAt == 0L) {
                        this.finishAt = System.currentTimeMillis() + 300000L;
                        this.finishCases = totalCases;
                    } else if (this.finishCases != totalCases) {
                        this.finishAt = 0L;
                    } else if (System.currentTimeMillis() > this.finishAt) {
                        this.terminateInternal(false);
                    }
                } else {
                    this.finishAt = 0L;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private void terminateInternal(boolean join) {
        this.finished = true;
        try {
            this.ssock.close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        if (join) {
            try {
                this.updatey.join();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        this.updateReport();
    }

    private void ongoingUpdateReport() {
    }

    static int getReportServerPort() {
        return Integer.parseInt(JWLaunchProperties.getProperty(JWA_REPORT_PORT));
    }

    private JWTesting(int twsPort) throws IOException {
        this.ssock = new ServerSocket(0);
        if (!JWLaunchProperties.isJWrapperSetup()) {
            JWLaunchProperties.setUpTestProperties();
        }
        JWLaunchProperties.overrideDynamicProperty(JWA_REPORT_PORT, "" + this.ssock.getLocalPort());
        System.out.println("[JWAutomation] Listening on " + this.ssock.getLocalPort());
        SSockThread sst = new SSockThread();
        sst.start();
        this.dir = new File("JWAutomation-" + this.sdf.format(new Date()));
        this.dir.mkdirs();
        this.report = new File(this.dir, "report.html");
        if (twsPort != -1) {
            this.tws = new JWAServer(twsPort, this.dir, false, "report.html");
        }
        this.updateReport();
        this.updatey = new UpdateThread();
        this.updatey.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void barrierReached(String name) {
        latestBarrierReached = name;
        Object object = barrier_LOCK;
        synchronized (object) {
            ++waitingAtBarrier;
            System.out.println("Waiting at barrier " + name + "...");
            try {
                barrier_LOCK.wait();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAllAtBarrier() {
        Object object = barrier_LOCK;
        synchronized (object) {
            waitingAtBarrier = 0;
            barrier_LOCK.notifyAll();
        }
    }

    public static String getLatestBarrierReached() {
        return latestBarrierReached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBarrierCount() {
        Object object = barrier_LOCK;
        synchronized (object) {
            return waitingAtBarrier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setSock(String host, int port) {
        Object object = reportSock_LOCK;
        synchronized (object) {
            if (reportSock != null) {
                try {
                    reportSock.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                reportSock = null;
            }
            JWLaunchProperties.overrideProperty(JWA_REPORT_HOST, host);
            JWLaunchProperties.overrideProperty(JWA_REPORT_PORT, "" + port);
            JWTesting.loadSock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSock() {
        if (!reportSockOK) {
            return;
        }
        Object object = reportSock_LOCK;
        synchronized (object) {
            if (reportSock == null) {
                try {
                    String host = JWLaunchProperties.getProperty(JWA_REPORT_HOST);
                    if (host.trim().length() == 0) {
                        host = "localhost";
                    }
                    int port = Integer.parseInt(JWLaunchProperties.getProperty(JWA_REPORT_PORT));
                    System.out.println("[JWTesting] Creating socket to test report server at " + host + ":" + port);
                    reportSock = new Socket(host, port);
                    reportDout = new DataOutputStream(new BufferedOutputStream(reportSock.getOutputStream()));
                    reportDin = new DataInputStream(new BufferedInputStream(reportSock.getInputStream()));
                    if (JWSystem.getMyLogFile() != null) {
                        reportDout.writeUTF(JWSystem.getMyLogFile().getAbsolutePath());
                    } else {
                        reportDout.writeUTF("ERROR_NO_LOGFILE");
                    }
                    new KeepaliveThread().start();
                    System.out.println("[JWTesting] Socket to report server at " + host + ":" + port + " set up and ready");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    reportSockOK = false;
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        JWLaunchProperties tests = JWLaunchProperties.setUpTestProperties();
        Properties props = new Properties();
        JWTesting jwa = JWTesting.createReportServer();
        jwa.prepareTestInstance(props);
        tests.addStaticProperty(JWA_REPORT_PORT, props.getProperty(JWA_REPORT_PORT));
        StdLogging.startLogging(new File("."), "JWTestingSampleLog");
        JWTesting.reportAttempt("Make Tea", "Will involve use of the kettle, could be risky", 10000);
        JWTesting.reportAttempt("Make Coffee", "Will involve use of the kettle, could be risky", 10000);
        JWTesting.reportSuccess("Make Tea");
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        frame.getContentPane().add(panel);
        JButton jb = new JButton("Do Something");
        panel.add(jb);
        jb.addActionListener(new ButtonListener());
        frame.setBounds(0, 0, 300, 150);
        frame.setVisible(true);
        JPopupMenu men = new JPopupMenu();
        men.add("onemenu");
        men.add("twomenu");
        men.show(panel, 0, 0);
        JWAutomate.hitMenu(frame, "twomenu");
        JWAutomate.hitButton(frame.getContentPane(), "omething");
        JWAutomate.dumpScreenshots(new Component[]{frame, men}, new File("dump.html"), false, new Class[0]);
        Thread.sleep(1000L);
    }

    public static void createFakeAllAppVersionsSharedFolder() {
        FAKE_CONFIG_FOLDER = "JWAppsSharedConfig_" + System.currentTimeMillis() % 100000L + "_" + (int)(Math.random() * 1.0E9);
    }

    public static void createFakeAllAppVersionsSharedFolder(String name) {
        FAKE_CONFIG_FOLDER = "JWAppsSharedConfig_" + name;
    }

    public int getHttpPort() {
        return this.tws.getPort();
    }

    public void openBrowser() throws IOException {
        Browser.openURL(new URL("http://localhost:" + this.getHttpPort()));
    }

    public void noMoreTestcases() {
        this.noMoreCases = true;
    }

    public void terminate() {
        this.terminateInternal(true);
    }

    public static JWTesting createReportServer() throws IOException {
        return JWTesting.createReportServer(5555);
    }

    public static JWTesting createReportServer(int webPort) throws IOException {
        JWTesting jwa = new JWTesting(webPort);
        JWTesting.setSock("localhost", jwa.ssock.getLocalPort());
        return jwa;
    }

    public void prepareTestInstance(Properties launchProperties) throws IOException {
        launchProperties.setProperty(JWA_REPORT_PORT, "" + this.ssock.getLocalPort());
    }

    public static boolean amTesting() {
        if (!JWLaunchProperties.isJWrapperSetup()) {
            return false;
        }
        return JWLaunchProperties.getProperty(JWA_REPORT_PORT).length() != 0;
    }

    public static boolean mustWaitAtBarrier(String name) {
        if (!JWLaunchProperties.isJWrapperSetup()) {
            return false;
        }
        return JWLaunchProperties.getProperty(JWA_REPORT_BARRIER).equalsIgnoreCase(name);
    }

    private static String normalise(String s) {
        return s.replace('\'', '_').replace('\"', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportAttempt(String name, String details, int timeoutFailMillis) {
        System.out.println("[JWTesting] Reporting attempt of " + name);
        name = JWTesting.normalise(name);
        if (details == null) {
            details = "";
        }
        JWTesting.loadSock();
        Object object = reportSock_LOCK;
        synchronized (object) {
            try {
                if (reportDout != null) {
                    reportDout.writeInt(JWA_MSG_ATTEMPT);
                    reportDout.writeUTF(name);
                    reportDout.writeUTF(details);
                    reportDout.writeInt(timeoutFailMillis);
                    reportDout.flush();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public static void reportStandaloneSuccess(String name) {
        JWTesting.reportAttempt(name, "", 90000);
        JWTesting.reportSuccess(name);
    }

    public static void reportStandaloneFail(String name, String desc) {
        JWTesting.reportAttempt(name, desc, 0);
    }

    public static void reportStandaloneFail(String name) {
        JWTesting.reportAttempt(name, "", 0);
    }

    public static void reportStandaloneFail(String name, Throwable err) {
        JWTesting.reportAttempt(name, StackTracer.getStacktrace(err), 0);
    }

    public static void reportStandaloneSuccess(String name, String desc) {
        JWTesting.reportAttempt(name, desc, 90000);
        JWTesting.reportSuccess(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportSuccess(String name) {
        System.out.println("[JWTesting] Reporting success of " + name);
        name = JWTesting.normalise(name);
        JWTesting.loadSock();
        Object object = reportSock_LOCK;
        synchronized (object) {
            try {
                if (reportDout != null) {
                    reportDout.writeInt(JWA_MSG_SUCCESS);
                    reportDout.writeUTF(name);
                    reportDout.flush();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportFail(String name, String details) {
        System.out.println("[JWTesting] Reporting FAILURE of " + name);
        name = JWTesting.normalise(name);
        JWTesting.loadSock();
        Object object = reportSock_LOCK;
        synchronized (object) {
            try {
                if (reportDout != null) {
                    reportDout.writeInt(JWA_MSG_FAIL);
                    reportDout.writeUTF(name);
                    reportDout.writeUTF(details);
                    reportDout.flush();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public static void countdownStatus(String name, String nextAction, int mins) {
        for (int zz = mins; zz > 0; --zz) {
            JWTesting.reportStatus(name, nextAction + " in " + zz + " mins");
            JWAutomate.sleepMins(1.0);
        }
    }

    public static boolean finishBarrierSet(String set) {
        return JWTesting.mayPauseAtBarrier(set, BARRIER_SET_COMPLETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mayPauseAtBarrier(String set, String name) {
        if (JWTesting.mustWaitAtBarrier(set)) {
            System.out.println("[JWTesting] Pausing at barrier " + name);
            JWTesting.loadSock();
            Object object = reportSock_LOCK;
            synchronized (object) {
                try {
                    if (reportDout != null) {
                        reportDout.writeInt(JWA_MSG_BARRIER);
                        reportDout.writeUTF(name);
                        reportDout.flush();
                        System.out.println("[JWTesting] Waiting for barrier notification...");
                        reportDin.read();
                        System.out.println("[JWTesting] Barrier notification received");
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportStatus(String name, String status) {
        System.out.println("[JWTesting] Reporting status: " + name + " = " + status);
        name = JWTesting.normalise(name);
        JWTesting.loadSock();
        Object object = reportSock_LOCK;
        synchronized (object) {
            try {
                if (reportDout != null) {
                    reportDout.writeInt(JWA_MSG_STATUS);
                    reportDout.writeUTF(name);
                    reportDout.writeUTF(status);
                    reportDout.flush();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public static void reportScreenshot(String name, JFrame frame, boolean standaloneSuccess) {
        JWTesting.reportScreenshot(name, frame.getContentPane(), standaloneSuccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportScreenshot(String name, Component comp, boolean standaloneSuccess) {
        if (standaloneSuccess) {
            System.out.println("[JWTesting] Reporting success of " + name);
        }
        JWTesting.loadSock();
        name = JWTesting.normalise(name);
        BufferedImage bimg = new BufferedImage(comp.getWidth() + 4, comp.getHeight() + 4, 2);
        Graphics g = bimg.getGraphics();
        try {
            SwingUtilities.invokeAndWait(new Painter(comp, g.create(1, 1, comp.getWidth(), comp.getHeight())));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        SimpleShadowBorder ssb = new SimpleShadowBorder(false);
        ssb.paintBorder(null, g, 0, 0, comp.getWidth() + 1, comp.getHeight() + 1);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bimg, "PNG", bout);
            Object object = reportSock_LOCK;
            synchronized (object) {
                if (reportDout != null) {
                    if (standaloneSuccess) {
                        reportDout.writeInt(JWA_MSG_ATTEMPT);
                        reportDout.writeUTF(name);
                        reportDout.writeUTF("");
                        reportDout.writeInt(5000);
                    }
                    reportDout.writeInt(JWA_MSG_SCREEN);
                    reportDout.writeUTF(name);
                    reportDout.writeInt(bout.size());
                    reportDout.write(bout.toByteArray());
                    if (standaloneSuccess) {
                        reportDout.writeInt(JWA_MSG_SUCCESS);
                        reportDout.writeUTF(name);
                    }
                    reportDout.flush();
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    static {
        reportSockOK = true;
        latestBarrierReached = "None";
        barrier_LOCK = new Object();
        waitingAtBarrier = 0;
        FAKE_CONFIG_FOLDER = null;
    }

    private static class Painter
    implements Runnable {
        Component comp;
        Graphics g;

        Painter(Component comp, Graphics g) {
            this.comp = comp;
            this.g = g;
        }

        public void run() {
            this.comp.paintAll(this.g);
        }
    }

    static class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Woot!");
        }
    }

    static class KeepaliveThread
    extends Thread {
        KeepaliveThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(15000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object = reportSock_LOCK;
                synchronized (object) {
                    try {
                        if (reportDout != null) {
                            reportDout.writeInt(JWA_MSG_KEEPALIVE);
                            reportDout.flush();
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
            }
        }
    }

    private class SockThread
    extends Thread {
        Object LOCK = new Object();
        HashMap localmap = new HashMap();
        String runLogFile;
        long lastKeepalive = JWConstantClock.currentTimeMillis();
        Socket sock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Entry getLocalEntry(String name) {
            Object object = this.LOCK;
            synchronized (object) {
                Entry entry = (Entry)this.localmap.get(name);
                if (entry == null) {
                    entry = new Entry();
                    entry.name = name;
                    this.localmap.put(name, entry);
                }
                return entry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkLocalFailures() {
            long time = JWConstantClock.currentTimeMillis();
            if (time - this.lastKeepalive > 120000L) {
                System.out.println("[JWAutomation] Test report socket silent for 2 mins, closing");
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            if (this.runLogFile == null) {
                return false;
            }
            Object object = this.LOCK;
            synchronized (object) {
                Object[] locals = this.localmap.values().toArray();
                for (int i = 0; i < locals.length; ++i) {
                    Entry local = (Entry)locals[i];
                    JWTesting.this.checkForLocalFailure(local, this.runLogFile);
                }
            }
            return false;
        }

        public SockThread(Socket sock) {
            this.sock = sock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                System.out.println("[Report] New instance connected back");
                DataInputStream din = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
                DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
                this.runLogFile = din.readUTF();
                while (true) {
                    int type = din.readInt();
                    String name = din.readUTF();
                    if (type == JWA_MSG_STATUS) {
                        String status = din.readUTF();
                        Object object = JWTesting.this.status_LOCK;
                        synchronized (object) {
                            JWTesting.this.statuses.put(name, status);
                        }
                    }
                    if (type == JWA_MSG_BARRIER) {
                        JWTesting.barrierReached(name);
                        dout.write(0);
                        dout.flush();
                        continue;
                    }
                    Entry entry = JWTesting.this.getEntry(name);
                    Entry local = this.getLocalEntry(name);
                    Object object = this.LOCK;
                    synchronized (object) {
                        System.out.println("[Report] New entry " + name + " map = " + JWTesting.this.map.size());
                    }
                    if (type == JWA_MSG_KEEPALIVE) {
                        this.lastKeepalive = JWConstantClock.currentTimeMillis();
                    } else if (type == JWA_MSG_ATTEMPT) {
                        entry.details = din.readUTF();
                        entry.details = StringReplace.replaceAll(entry.details, "\n ", "<br>&nbsp;");
                        entry.details = StringReplace.replaceAll(entry.details, "\n\t", "<br>&nbsp;");
                        entry.details = StringReplace.replaceAll(entry.details, "\n", "<br>");
                        entry.details = StringReplace.replaceAll(entry.details, "Exception", "<b>Exception</b>");
                        entry.details = StringReplace.replaceAll(entry.details, "Error", "<b>Error</b>");
                        int millis = din.readInt();
                        ++entry.attempts;
                        entry.allTimeoutAt = Math.max(entry.allTimeoutAt, System.currentTimeMillis() + (long)millis);
                        ++local.attempts;
                        local.allTimeoutAt = Math.max(entry.allTimeoutAt, System.currentTimeMillis() + (long)millis);
                    } else if (type == JWA_MSG_SUCCESS) {
                        ++entry.successes;
                        ++local.successes;
                    } else if (type != JWA_MSG_FAIL && type == JWA_MSG_SCREEN) {
                        object = this.LOCK;
                        synchronized (object) {
                            byte[] dat = new byte[din.readInt()];
                            din.readFully(dat);
                            entry.screen = dat;
                        }
                    }
                    JWTesting.this.ongoingUpdateReport();
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    private class FailThread
    extends Thread {
        SockThread st;

        public FailThread(SockThread st) {
            this.st = st;
        }

        public void run() {
            try {
                do {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (!this.st.checkLocalFailures());
                return;
            }
            catch (Exception x) {
                x.printStackTrace();
                return;
            }
        }
    }

    private class SSockThread
    extends Thread {
        private SSockThread() {
        }

        public void run() {
            try {
                while (true) {
                    Socket s = JWTesting.this.ssock.accept();
                    SockThread st = new SockThread(s);
                    st.start();
                    new FailThread(st).start();
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private class UpdateThread
    extends Thread {
        boolean die = false;

        private UpdateThread() {
        }

        public void run() {
            try {
                while (!JWTesting.this.finished) {
                    Thread.sleep(500L);
                    long T = System.currentTimeMillis();
                    JWTesting.this.updateReport();
                    T = System.currentTimeMillis() - T;
                    if (T <= 200L) continue;
                    System.out.println("Updatey " + T);
                    Thread.sleep(Math.min(5000L, T));
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    class JWAServer
    extends TinyWebServer {
        public JWAServer(int port, File base, boolean listDirs, String slashRedirect) throws IOException {
            super(port, base, listDirs, slashRedirect);
        }

        public boolean processResource(String res, boolean head) throws IOException {
            if (res.equals("terminate")) {
                System.out.println("[JWAutomation] Terminating report");
                JWTesting.this.terminate();
                this.respondRedirect(this.slashRedirect, head);
                return true;
            }
            return false;
        }
    }

    class EntryComparator
    implements Comparator {
        EntryComparator() {
        }

        public int compare(Object o1, Object o2) {
            Entry e1 = (Entry)o1;
            Entry e2 = (Entry)o2;
            return e1.name.compareTo(e2.name);
        }
    }

    private class Entry {
        String name;
        String details = "";
        long allTimeoutAt;
        long attempts;
        long successes;
        byte[] screen;
        int failsHandled = 0;
        ArrayList failLogs = new ArrayList();

        private Entry() {
        }

        public int getCertainFailures() {
            if (System.currentTimeMillis() > this.allTimeoutAt) {
                return (int)(this.attempts - this.successes);
            }
            return 0;
        }
    }
}

