/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSystem;
import utils.files.FileLockUtil;
import utils.stream.StreamUtils;

public class JWServiceApp {
    public static final String JWSERVICE_APP_FILE_PARAMETER = "jwservice_lockfile";
    public static final String VAPP_NAME = "JWrapper Service Management App";
    private File serviceFile;
    private FileLockUtil.LockResult lockResult;

    public void forceTerminateService(String serviceName) {
        try {
            int pid = this.getServicePid(serviceName);
            if (pid != -1) {
                System.out.println("[JWService] Terminating JWService " + serviceName + " with pid " + pid + " now");
                JWGenericOS.terminateProcess(pid);
            } else {
                System.out.println("[JWService] Unable to terminate the JWService, no pid found");
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public int getServicePid() {
        String value = JWSystem.getAppLaunchProperty(JWSERVICE_APP_FILE_PARAMETER);
        return this.getServicePid(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServicePid(String serviceName) {
        block10: {
            if (serviceName == null || serviceName.length() <= 0) {
                return -1;
            }
            this.serviceFile = new File(JWSystem.getAllAppVersionsSharedFolder(), serviceName + ".lock");
            if (this.serviceFile.exists()) {
                FileLockUtil.LockResult sharedLock = FileLockUtil.sharedLockFile(this.serviceFile, false);
                try {
                    int n;
                    FileInputStream fin = new FileInputStream(this.serviceFile);
                    try {
                        n = Integer.parseInt(StreamUtils.readAllAsString(fin));
                    }
                    catch (Throwable throwable) {
                        try {
                            fin.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            break block10;
                        }
                    }
                    fin.close();
                    return n;
                }
                finally {
                    FileLockUtil.releaseLock(sharedLock);
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStarted() {
        String value = JWSystem.getAppLaunchProperty(JWSERVICE_APP_FILE_PARAMETER);
        System.out.println("[JWServiceApp] Lock file is " + value);
        if (value != null && value.length() > 0) {
            this.serviceFile = new File(JWSystem.getAllAppVersionsSharedFolder(), value + ".lock");
        }
        if (this.serviceFile != null) {
            if (this.lockResult != null) {
                FileLockUtil.releaseLock(this.lockResult);
            }
            int pid = JWGenericOS.getInstance().getCurrentProcessID();
            String pidString = Integer.toString(pid);
            try {
                FileOutputStream fout = new FileOutputStream(this.serviceFile);
                try {
                    fout.write(pidString.getBytes("ASCII"));
                }
                finally {
                    fout.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("[JWServiceApp] Attempting to lock " + this.serviceFile);
            this.lockResult = FileLockUtil.sharedLockFile(this.serviceFile, false);
        } else {
            this.lockResult = null;
        }
    }

    public void serviceStopping() {
        if (this.lockResult != null) {
            FileLockUtil.releaseLock(this.lockResult);
        }
    }
}

