/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.hidden.events;

import jwrapper.jwutils.JWOSXEventListener;
import utils.progtools.collections.FixedSizeLinkedList;

public class JWMacOSEventManager
implements JWOSXEventListener {
    public static final JWMacOSEventManager INSTANCE = new JWMacOSEventManager();
    private FixedSizeLinkedList<String> urlRequestList = new FixedSizeLinkedList(10);
    private JWOSXEventListener urlHandler = null;

    private JWMacOSEventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openURL(String url) {
        if (url == null) {
            return;
        }
        System.out.println("[JWrapper] Received URL request: " + url + " to " + this);
        FixedSizeLinkedList<String> fixedSizeLinkedList = this.urlRequestList;
        synchronized (fixedSizeLinkedList) {
            if (this.urlHandler == null) {
                System.out.println("[JWrapper] No handler specified. Adding to list [" + this.urlRequestList.size() + "]");
                this.urlRequestList.put(url);
            } else {
                System.out.println("[JWrapper] Notifying handler " + this.urlHandler);
                this.urlHandler.openURL(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOSXEventListener(JWOSXEventListener listener) {
        System.out.println("[JWrapper] Setting OSX Event Listener: " + listener);
        FixedSizeLinkedList<String> fixedSizeLinkedList = this.urlRequestList;
        synchronized (fixedSizeLinkedList) {
            this.urlHandler = listener;
            while (!this.urlRequestList.isEmpty()) {
                this.urlHandler.openURL(this.urlRequestList.pop());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequestedURL() {
        FixedSizeLinkedList<String> fixedSizeLinkedList = this.urlRequestList;
        synchronized (fixedSizeLinkedList) {
            if (this.urlRequestList.size() > 0) {
                return this.urlRequestList.pop();
            }
            return null;
        }
    }
}

