/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.failover;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import jwrapper.failover.FailoverListener;
import jwrapper.failover.InfiniteDelayFailoverListener;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWApp;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.string.CharStack;
import utils.switches.Switches;

public class FailoverMonitor
extends Thread {
    static FailoverMonitor INSTANCE;
    static FailoverListener listener;
    public static boolean DEBUG_DISABLE;
    private URL url;
    private static final long DEFAULT_POLLING_DELAY = 10000L;

    private FailoverMonitor(URL url) {
        super("FailoverMonitor");
        this.url = url;
    }

    private static int getPathIndex(String url) {
        CharStack cs = new CharStack(url);
        cs.popUntil('/', false);
        cs.popUntil('/', false);
        cs.popUntil('/', false);
        return cs.getIndex();
    }

    private static String getFirst(String url) {
        return url.substring(0, FailoverMonitor.getPathIndex(url));
    }

    private static String getLast(String url) {
        return url.substring(FailoverMonitor.getPathIndex(url));
    }

    public static String make(String old, String next) {
        String first = FailoverMonitor.getFirst(next);
        if (!first.endsWith("/")) {
            first = first + "/";
        }
        return first + FailoverMonitor.getLast(old);
    }

    public static void main(String[] args) throws Exception {
        FailoverMonitor.doCheckNow(new URL("http://localhost/shtarget.txt"), new FailoverListener(){

            public long mustFailoverTo(String newURL, long maxDelay, long autoSwitchTimeMS) {
                return 60000L;
            }

            public void prepareForRelaunch(String newURL) {
            }
        });
    }

    private static File getFailoverUrlOverrideFile(File master) {
        File jwdir = JWApp.getJWAppsFolder(master);
        File override = new File(jwdir, GenericUpdater.getFailoverUrlOverrideFileName());
        return override;
    }

    public static void overrideFailoverURL(String urlstr) throws IOException {
        URL url;
        if (!Switches.SH_allowFailoverUrlOverride) {
            return;
        }
        if ((urlstr = urlstr.trim()).length() == 0) {
            url = null;
            System.out.println("[HAF] Override set to remove failover URL");
        } else {
            try {
                url = new URL(urlstr);
            }
            catch (IOException x) {
                System.out.println("[HAF] Unable to parse specified Failover URL (for override): [" + urlstr + "]");
                url = null;
            }
        }
        File appdir = JWSystem.getAppFolder();
        File master = appdir.getParentFile();
        File override = FailoverMonitor.getFailoverUrlOverrideFile(master);
        System.out.println("[HAF] Overriding failover URL to [" + url + "]");
        if (url == null) {
            FileUtil.writeFileAsStringUTF8(override.getAbsolutePath(), "");
            JWLaunchProperties.overrideProperty("failover_update_url", "");
        } else {
            FileUtil.writeFileAsStringUTF8(override.getAbsolutePath(), url.toString());
            JWLaunchProperties.overrideProperty("failover_update_url", url.toString());
        }
        if (INSTANCE != null) {
            FailoverMonitor.INSTANCE.url = url;
        }
    }

    private static URL getCheckURL() {
        String check = JWLaunchProperties.getProperty("failover_update_url");
        boolean overriden = false;
        if (Switches.SH_allowFailoverUrlOverride) {
            try {
                File appdir = JWSystem.getAppFolder();
                File master = appdir.getParentFile();
                File override = FailoverMonitor.getFailoverUrlOverrideFile(master);
                if (override.exists()) {
                    check = FileUtil.readFileAsStringUTF8(override);
                    overriden = true;
                }
            }
            catch (Exception x) {
                System.out.println("[HAF] Problems checking for Failover URL override: " + x);
            }
        }
        if (check == null) {
            System.out.println("[HAF] No Failover Check URL specified (" + (overriden ? "overriden" : "launchprops") + ")");
        } else if ((check = check.trim()).length() > 0) {
            System.out.println("[HAF] Using Failover Check URL " + check + " (" + (overriden ? "overriden" : "launchprops") + ")");
            try {
                URL url = new URL(check);
                return url;
            }
            catch (Exception x) {
                return null;
            }
        }
        return null;
    }

    public static void checkSetup(boolean startOngoing) {
        FailoverMonitor.checkSetup(startOngoing, null);
    }

    public static void checkSetup(boolean startOngoing, FailoverListener failListener) {
        if (DEBUG_DISABLE) {
            System.out.println("[FailoverMonitor] Debug: disabled");
            return;
        }
        URL url = FailoverMonitor.getCheckURL();
        if (url != null) {
            try {
                System.out.println("[HAF] Checking if immediate failover required...");
                FailoverMonitor.doCheckNow(url, failListener);
                System.out.println("[HAF] Immediate failover not required, setting up ongoing checks");
                if (startOngoing) {
                    FailoverMonitor.setup(url, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static TargetURL checkTargetURL() {
        URL url = FailoverMonitor.getCheckURL();
        return FailoverMonitor.getMyTargetURL(url, true);
    }

    private static TargetURL getMyTargetURL(URL url, boolean force) {
        TargetURL result = new TargetURL();
        try {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            Properties props = new Properties();
            props.load(new BufferedInputStream(conn.getInputStream()));
            result.maxWaitMS = -1L;
            try {
                String maxWaitString = props.getProperty("max-wait-mins");
                if (maxWaitString != null) {
                    result.maxWaitMS = Long.parseLong(maxWaitString) * 60L * 1000L;
                }
            }
            catch (Throwable maxWaitString) {
                // empty catch block
            }
            result.failoverSleepMS = 10000L;
            try {
                String failoverSleepString = props.getProperty("failover-sleep-secs");
                if (failoverSleepString != null) {
                    result.failoverSleepMS = Long.parseLong(failoverSleepString) * 1000L;
                }
            }
            catch (Throwable failoverSleepString) {
                // empty catch block
            }
            result.autoFailoverAfterMS = -1L;
            try {
                String autoFailoverAfter = props.getProperty("auto-switch-after-mins");
                if (autoFailoverAfter != null) {
                    result.autoFailoverAfterMS = Long.parseLong(autoFailoverAfter) * 60L * 1000L;
                }
            }
            catch (Throwable autoFailoverAfter) {
                // empty catch block
            }
            String myUpdateURL = JWSystem.getUpdateURL();
            String useLevel = "unknown";
            String myLevel = "unknown";
            String myAlias = "unknown";
            HashMap<String, HashMap<String, String>> levels = new HashMap<String, HashMap<String, String>>();
            try {
                useLevel = props.getProperty("use").trim();
                System.out.println("[HAF] Required: " + useLevel);
                System.out.println("[HAF] Max Wait (MS): " + result.maxWaitMS);
                System.out.println("[HAF] Auto Switch After (MS): " + result.autoFailoverAfterMS);
                Object[] keys = props.keySet().toArray();
                Arrays.sort(keys);
                for (int i = 0; i < keys.length; ++i) {
                    String key = (String)keys[i];
                    int index = key.indexOf(95);
                    if (index == -1) continue;
                    String curTarget = FailoverMonitor.make(myUpdateURL, props.getProperty(key));
                    String curLevel = key.substring(0, index);
                    String curAlias = key.substring(index + 1);
                    HashMap<String, String> level = (HashMap<String, String>)levels.get(curLevel);
                    if (level == null) {
                        level = new HashMap<String, String>();
                        levels.put(curLevel, level);
                    }
                    level.put(curAlias, curTarget);
                    if (curTarget.equals(myUpdateURL)) {
                        myLevel = curLevel;
                        myAlias = curAlias;
                        System.out.println("[HAF] *** " + key + "=" + curTarget + " (" + curAlias + "/" + curLevel + ")");
                        continue;
                    }
                    System.out.println("[HAF] " + key + "=" + curTarget + " (" + curAlias + "/" + curLevel + ")");
                }
                System.out.println("[HAF] Status: (alias:" + myAlias + ") " + myLevel + " vs " + useLevel);
                String switchTo = null;
                if (!useLevel.equals(myLevel) || force) {
                    switchTo = (String)((HashMap)levels.get(useLevel)).get(myAlias);
                    if (force) {
                        System.out.println("[HAF] Target server change forced (" + myAlias + " : " + myUpdateURL + " -> " + switchTo + ")");
                    } else {
                        System.out.println("[HAF] Target server changed (" + myAlias + " : " + myUpdateURL + " -> " + switchTo + ")");
                    }
                }
                result.switchTo = switchTo;
                return result;
            }
            catch (NullPointerException x) {
                System.out.println("[HAF] Problem reading properties " + x);
                x.printStackTrace();
            }
            catch (Exception x) {
                System.out.println("[HAF] Problem reading properties " + x);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return result;
    }

    public static long doCheckNow(URL url, FailoverListener listener) {
        TargetURL switchToTarget;
        block16: {
            switchToTarget = FailoverMonitor.getMyTargetURL(url, false);
            try {
                if (switchToTarget != null && switchToTarget.switchTo != null) {
                    String switchTo = switchToTarget.switchTo;
                    long maxWait = switchToTarget.maxWaitMS;
                    long autoSwitchAfterMS = switchToTarget.autoFailoverAfterMS;
                    long maxWaitTimestamp = -1L;
                    if (maxWait > -1L) {
                        maxWaitTimestamp = System.currentTimeMillis() + maxWait;
                    }
                    System.out.println("[HAF] Confirming with listener (" + switchTo + "," + maxWait + "," + autoSwitchAfterMS + "," + maxWaitTimestamp + ")...");
                    if (listener != null) {
                        long startTime = System.currentTimeMillis();
                        long T = listener.mustFailoverTo(switchTo, maxWaitTimestamp, autoSwitchAfterMS);
                        System.out.println("[HAF] Listener requested a delay of " + T);
                        if (listener instanceof InfiniteDelayFailoverListener) {
                            System.out.println("[HAF] Infinite Delay FailoverListener requested. Delaying...");
                            T = 600000L;
                            while (T > 0L) {
                                try {
                                    Thread.sleep(T);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (maxWait != 0L) {
                            System.out.println("[HAF] MaxWait is not zero");
                            long maxEndTime = maxWait > 0L ? startTime + maxWait : Long.MAX_VALUE;
                            while (T > 0L && System.currentTimeMillis() + T < maxEndTime) {
                                System.out.println("[HAF] Asked to postpone " + T + "ms");
                                try {
                                    Thread.sleep(T);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                T = listener.mustFailoverTo(switchTo, maxWaitTimestamp, autoSwitchAfterMS);
                            }
                            if (System.currentTimeMillis() + T > maxEndTime) {
                                System.out.println("[HAF] Time limit exceeded.");
                            }
                        } else {
                            System.out.println("[HAF] Not giving the option to postpone since maxWait == 0");
                        }
                    }
                    FailoverMonitor.relaunchToFailoverURL(switchTo, listener);
                    break block16;
                }
                System.out.println("[HAF] Switch not required (" + (switchToTarget == null ? switchToTarget : switchToTarget.switchTo) + ")");
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if (switchToTarget != null) {
            return switchToTarget.failoverSleepMS;
        }
        return 10000L;
    }

    public static void relaunchToFailoverURL(String switchTo, FailoverListener listener) throws Exception {
        System.out.println("[HAF] Relaunching now");
        JWLaunchProperties.overrideProperty("update_url", switchTo);
        if (listener != null) {
            System.out.println("[HAF] Preparing launch properties for relaunch.");
            listener.prepareForRelaunch(switchTo);
        }
        System.out.println("[HAF] Set my update URL to " + JWSystem.getUpdateURL());
        String appname = null;
        try {
            appname = JWApp.getMyVirtualApp().getUserVisibleName();
        }
        catch (Exception x) {
            System.out.println("[HAF] GU is forking, no virtual app");
        }
        JWSystem.forkVirtualApp(appname, null, null, false, true);
        System.out.println("[HAF] Exiting...");
        try {
            Thread.sleep(750L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    private static void setup(URL checkPage, FailoverListener listener) {
        if (INSTANCE == null) {
            INSTANCE = new FailoverMonitor(checkPage);
            INSTANCE.start();
            FailoverMonitor.listener = listener;
        }
    }

    public static void setListener(FailoverListener listener) {
        FailoverMonitor.listener = listener;
    }

    public void run() {
        while (true) {
            long nextSleep;
            if (this.url == null) {
                nextSleep = 10000L;
            } else {
                nextSleep = FailoverMonitor.doCheckNow(this.url, listener);
                if (nextSleep < 10000L) {
                    nextSleep = 10000L;
                }
            }
            try {
                Thread.sleep(nextSleep);
            }
            catch (Exception exception) {
            }
        }
    }

    static {
        DEBUG_DISABLE = false;
    }

    public static class TargetURL {
        public String switchTo;
        public long maxWaitMS = -1L;
        public long autoFailoverAfterMS;
        public long failoverSleepMS = 10000L;

        public String toString() {
            return this.switchTo + " [" + this.maxWaitMS + "]";
        }
    }
}

