/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.compression.splitcompressor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jwrapper.compression.splitcompressor.ByteArrayStruct;
import jwrapper.compression.splitcompressor.FilePart;
import jwrapper.compression.splitcompressor.WholeFile;
import utils.files.FileUtil;
import utils.progtools.Cache;
import utils.progtools.DataUtil;
import utils.stream.StreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSegment
implements Comparable<FileSegment> {
    ArrayList<FilePart> parts = new ArrayList();
    int wholeFileSegmendStartIndex;
    int segmentLength;
    public WholeFile wholeFile;
    public boolean deleted = false;
    public long wholeFileSizeBeforeUnpack = -1L;
    private static Cache<File, byte[]> fileCache = new Cache("FileCache", 1);
    static long totalReads = 0L;

    public String toString() {
        if (this.wholeFileSizeBeforeUnpack == -1L) {
            return "Segment @ " + this.wholeFileSegmendStartIndex + " len=" + this.segmentLength;
        }
        return "Segment @ " + this.wholeFileSegmendStartIndex + " len=" + this.segmentLength + " wholefileSize=" + this.wholeFileSizeBeforeUnpack;
    }

    @Override
    public int compareTo(FileSegment o) {
        return DataUtil.compare(this.wholeFileSegmendStartIndex, o.wholeFileSegmendStartIndex);
    }

    private void addToCache(File file, byte[] data) {
        fileCache.addToCache(file, data);
    }

    private byte[] read(File f) throws IOException {
        byte[] data = fileCache.getFromCache(f);
        if (data != null) {
            return data;
        }
        data = FileUtil.readFile(f);
        fileCache.addToCache(f, data);
        return data;
    }

    public static void clearCachedFile() {
        fileCache.clear();
        fileCache = null;
    }

    public void unpackParts(ByteArrayStruct bStruct) throws IOException {
        int segmentOffset = this.wholeFileSegmendStartIndex;
        for (int partIndex = this.parts.size() - 1; partIndex >= 0; --partIndex) {
            FilePart part = this.parts.get(partIndex);
            byte[] data = this.read(part.subFile.file);
            System.out.println("\t[FileSegment] Source is " + part.subFile.file.getName());
            part.unpackTo(this.wholeFile, bStruct, data, segmentOffset);
            segmentOffset += part.length;
        }
        System.gc();
    }

    public void dumpDebug() {
        System.out.println("\tFileSegment: @ " + this.wholeFileSegmendStartIndex + " len=" + this.segmentLength);
        for (FilePart part : this.parts) {
            part.dumpDebug();
        }
    }

    public void writeTo(BufferedOutputStream bout, File baseDir) throws IOException {
        StreamUtils.writeInt(bout, this.wholeFileSegmendStartIndex);
        StreamUtils.writeInt(bout, this.segmentLength);
        StreamUtils.writeLong(bout, this.wholeFileSizeBeforeUnpack);
        StreamUtils.writeInt(bout, this.parts.size());
        for (FilePart part : this.parts) {
            part.writeTo(bout, baseDir);
        }
    }

    public void readFrom(BufferedInputStream bin, File baseDir) throws IOException {
        this.wholeFileSegmendStartIndex = StreamUtils.readInt(bin);
        this.segmentLength = StreamUtils.readInt(bin);
        this.wholeFileSizeBeforeUnpack = StreamUtils.readLong(bin);
        int count = StreamUtils.readInt(bin);
        for (int i = 0; i < count; ++i) {
            FilePart part = new FilePart();
            part.segment = this;
            part.readFrom(bin, baseDir);
            this.parts.add(part);
        }
    }

    public boolean contains(FileSegment segment) {
        long start1 = this.wholeFileSegmendStartIndex;
        long start2 = segment.wholeFileSegmendStartIndex;
        long end1 = this.wholeFileSegmendStartIndex + this.segmentLength;
        long end2 = segment.wholeFileSegmendStartIndex + segment.segmentLength;
        return start1 <= start2 && end1 >= end2;
    }
}

