/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.compression.splitcompressor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jwrapper.compression.splitcompressor.ByteArrayStruct;
import jwrapper.compression.splitcompressor.EmptySubFile;
import jwrapper.compression.splitcompressor.FileSegment;
import jwrapper.compression.splitcompressor.SubFile;
import jwrapper.compression.splitcompressor.WholeFile;
import utils.progtools.DataUtil;
import utils.stream.StreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePart
implements Comparable<FilePart> {
    SubFile subFile;
    int partIndex;
    int length;
    public FileSegment segment;
    private static long total;

    @Override
    public int compareTo(FilePart o) {
        if (this.partIndex == o.partIndex) {
            return DataUtil.compare(this.length, o.length);
        }
        return DataUtil.compare(this.partIndex, o.partIndex);
    }

    public int getEndIndex() {
        return this.partIndex + this.length;
    }

    public boolean contains(FilePart part) {
        return this.partIndex <= part.partIndex && this.getEndIndex() >= part.getEndIndex();
    }

    public String toString() {
        return this.partIndex + " Len=" + this.length;
    }

    public boolean equals(FilePart p) {
        return this.partIndex == p.partIndex && this.length == p.length;
    }

    public void unpackTo(WholeFile wholeFile, ByteArrayStruct bStruct, byte[] entireSubFile, int segmentOffset) throws IOException {
        if (this.length == entireSubFile.length) {
            bStruct.insert(entireSubFile, segmentOffset);
        } else {
            System.out.println("\t [FilePart] Unpacking " + this.length + " bytes from " + entireSubFile.length + "@" + this.partIndex);
            byte[] newData = new byte[this.length];
            System.arraycopy(entireSubFile, this.partIndex, newData, 0, this.length);
            bStruct.insert(newData, segmentOffset);
        }
    }

    public void unpackTo(WholeFile wholeFile, byte[] entireSubFile, int segmentOffset, long bytesAlreadyWritten) throws IOException {
        if (bytesAlreadyWritten < 0L) {
            System.out.println("[FilePart] WARNING: The required file size is smaller than the actual file size!");
            return;
        }
        if (bytesAlreadyWritten >= (long)this.length) {
            return;
        }
        if (bytesAlreadyWritten > 0L) {
            System.out.println("[FilePart] WARNING: A partial skip. This is not expected.");
        }
        this.insertIntoFileAtomicallyInMemory(wholeFile.file, (long)segmentOffset + bytesAlreadyWritten, entireSubFile, (int)((long)this.partIndex + bytesAlreadyWritten), (int)((long)this.length - bytesAlreadyWritten));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoFileAtomicallyInMemory(File modify, long insert, byte[] insertData, int off, int len) throws IOException {
        long tailLen = modify.length() - insert;
        byte[] tailData = new byte[(int)tailLen];
        RandomAccessFile raf = new RandomAccessFile(modify, "rw");
        try {
            raf.seek(insert);
            raf.readFully(tailData);
            raf.seek(insert);
            raf.write(insertData, off, len);
            raf.write(tailData);
            raf.setLength(raf.getFilePointer());
        }
        finally {
            raf.close();
        }
    }

    public void dumpDebug() {
        System.out.println("\t\tFilePart [" + this.subFile.file.getName() + ": @ " + this.partIndex + " len=" + this.length);
    }

    public void writeTo(BufferedOutputStream bout, File baseDir) throws IOException {
        StreamUtils.writeInt(bout, this.partIndex);
        StreamUtils.writeInt(bout, this.length);
        if (this.subFile instanceof EmptySubFile) {
            StreamUtils.writeBoolean(bout, true);
        } else {
            StreamUtils.writeBoolean(bout, false);
            this.subFile.writeTo(bout, baseDir);
        }
    }

    public void readFrom(BufferedInputStream bin, File baseDir) throws IOException {
        this.partIndex = StreamUtils.readInt(bin);
        this.length = StreamUtils.readInt(bin);
        boolean isEmpty = StreamUtils.readBoolean(bin);
        if (isEmpty) {
            this.subFile = new EmptySubFile();
        } else {
            this.subFile = new SubFile();
            this.subFile.readFrom(bin, baseDir);
        }
    }
}

