/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.appletwrapper;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Date;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jwrapper.InsideApplet;
import jwrapper.allplatformwrapper.APWrapperListener;
import jwrapper.allplatformwrapper.AllPlatformWrapper;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWWindowsOS;
import utils.ostools.SaveDir;
import utils.progtools.URIUtil;
import utils.stream.StreamPiper;
import utils.stream.StreamUtils;
import utils.string.Base64;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.images.ImageHelper;

public class JWAppletWrapper
extends JApplet
implements APWrapperListener {
    boolean loaded = false;
    boolean stopped = false;
    String updateURL;
    File master;
    AllPlatformWrapper apw;
    String gu_version;
    Object START_LOCK = new Object();
    long started;
    LaunchButton button;
    private String launchText;
    static boolean extractedJWNativeAPI = false;
    private Properties staticProperties;
    private Object propertiesLock = new Object();
    Properties cmdlineProps;
    String cmdlineBase64png;
    String cmdlineApp;
    boolean cmdlineMatch;
    String cmdlineInstallType;
    String cmdlineURL;
    Launch launch;

    public JWAppletWrapper() {
        System.out.println("[JWAppletWrapper] New JWAppletWrapper - " + new Date());
        try {
            this.setFocusPolicy();
        }
        catch (Throwable t) {
            System.out.println("[JWAppletWrapper] Unable to set focus traversal policy provider.");
        }
    }

    private void setFocusPolicy() throws Throwable {
        Method method = JApplet.class.getMethod("setFocusTraversalPolicyProvider", Boolean.TYPE);
        method.invoke((Object)this, new Boolean(false));
    }

    public void init() {
        if (this.stopped) {
            return;
        }
        try {
            System.setSecurityManager(new SecurityManager(){

                public void checkPermission(Permission perm) {
                }

                public void checkPermission(Permission perm, Object context) {
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.extractAndLoadJWNativeAPI();
    }

    public void stop() {
    }

    public void destroy() {
        this.stopped = true;
        try {
            this.getContentPane().removeAll();
        }
        catch (Exception t) {
            t.printStackTrace();
        }
    }

    public void launchNow() {
        this.launch.launchNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractAndLoadJWNativeAPI() {
        block9: {
            if (!extractedJWNativeAPI) {
                String libname = JWNativeAPI.getAppropriateLibName(true);
                System.out.println("[JWAppletWrapper] Trying to load JWNativeAPI lib " + libname);
                try {
                    InputStream libStream = this.getClass().getResourceAsStream("/" + libname);
                    if (libStream == null) {
                        System.out.println("[JWAppletWrapper] native lib " + libname + " is not present on classpath, presumably it is not required for APW installs on this platform");
                        break block9;
                    }
                    System.out.println("[JWAppletWrapper] Found input stream for win lib: " + libStream);
                    File tmpdir = new File(System.getProperty("java.io.tmpdir"));
                    File tmpfile = new File(tmpdir, "jwapplet_wrapper_" + libname);
                    try {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpfile));
                        StreamPiper.pipe(libStream, out, true, false, false);
                        ((OutputStream)out).close();
                    }
                    catch (Throwable tt) {
                        tt.printStackTrace();
                    }
                    finally {
                        libStream.close();
                    }
                    System.load(tmpfile.getAbsoluteFile().getCanonicalPath());
                    System.out.println("[JWAppletWrapper] Loaded JWNativeAPI lib " + libname + " OK");
                }
                catch (Throwable t) {
                    System.out.println("[JWAppletWrapper] Unable to load win lib from jar.");
                    t.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStaticProperty(String key) {
        Object object = this.propertiesLock;
        synchronized (object) {
            if (this.staticProperties != null) {
                return this.staticProperties.getProperty(key);
            }
            this.staticProperties = new Properties();
            try {
                InputStream propertiesStream = this.getClass().getResourceAsStream("/static.properties");
                System.out.println("[JWAppletWrapper] Found input stream for static properties: " + propertiesStream);
                this.staticProperties.loadFromXML(propertiesStream);
                System.out.println("[JWAppletWrapper] Loaded static properties.");
                for (Object kkey : this.staticProperties.keySet()) {
                    System.out.println(kkey + " = " + this.staticProperties.get(kkey));
                }
            }
            catch (Throwable t) {
                System.out.println("[JWAppletWrapper] Unable to load static properties from jar.");
                t.printStackTrace();
            }
            return this.staticProperties.getProperty(key);
        }
    }

    public void setCmdlineLaunchProps(Properties props) {
        this.cmdlineProps = props;
    }

    public void setCmdlineBase64SplashPNG(String image) {
        this.cmdlineBase64png = image;
    }

    public void setCmdlineApp(String app, boolean match, String install) {
        this.cmdlineApp = app;
        this.cmdlineMatch = match;
        this.cmdlineInstallType = install;
    }

    public void setCmdlineURL(String url) {
        this.cmdlineURL = url;
    }

    public void start() {
        InsideApplet.INSIDE_APPLET = true;
        this.loadProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties() {
        try {
            boolean autoLaunch;
            String bottomColor;
            String topColor;
            this.getContentPane().setBackground(Color.white);
            if (this.stopped) {
                return;
            }
            this.started = System.currentTimeMillis();
            Object object = this.START_LOCK;
            synchronized (object) {
                if (this.loaded) {
                    System.out.println("[JWAppletWrapper] Minor Warning: had to ignore start call");
                    return;
                }
                this.loaded = true;
            }
            if (InsideApplet.INSIDE_APPLET) {
                this.launchText = this.getParameter("txt_launchnow");
                topColor = this.getParameter("gradientTop");
                bottomColor = this.getParameter("gradientBottom");
                this.updateURL = this.getParameter("update_url");
                String temp = this.getParameter("auto_run");
                autoLaunch = temp != null && Boolean.parseBoolean(temp);
            } else {
                topColor = null;
                bottomColor = null;
                this.updateURL = this.cmdlineURL;
                autoLaunch = false;
            }
            String appName = this.getStaticProperty("app_name");
            String minSplash = this.getStaticProperty("min_splash_ms");
            String matchVersions = this.getStaticProperty("match_versions");
            String installType = this.getStaticProperty("install_type");
            String reqJavaVersion = this.getStaticProperty("java_version");
            boolean canOverrideSplash = false;
            String dynamicBase64PNGSplash = null;
            String canOverrideSplashStr = this.getStaticProperty("can_override_splash");
            if (canOverrideSplashStr != null && canOverrideSplashStr.equals("1")) {
                canOverrideSplash = true;
            }
            if (canOverrideSplash) {
                if (InsideApplet.INSIDE_APPLET) {
                    System.out.println("[JWAppletWrapper] Can override splash. Checking for embeded image URL...");
                    String imageURL = this.getParameter("splash_image");
                    if (imageURL != null) {
                        System.out.println("[JWAppletWrapper] Found URL " + imageURL);
                        dynamicBase64PNGSplash = this.downloadAndEncodeImage(imageURL);
                    }
                } else {
                    dynamicBase64PNGSplash = this.cmdlineBase64png;
                }
            }
            if (!InsideApplet.INSIDE_APPLET && this.cmdlineApp != null) {
                appName = this.cmdlineApp;
                matchVersions = "" + this.cmdlineMatch;
                installType = this.cmdlineInstallType;
                System.out.println("[JWAppletWrapper] Switching app to " + appName + " (match=" + matchVersions + ") (type=" + installType + ")");
            }
            if (this.updateURL.endsWith("/")) {
                this.updateURL = this.updateURL.substring(0, this.updateURL.length() - 1);
            }
            System.out.println("[JWAppletWrapper] Update URL is: " + this.updateURL);
            this.launch = new Launch();
            if (InsideApplet.INSIDE_APPLET) {
                Container pane = this.getContentPane();
                pane.setLayout(new BorderLayout());
                this.button = new LaunchButton(topColor, bottomColor);
                pane.add("Center", this.button);
                this.button.setEnabled(false);
                this.button.setProgressOn(true);
                this.button.setProgress(0.0);
                this.button.addMouseListener(this.launch);
            }
            Properties lprops = new Properties();
            if (this.cmdlineProps != null) {
                lprops = this.cmdlineProps;
            }
            try {
                this.transferAppletParameters(lprops);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.apw = new AllPlatformWrapper(appName, this.updateURL, installType, canOverrideSplash, dynamicBase64PNGSplash, matchVersions.trim().equalsIgnoreCase("true"), lprops, false, reqJavaVersion);
            this.apw.setAPWrapperListener(this);
            this.master = new File(SaveDir.getUserSpecificSaveDirWithSlash("JWrapper-" + appName, new SaveDir.WindowPathResolver(){

                public String getShortNameFor(String fullPath) {
                    System.out.println("[AllPlatformWrapper] Requesting short name for " + fullPath);
                    JWWindowsOS winOS = new JWWindowsOS();
                    return winOS.getShortPathFormatFor(fullPath);
                }

                public String getEnv(String env, boolean getShortPath) {
                    JWWindowsOS winOS = new JWWindowsOS();
                    if (getShortPath) {
                        return winOS.getEnvShortPath(env);
                    }
                    return winOS.getEnvironmentVariable(env);
                }
            }));
            System.out.println("[JWAppletWrapper] JWrapper folder is = " + this.master);
            if (InsideApplet.INSIDE_APPLET) {
                new MainRun(autoLaunch).start();
            } else {
                new MainRun(autoLaunch).run();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void transferAppletParameters(Properties lprops) {
        try {
            String parameter = this.getParameter("jwParameterList");
            if (parameter == null) {
                return;
            }
            String[] parameters = parameter.split("\\,");
            for (int i = 0; i < parameters.length; ++i) {
                String name = parameters[i].trim();
                String value = this.getParameter(name);
                System.out.println("[JWAppletWrapper] Transferring applet parameter " + name + "=" + value);
                lprops.setProperty(name, value);
            }
        }
        catch (NullPointerException x) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadAndEncodeImage(String imageURL) {
        String string;
        System.out.println("[JWAppletWrapper] Downloading image...");
        URL url = new URL(imageURL);
        url = URIUtil.tryGetSafeURLFrom(url);
        URLConnection openConnection = url.openConnection();
        InputStream inputStream = openConnection.getInputStream();
        try {
            byte[] readAll = StreamUtils.readAll(inputStream);
            try {
                BufferedImage readImage = ImageIO.read(new ByteArrayInputStream(readAll));
                readImage = ImageHelper.scaleDownToFitInside(readImage, 300, 200);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)readImage, "png", bout);
                readAll = bout.toByteArray();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println("[JWAppletWrapper] Read " + readAll.length + " bytes");
            string = Base64.byteArrayToBase64(readAll);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Throwable t) {
                System.out.println("[JWAppletWrapper] Unable to load image '" + imageURL + "'");
                t.printStackTrace();
                return null;
            }
        }
        inputStream.close();
        return string;
    }

    public void canLaunch() {
        if (InsideApplet.INSIDE_APPLET) {
            this.button.setProgressOn(false);
            this.button.setEnabled(true);
            this.button.setText(this.launchText);
            this.repaint();
        }
    }

    public void setDownloadProgress(double d) {
        if (InsideApplet.INSIDE_APPLET) {
            this.button.setProgress(d);
        }
    }

    static class Repainter
    implements Runnable {
        private Component c;

        public Repainter(Component c) {
            this.c = c;
        }

        public void run() {
            this.c.repaint();
        }
    }

    private class MainRun
    extends Thread {
        private boolean autoLaunch;

        public MainRun(boolean autoLaunch) {
            this.autoLaunch = autoLaunch;
        }

        public void run() {
            try {
                JWAppletWrapper.this.apw.prepareForLaunch();
                if (this.autoLaunch) {
                    JWAppletWrapper.this.launch.actionPerformed(null);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                JWAppletWrapper.this.repaint();
            }
        }
    }

    class Launcher
    extends Thread {
        Launcher() {
        }

        public void run() {
            try {
                JWAppletWrapper.this.apw.launchNow();
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
        }
    }

    class Launch
    implements ActionListener,
    MouseListener {
        boolean haveLaunched = false;

        Launch() {
        }

        public void launchNow() {
            if (!this.haveLaunched) {
                this.haveLaunched = true;
                new Launcher().start();
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.launchNow();
            JWAppletWrapper.this.button.setEnabled(false);
            JWAppletWrapper.this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.actionPerformed(null);
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    class LaunchButton
    extends JPanel {
        private Color top;
        private Color bottom;
        private boolean progressOn = false;
        private double progress = 0.0;
        private JLabel textLabel;

        public LaunchButton(String topColor, String bottomColor) {
            try {
                this.top = this.decodeColor(topColor);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.top = new Color(224, 234, 254);
            }
            try {
                this.bottom = this.decodeColor(bottomColor);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.bottom = new Color(191, 212, 252);
            }
            this.setLayout(new BorderLayout());
            this.textLabel = new JLabel();
            this.textLabel.setBorder(SHBorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.add("West", this.textLabel);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        private Color decodeColor(String color) {
            if (color.indexOf(44) != -1) {
                while (color.length() > 0 && !Character.isDigit(color.charAt(0))) {
                    color = color.substring(1);
                }
                while (color.length() > 0 && !Character.isDigit(color.charAt(color.length() - 1))) {
                    color = color.substring(0, color.length() - 1);
                }
                String[] rgb = color.split(",");
                int r = Integer.parseInt(rgb[0].trim());
                int g = Integer.parseInt(rgb[1].trim());
                int b = Integer.parseInt(rgb[2].trim());
                return new Color(r, g, b);
            }
            return Color.decode(color);
        }

        public void setProgress(double d) {
            this.progress = d;
            this.repaint();
        }

        public void setProgressOn(boolean b) {
            this.progressOn = b;
            this.repaint();
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.textLabel.setEnabled(b);
            if (!b) {
                this.setCursor(Cursor.getDefaultCursor());
            } else {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
            this.repaint();
        }

        public void setText(String text) {
            this.textLabel.setText(text);
        }

        private double getLuminance(Color color) {
            return 0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue();
        }

        private Color covertToGray(Color color) {
            double luminance = this.getLuminance(color);
            int g = (int)Math.round(luminance);
            if (g < 150) {
                g = 200;
            }
            return new Color(g, g, g);
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics.create();
            GradientPaint gradientPaint = this.isEnabled() ? new GradientPaint(0.0f, 0.0f, this.top, 0.0f, this.getHeight(), this.bottom) : new GradientPaint(0.0f, 0.0f, this.covertToGray(this.top), 0.0f, this.getHeight(), this.covertToGray(this.bottom));
            g.setPaint(gradientPaint);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.progressOn) {
                int leftBuffer = 4;
                int arc = 2;
                int bottomBuffer = 7;
                int height = 4;
                height = 6;
                arc = height / 2;
                bottomBuffer = this.getHeight() / 2 + height / 2;
                g.setColor(Color.WHITE);
                g.fillRoundRect(leftBuffer, this.getHeight() - bottomBuffer, this.getWidth() - 2 * leftBuffer - 1, height, arc, arc);
                g.setColor(Color.LIGHT_GRAY);
                int width = (int)(this.progress * (double)(this.getWidth() - 2 * leftBuffer - 1));
                g.fillRoundRect(leftBuffer, this.getHeight() - bottomBuffer, width, height, arc, arc);
                g.setColor(Color.LIGHT_GRAY);
                g.drawRoundRect(leftBuffer, this.getHeight() - bottomBuffer, this.getWidth() - 2 * leftBuffer - 1, height, arc, arc);
            }
        }
    }
}

